/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jflex.core.Action;
import jflex.core.Macros;
import jflex.core.RegExp;
import jflex.core.SemCheck;
import jflex.core.unicode.CharClasses;
import jflex.core.unicode.IntCharSet;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;

public class RegExps {
    private final List<Integer> lines;
    private final List<List<Integer>> states = new ArrayList<List<Integer>>();
    private List<RegExp> regExps = new ArrayList<RegExp>();
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Boolean> BOL = new ArrayList<Boolean>();
    private List<RegExp> look = new ArrayList<RegExp>();
    private final List<Integer> look_entry;
    int gen_look_count;

    public RegExps() {
        this.lines = new ArrayList<Integer>();
        this.look_entry = new ArrayList<Integer>();
    }

    public int insert(int line, List<Integer> stateList, RegExp regExp, Action action, Boolean isBOL, RegExp lookAhead) {
        this.states.add(stateList);
        this.regExps.add(regExp);
        this.actions.add(action);
        this.BOL.add(isBOL);
        this.look.add(lookAhead);
        this.lines.add(line);
        this.look_entry.add(null);
        return this.states.size() - 1;
    }

    public int insert(List<Integer> stateList, Action action) {
        this.states.add(stateList);
        this.regExps.add(null);
        this.actions.add(action);
        this.BOL.add(null);
        this.look.add(null);
        this.lines.add(null);
        this.look_entry.add(null);
        return this.states.size() - 1;
    }

    public void addStates(int regNum, List<Integer> newStates) {
        this.states.get(regNum).addAll(newStates);
    }

    public int getNum() {
        return this.states.size();
    }

    public boolean isBOL(int num) {
        return this.BOL.get(num);
    }

    public RegExp getLookAhead(int num) {
        return this.look.get(num);
    }

    public boolean isEOF(int num) {
        return this.BOL.get(num) == null;
    }

    public List<Integer> getStates(int num) {
        return this.states.get(num);
    }

    public RegExp getRegExp(int num) {
        return this.regExps.get(num);
    }

    public int getLine(int num) {
        return this.lines.get(num);
    }

    public int getLookEntry(int num) {
        return this.look_entry.get(num);
    }

    public void checkActions() {
        if (this.actions.get(this.actions.size() - 1) == null) {
            Out.error(ErrorMessages.NO_LAST_ACTION);
            throw new GeneratorException();
        }
    }

    public Action getAction(int num) {
        while (num < this.actions.size() && this.actions.get(num) == null) {
            ++num;
        }
        return this.actions.get(num);
    }

    public int NFASize(Macros macros) {
        int size = 0;
        for (RegExp r : this.regExps) {
            if (r == null) continue;
            size += r.size(macros);
        }
        for (RegExp r : this.look) {
            if (r == null) continue;
            size += r.size(macros);
        }
        return size;
    }

    public void checkLookAheads() {
        for (int i = 0; i < this.regExps.size(); ++i) {
            this.lookAheadCase(i);
        }
    }

    private void lookAheadCase(int regExpNum) {
        if (this.getLookAhead(regExpNum) != null) {
            RegExp r1 = this.getRegExp(regExpNum);
            RegExp r2 = this.getLookAhead(regExpNum);
            Action a = this.getAction(regExpNum);
            if (a == null) {
                throw new NullPointerException("Action is null, this should not be possible");
            }
            int len1 = SemCheck.length(r1);
            int len2 = SemCheck.length(r2);
            if (len1 >= 0) {
                a.setLookAction(Action.Kind.FIXED_BASE, len1);
            } else if (len2 >= 0) {
                a.setLookAction(Action.Kind.FIXED_LOOK, len2);
            } else if (SemCheck.isFiniteChoice(r2)) {
                a.setLookAction(Action.Kind.FINITE_CHOICE, 0);
            } else {
                a.setLookAction(Action.Kind.GENERAL_LOOK, 0);
                this.look_entry.set(regExpNum, this.gen_look_count);
                ++this.gen_look_count;
            }
        }
    }

    public void normaliseMacros(Macros m) {
        ArrayList<RegExp> newRegExps = new ArrayList<RegExp>();
        ArrayList<RegExp> newLook = new ArrayList<RegExp>();
        for (RegExp r : this.regExps) {
            newRegExps.add(r == null ? r : r.normaliseMacros(m));
        }
        for (RegExp r : this.look) {
            newLook.add(r == null ? r : r.normaliseMacros(m));
        }
        this.regExps = newRegExps;
        this.look = newLook;
    }

    public void normaliseCCLs(File f) {
        ArrayList<RegExp> newRegExps = new ArrayList<RegExp>();
        ArrayList<RegExp> newLook = new ArrayList<RegExp>();
        for (int i = 0; i < this.regExps.size(); ++i) {
            Action a = this.getAction(i);
            int line = a == null ? -1 : a.priority - 1;
            RegExp r = this.regExps.get(i);
            newRegExps.add(r == null ? r : r.normaliseCCLs(f, line));
            r = this.look.get(i);
            newLook.add(r == null ? r : r.normaliseCCLs(f, line));
        }
        this.regExps = newRegExps;
        this.look = newLook;
    }

    public void expandPreClasses(Map<Integer, IntCharSet> preclassCache, CharClasses charClasses, boolean caseless) {
        ArrayList<RegExp> newRegExps = new ArrayList<RegExp>();
        ArrayList<RegExp> newLook = new ArrayList<RegExp>();
        for (RegExp r : this.regExps) {
            newRegExps.add(r == null ? r : r.expandPreClasses(preclassCache, charClasses, caseless));
        }
        for (RegExp r : this.look) {
            newLook.add(r == null ? r : r.expandPreClasses(preclassCache, charClasses, caseless));
        }
        this.regExps = newRegExps;
        this.look = newLook;
    }

    public void dump() {
        Out.dump("RegExp rules:");
        for (RegExp r : this.regExps) {
            if (r == null) continue;
            Out.dump(r.toString());
        }
    }

    public void makeCCLs(CharClasses classes, boolean caseless) {
        for (RegExp r : this.regExps) {
            if (r == null) continue;
            r.makeCCLs(classes, caseless);
        }
        for (RegExp r : this.look) {
            if (r == null) continue;
            r.makeCCLs(classes, caseless);
        }
    }
}

