/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.AbstractListComponent;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListComponent
extends AbstractListComponent
implements ListSelectionListener {
    private int visibleRows = 4;
    private boolean fillVertical = false;
    private boolean scrollable = true;
    private boolean multiSelection = true;
    private JList list;

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int n) {
        this.visibleRows = n;
    }

    public boolean isFillVertical() {
        return this.fillVertical;
    }

    public void setFillVertical(boolean bl) {
        this.fillVertical = bl;
    }

    public boolean isFillCenterVertical() {
        return this.fillVertical;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean bl) {
        this.multiSelection = bl;
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.list != null && formEnvironment != null) {
            this.list.setName(formEnvironment.getId(this));
        }
    }

    public JComponent createCenterComponent() {
        this.list = new JList(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.list.setVisibleRowCount(this.visibleRows);
        int n = this.multiSelection ? 2 : 0;
        this.list.setSelectionMode(n);
        if (this.scrollable) {
            JScrollPane jScrollPane = new JScrollPane(this.list){

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            jScrollPane.setAlignmentX(0.0f);
            this.adjustMinimumSize(jScrollPane.getViewport(), this.list);
            return jScrollPane;
        }
        this.list.setAlignmentX(0.0f);
        this.list.setBorder(BorderFactory.createEtchedBorder());
        this.adjustMinimumSize(this.list, this.list);
        return this.list;
    }

    public void initialize() {
        super.initialize();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        String[] stringArray = this.getListEntries();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultListModel.addElement(stringArray[i]);
        }
        this.list.setModel(defaultListModel);
        this.list.removeListSelectionListener(this);
        this.initList(stringArray);
        this.list.addListSelectionListener(this);
        this.selectionChanged(this.list.getSelectedValue());
    }

    private void initList(String[] stringArray) {
        if (stringArray != null) {
            Object object = this.getContext().getVariable(this.getVariableName());
            if (object != null && object instanceof Integer) {
                int n = (Integer)object;
                if (n < stringArray.length && n >= 0) {
                    this.list.setSelectedIndex(n);
                }
            } else if (this.multiSelection && object != null && object instanceof int[]) {
                int[] nArray = (int[])object;
                boolean bl = true;
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n < stringArray.length && n >= 0) continue;
                    bl = false;
                }
                if (bl) {
                    this.list.setSelectedIndices(nArray);
                }
            } else {
                int n = this.getInitiallySelectedIndex();
                if (n < stringArray.length) {
                    this.list.setSelectedIndex(n);
                }
            }
        }
    }

    public Object getConfigurationObject() {
        return this.list;
    }

    public Class getConfigurationObjectClass() {
        return JList.class;
    }

    public boolean checkCompleted() {
        Object object = this.multiSelection ? this.list.getSelectedIndices() : (Object)new Integer(this.list.getSelectedIndex());
        this.getContext().setVariable(this.getVariableName(), object);
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    protected boolean isLeadingLabelTopAligned() {
        return true;
    }

    protected boolean getInitialFillHorizontal() {
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        int n;
        String[] stringArray = new String[this.list.getModel().getSize()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.list.getModel().getElementAt(n).toString();
        }
        if (this.multiSelection) {
            int[] nArray = console.askMultipleSelection(this.getConsoleLabelText(false), stringArray, null, this.list.getSelectedIndices(), true);
            this.list.setSelectedIndices(nArray);
        } else {
            n = console.askOption(this.getConsoleLabelText(false), stringArray, null, this.list.getSelectedIndex(), true, true);
            this.list.setSelectedIndex(n);
        }
        return true;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.list) {
            this.selectionChanged(this.list.getSelectedValue());
        }
    }
}

