/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.HtmlDisplayTextArea;
import com.install4j.runtime.util.StringUtil;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MultilineHtmlLabelComponent
extends AbstractFormComponent {
    private String labelHtml = "";
    private HtmlDisplayTextArea label;

    public String getLabelHtml() {
        return MultilineHtmlLabelComponent.replaceVariables(this.labelHtml, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setLabelHtml(String string) {
        this.labelHtml = string;
    }

    public Object getConfigurationObject() {
        return this.label;
    }

    public Class getConfigurationObjectClass() {
        return JTextPane.class;
    }

    public void initialize() {
        super.initialize();
        this.label.setText(this.getLabelHtml());
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.label != null && formEnvironment != null) {
            this.label.setName(formEnvironment.getId(this));
        }
    }

    public JComponent createCenterComponent() {
        this.label = new HtmlDisplayTextArea();
        this.label.setText(this.getLabelHtml());
        this.label.setAlignmentX(0.0f);
        this.label.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GUIHelper.showURL(AbstractBean.replaceVariables(hyperlinkEvent.getURL().toExternalForm()));
                }
            }
        });
        return this.label;
    }

    public boolean isFillCenterHorizontal() {
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        console.more(StringUtil.formatTextWithoutHtmlTags(this.label.getText()));
        return true;
    }

    public boolean hasUserInput() {
        return false;
    }
}

