/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.CustomDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public abstract class StandardDialog
extends CustomDialog
implements ActionListener {
    private JButton btnOK;
    private JButton btnCancel;
    private boolean canceled = true;

    protected StandardDialog(Frame frame) {
        super(frame);
    }

    protected StandardDialog(Dialog dialog) {
        super(dialog);
    }

    protected void init() {
        this.setModal(true);
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
        this.setBounds(this.getFrameBounds());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.canceled = true;
        }
        super.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOK) {
            this.doOk();
        } else if (object == this.btnCancel) {
            this.doCancel();
        }
    }

    protected JButton getOKButton() {
        return this.btnOK;
    }

    protected JButton getCancelButton() {
        return this.btnCancel;
    }

    protected void doOk() {
        this.canceled = false;
        this.setVisible(false);
    }

    protected void doCancel() {
        this.setVisible(false);
    }

    protected void setupControls() {
        this.btnOK = new JButton(Messages.getMessages().getString("ButtonOK"));
        this.btnCancel = new JButton(Messages.getMessages().getString("ButtonCancel"));
    }

    protected void setupEventHandlers() {
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    protected void setupComponent() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.addScreenContent(jPanel);
        container.add((Component)jPanel, this.isFillVertical() ? "Center" : "North");
        container.add((Component)this.createButtonPanel(), "South");
        this.getRootPane().setDefaultButton(this.btnOK);
    }

    protected abstract void addScreenContent(JPanel var1);

    protected abstract boolean isFillVertical();

    protected JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.createButtonBox(), "Center");
        return jPanel;
    }

    protected JComponent createButtonBox() {
        Box box = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOK, this.btnCancel}, 0);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(box);
        return box2;
    }

    protected boolean checkTextField(JTextComponent jTextComponent) {
        if (jTextComponent.getText().trim().length() == 0) {
            this.showMissingMessage(jTextComponent);
            return false;
        }
        return true;
    }

    protected void showMissingMessage(JComponent jComponent) {
        GUIHelper.showMessage(this.getOwner(), Messages.getMessages().getString("EnterInformation"), 2);
        jComponent.requestFocus();
    }

    protected JPanel createBorderPanel(String string, LayoutManager layoutManager) {
        return this.createBorderPanel(string, layoutManager, 0);
    }

    protected JPanel createBorderPanel(String string, LayoutManager layoutManager, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(n, n, n, n)));
        if (layoutManager != null) {
            jPanel.setLayout(layoutManager);
        }
        return jPanel;
    }
}

