#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "vars.h"


/******************************************
 ******** Check url by urls rules *********/
 int check_url(char **list,int count)
 {

  char *ret,*k,*k1;
  int z;

  #ifdef DEBUG_CHECK_URLS
  fprintf(stderr,"Look for %s in %p list\n",i_url->twoleveldomen,list);
  #endif
  
   ret=bsearch((char*)&i_url->twoleveldomen,list,count,sizeof(char*),cmp_urls_bs);

   if(ret)
    {
     #ifdef DEBUG_CHECK_URLS
      fprintf(stderr," 2 level domen found in rule %s\n",*(char**)ret);
     #endif

     k=strchr(*(char**)ret,1);
     if (!k)
        {
          sprintf(change_reason,"(urls rule: %s)",*(char**)ret);
	  return(1);
	}
	else
	 {
	 /****************************************************
	  *  domen.ru|www|port|/dir/file|bs|||               *
	  *  |       |   |    |         |     		     *
	  * ret      0   1    2         3 		     *
	  *                             0 123               */

	  k++;
    	  while(1)
           {
	    // End of rule? 
	    if(!*(k)) return(0);
	    k1=k;
	    // subdomen
	    if (*(k)!=1 && cmp_urls_sub(i_url->subdomen,k))
	     {
	      z=0;
	      while(z<3) if (*(k++)==1) z++;

	      #ifdef DEBUG_CHECK_URLS
	      fprintf(stderr,"SUBDOMEN NOT EQUAL\n");
	      fprintf(stderr,"NEXT K=%c(%i)\n",*k,*k);
	      #endif
	      continue;
	     }
	      while(*(k++)!=1);
	      #ifdef DEBUG_CHECK_URLS
	      fprintf(stderr,"SUBDOMEN EQUAL OR EMPTY: k=%c(%i)\n",*k,*k); 
	      #endif

	    // port
	    if (*(k)!=1 && cmp_urls_port(i_url->port,k))
	     {
	      z=0;
	      while(z<2) if (*(k++)==1) z++;
	      #ifdef DEBUG_CHECK_URLS
	      fprintf(stderr,"PORT NOT EQUAL\n");
	      fprintf(stderr,"NEXT K=%c(%i)\n",*k,*k);
	      #endif
	      continue;
	     }
	      while(*(k++)!=1);
	      #ifdef DEBUG_CHECK_URLS
	      fprintf(stderr,"PORT EQUAL OR EMPTY: k=%c(%i)\n",*k,*k);
	      #endif
	    // dirs
	    if (*(k)!=1 && cmp_urls_dirs(i_url->dirs,k))
	     {
	      z=0;
	      while(z<1) if (*(k++)==1) z++;
	      #ifdef DEBUG_CHECK_URLS	
	      fprintf(stderr,"DIRS NOT EQUAL\n");
	      fprintf(stderr,"NEXT K=%c(%i)\n",*k,*k);
	      #endif
	      continue;
	     }
//	      while(*(k++)!=1);
	      #ifdef DEBUG_CHECK_URLS	
	      fprintf(stderr,"DIRS EQUAL OR EMPTY\n");
	      #endif

//              if(!redir[section]->log_flag)
//                {
		// 2leveldomen
		 z=(strchr(*(char**)ret,1)- *(char**)ret);
		 memcpy(i_url->twoleveldomen,*(char**)ret,z);
		 i_url->twoleveldomen[z]=0;
		// subdomen
	         z=(strchr(k1,1)- k1);
		 if (z>0) 
		  {
		   memcpy(i_url->subdomen,k1,z);
		   i_url->subdomen[z]=0;
		   strcat(i_url->subdomen,".");
		  }
		  else i_url->subdomen[0]=0;
		// port
		 k1+=z+1;
	         z=(strchr(k1,1)- k1);
		 if (z>0) 
		  {
		   i_url->port[0]=':';
		   memcpy(&i_url->port[1],k1,z);
		   i_url->port[z+1]=0;
		  }
		  else i_url->port[0]=0;

		// dirs
		 k1+=z+1;
	         k=strchr(k1,1);
		 if (!k) k=strchr(k1,1);
		 z=(k- k1);
		 if (z>0) 
		    {
		     memcpy(i_url->dirs,k1,z);
		     i_url->dirs[z]=0;
		    }
		 else i_url->dirs[0]=0;
		 
				    
	         sprintf(change_reason,"(urls rule: %s%s%s%s)",i_url->subdomen,i_url->twoleveldomen,i_url->port,i_url->dirs);
//	        }
	  return(1);

	   }//While (1)
         } //else
	} //if ret

  #ifdef DEBUG_CHECK_URLS
   fprintf(stderr," 2 level domen not found\n");
  #endif

   return(0);
 }
