/*
 * curs_util.c
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 */
 
#include <stdio.h>
#include <time.h>
#include <string.h>

#include "curs_util.h"
#include "../config.h"

extern int do_resolve;

static WINDOW *         win;
       int              row;

void
curs_init(void)
{
    win = initscr();

    keypad(stdscr, TRUE);
    nonl();
    cbreak();
    noecho();
    nodelay(win, TRUE);      /* getch etc. must be non-blocking */
    clear();

#if 0
    if (has_colors()) {
        start_color();

        init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_BLACK);
        init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
        init_pair(COLOR_RED, COLOR_RED, COLOR_BLACK);
        init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_BLACK);
        init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
        init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
        init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_BLACK);
        init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);
    }
#endif

    curs_set(0);
}

void
print_full_line(const char *fmt, ...)
{
    va_list args;
    static char buf[2048], sp[2048];

    memset(buf, 0, sizeof(buf));
    memset(sp, ' ', sizeof(sp));

    va_start(args, fmt);
    vsnprintf(buf, sizeof(buf), fmt, args);
    va_end(args);

    if (strlen(buf) > COLS)
        buf[COLS] = '\0';
    else
        strncpy(&buf[strlen(buf)], sp, COLS-strlen(buf));

    addstr(buf);
}

void
print_sep(void)
{
    hline(ACS_HLINE, COLS);
}


void
print_to_end(void)
{
    for (++row; row < LINES-1; row++) {
        move(row,0);
        print_full_line("");
    }
}

void
print_status(const char *appname)
{
    time_t t;
    char dstr[30];

    row = LINES-1;
    move(row,0);
    attrset(A_REVERSE);

    print_full_line(" %s 0.4.0", appname);

    move(row,COLS-16);
    t = time(0);
    strftime(dstr, sizeof(dstr), "%b %d %H:%M:%S", localtime(&t));
    printw("%s", dstr);
    
    attroff(A_REVERSE);
}

void
print_top(const char *fmt, ...)
{
    char str[1024];
    va_list args;

    va_start(args, fmt);
    vsnprintf(str, sizeof(str), fmt, args);
    va_end(args);

    row=1;
    move(0,0);
    attrset(A_REVERSE);
    print_full_line("%s", str);
    attroff(A_REVERSE);
    move(1,0);
}
