C
C This file is issued from the MODULEF library, but has been 
C subsequently modified
C
      SUBROUTINE FONINI(M,LFON,ICODE)
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C           S.P. FONINI          (FONCTIONS INTERPRETEES)
C           -----------
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C BUT :
C     INITIALISER L ANALYSEUR DE FONCTIONS
C
C PARAMETRES D ENTREE :
C     M       : SUPER-TABLEAU
C     LFON    : NOMBRE DE MOTS ACCORDES A L ANALYSEUR
C
C PARAMETRES DE SORTIE :
C     ICODE   : CODE DE RETOUR (VOIR LE S.P. FONERR)
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C PROGRAMMEUR : PATRICK LAUG ; INRIA (3) 954 90 20 POSTE 508
C ......................................................................
      PARAMETER (LOPE1=19,LOPE2=14,LOPT=20,LSYM=9,LIDN=8)
      CHARACTER*  5 MOPE(LOPE1+LOPE2),MOPEL(LOPE1+LOPE2)
      CHARACTER*256 MIDN(LIDN)
      DIMENSION M(*)
      COMMON /FONOPE/ MOPE
      COMMON /FONIDN/ MIDN
      COMMON /FONIA / IAI,IAR,IAL,IAC,IAD,IAOPN,IAOPT,IASYM,IAEXP,IAIDN
      COMMON /FONLC / LCI,LCR,LCL,LCC,LCD,LCOPN,LCOPT,LCSYM,LCEXP,LCIDN
      COMMON /FONLM / LMI,LMR,LML,LMC,LMD,LMOPN,LMOPT,LMSYM,LMEXP,LMIDN
      COMMON /FONNUM/ IDLIG,IFLIG,NITEMS,NBIDEN,IMPLIC
      COMMON /COMCOU/ NCOU,IACOU,LCOU,NFIC,NBENR,LGCOU
      EQUIVALENCE (IDEUX,RDEUX)
      DATA RDEUX /2./
      DATA MOPEL    /'+ UNA', '- UNA', 'INT  ', 'REAL ', 'DBLE ',
     +               'ABS  ', 'SQRT ', 'EXP  ', 'LOG  ', 'LOG10',
     +               'SIN  ', 'COS  ', 'TAN  ', 'ASIN ', 'ACOS ',
     +               'ATAN ', 'SINH ', 'COSH ', 'TANH ',
     +               '+    ', '-    ', '*    ', '/    ', '**   ',
     +               '.EQ. ', '.NE. ', '.GT. ', '.LT. ', '.GE. ',
     +               '.LE. ', 'MOD  ', 'MIN  ', 'MAX  '/
C
C CALCUL EMPIRIQUE DE MANIERE A CE QUE LA SOMME DES LONGUEURS
C DES TABLEAUX A ALLOUER N'EXCEDE PAS LFON
C LES TABLEAUX D'ADRESSES IAI, IAR, ... DOIVENT ETRE DE MEME LONGUEUR
C CES TABLEAUX CONTIENDRONT A LA FOIS LES CONSTANTES DE L'EXPRESSION
C ET LES VARIABLES (PARAMETRES ET RESULTATS INTERMEDIAIRES)
C NOMBRE MAXI DE CONSTANTES = LMI - LMOPN
      LPIXEL = (LFON - (LOPT+LSYM)) / 15
      IF (LPIXEL .LT. 4) THEN
         ICODE = 14
         CALL FONERR(0,ICODE)
         RETURN
      END IF
C
C DANS LE CODE QUI SERA INTERPRETE, LES ADRESSES SONT CODEES SUR
C 3 CHIFFRES, DONC LMI <= 999, ET DONC LPIXEL <= 499
      LPIXEL = MIN(LPIXEL,499)
      LMI    = 2*LPIXEL
      LMR    = LMI
      LML    = LMI
      LMC    = LMI
      LMD    = LMI
      LMOPN  = LPIXEL
      LMOPT  = LOPT
      LMSYM  = LSYM
      LMEXP  = 4*LPIXEL
      LMIDN  = LIDN
C
C ALLOCATION DES TABLEAUX NECESSAIRES A LA GESTION DES EXPRESSIONS
      IAI  = 0
      CALL READRE(1,':III',IAI,LMI,M,N)
      IAR  = 0
      CALL READRE(2,':RRR',IAR,LMR,M,N)
      IAL  = 0
      CALL READRE(3,':LLL',IAL,LML,M,N)
      IAC  = 0
      CALL READRE(4,':CCC',IAC,LMC,M,N)
      IAD  = 0
      CALL READRE(5,':DDD',IAD,LMD,M,N)
      IAOPN  = 0
      CALL READRE(1,':OPN',IAOPN,LMOPN,M,N)
      IAOPT  = 0
      CALL READRE(1,':OPT',IAOPT,LMOPT,M,N)
      IASYM  = 0
      CALL READRE(1,':SYM',IASYM,LMSYM,M,N)
      IAEXP  = 0
      CALL READRE(1,':EXP',IAEXP,LMEXP,M,N)
C
C INITIALISATION DES COMMUNS
C --------------------------
      DO 100 I = 1,LOPE1+LOPE2
  100 MOPE(I) = MOPEL(I)
      MIDN(1)(1:2) = '||'
C
C LES CONSTANTES 2 ET 2. SONT PLACEES SYSTEMATIQUEMENT A L'ADRESSE 1
C POUR ETRE RECONNUE PLUS FACILEMENT (EX: OPTIMISATION DE X**2)
      LCI = 1
      M(IAI) = 2
      LCR = 1
      M(IAR) = IDEUX
C
      LCL = 0
      LCC = 0
      LCD = 0
      LCOPN  = 0
      LCOPT  = 0
      LCSYM  = 0
      LCEXP  = 0
      LCIDN  = 1
      NBIDEN = 0
      IMPLIC = 2
C
      NFIC   = 0
      NBENR  = 0
      LGCOU  = 0
C
C POSITIONNEMENT EN DEBUT DE LIGNE
      ICODE = 0
      CALL FONERR(0,ICODE)
      END
