/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jfilechooserbookmarks;

import com.googlecode.jfilechooserbookmarks.AbstractPropertiesHandler;
import com.googlecode.jfilechooserbookmarks.Bookmark;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractBookmarksManager
implements Serializable {
    private static final long serialVersionUID = 4461451164139626835L;
    public static final String BOOKMARK_COUNT = "BookmarkCount";
    public static final String BOOKMARK_PREFIX_NAME = "BookmarkName.";
    public static final String BOOKMARK_PREFIX_DIR = "BookmarkDir.";
    protected Properties m_Properties;
    protected AbstractPropertiesHandler m_Handler;

    protected AbstractBookmarksManager(AbstractPropertiesHandler handler) {
        this.m_Handler = handler;
    }

    public synchronized List<Bookmark> load() {
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        Properties props = this.getProperties();
        int count = Integer.parseInt(props.getProperty(BOOKMARK_COUNT, "0"));
        for (int i = 0; i < count; ++i) {
            String name = props.getProperty(BOOKMARK_PREFIX_NAME + i);
            File dir = new File(props.getProperty(BOOKMARK_PREFIX_DIR + i));
            Bookmark bookmark = new Bookmark(name, dir);
            result.add(bookmark);
        }
        return result;
    }

    public synchronized boolean save(List<Bookmark> bookmarks) {
        Properties props = new Properties();
        props.clear();
        props.setProperty(BOOKMARK_COUNT, "" + bookmarks.size());
        for (int i = 0; i < bookmarks.size(); ++i) {
            Bookmark bookmark = bookmarks.get(i);
            props.setProperty(BOOKMARK_PREFIX_NAME + i, bookmark.getName());
            props.setProperty(BOOKMARK_PREFIX_DIR + i, bookmark.getDirectory().getAbsolutePath());
        }
        boolean result = this.m_Handler.saveProperties(props);
        this.m_Properties = props;
        return result;
    }

    public synchronized Properties getProperties() {
        if (this.m_Properties == null) {
            this.m_Properties = this.m_Handler.loadProperties();
        }
        return this.m_Properties;
    }
}

