package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStrategies invokes the cloudcallcenter.ListStrategies API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/liststrategies.html
func (client *Client) ListStrategies(request *ListStrategiesRequest) (response *ListStrategiesResponse, err error) {
	response = CreateListStrategiesResponse()
	err = client.DoAction(request, response)
	return
}

// ListStrategiesWithChan invokes the cloudcallcenter.ListStrategies API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/liststrategies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStrategiesWithChan(request *ListStrategiesRequest) (<-chan *ListStrategiesResponse, <-chan error) {
	responseChan := make(chan *ListStrategiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStrategies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStrategiesWithCallback invokes the cloudcallcenter.ListStrategies API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/liststrategies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStrategiesWithCallback(request *ListStrategiesRequest, callback func(response *ListStrategiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStrategiesResponse
		var err error
		defer close(result)
		response, err = client.ListStrategies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStrategiesRequest is the request struct for api ListStrategies
type ListStrategiesRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListStrategiesResponse is the response struct for api ListStrategies
type ListStrategiesResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Code           string     `json:"Code" xml:"Code"`
	Message        string     `json:"Message" xml:"Message"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Strategies     []Strategy `json:"Strategies" xml:"Strategies"`
}

// CreateListStrategiesRequest creates a request to invoke ListStrategies API
func CreateListStrategiesRequest() (request *ListStrategiesRequest) {
	request = &ListStrategiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListStrategies", "", "")
	request.Method = requests.POST
	return
}

// CreateListStrategiesResponse creates a response to parse from ListStrategies response
func CreateListStrategiesResponse() (response *ListStrategiesResponse) {
	response = &ListStrategiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
