package cloudgame

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGames invokes the cloudgame.ListGames API synchronously
// api document: https://help.aliyun.com/api/cloudgame/listgames.html
func (client *Client) ListGames(request *ListGamesRequest) (response *ListGamesResponse, err error) {
	response = CreateListGamesResponse()
	err = client.DoAction(request, response)
	return
}

// ListGamesWithChan invokes the cloudgame.ListGames API asynchronously
// api document: https://help.aliyun.com/api/cloudgame/listgames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListGamesWithChan(request *ListGamesRequest) (<-chan *ListGamesResponse, <-chan error) {
	responseChan := make(chan *ListGamesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGames(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGamesWithCallback invokes the cloudgame.ListGames API asynchronously
// api document: https://help.aliyun.com/api/cloudgame/listgames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListGamesWithCallback(request *ListGamesRequest, callback func(response *ListGamesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGamesResponse
		var err error
		defer close(result)
		response, err = client.ListGames(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGamesRequest is the request struct for api ListGames
type ListGamesRequest struct {
	*requests.RpcRequest
	OrderKey   string           `position:"Query" name:"OrderKey"`
	SortType   string           `position:"Query" name:"SortType"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListGamesResponse is the response struct for api ListGames
type ListGamesResponse struct {
	*responses.BaseResponse
	Count       string         `json:"Count" xml:"Count"`
	PageSize    int            `json:"PageSize" xml:"PageSize"`
	CurrentPage int            `json:"CurrentPage" xml:"CurrentPage"`
	RequestId   string         `json:"RequestId" xml:"RequestId"`
	DataList    []DataListItem `json:"DataList" xml:"DataList"`
}

// CreateListGamesRequest creates a request to invoke ListGames API
func CreateListGamesRequest() (request *ListGamesRequest) {
	request = &ListGamesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudgame", "2020-04-29", "ListGames", "", "")
	request.Method = requests.POST
	return
}

// CreateListGamesResponse creates a response to parse from ListGames response
func CreateListGamesResponse() (response *ListGamesResponse) {
	response = &ListGamesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
