//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageCaches invokes the eci.DescribeImageCaches API synchronously
// api document: https://help.aliyun.com/api/eci/describeimagecaches.html
func (client *Client) DescribeImageCaches(request *DescribeImageCachesRequest) (response *DescribeImageCachesResponse, err error) {
	response = CreateDescribeImageCachesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageCachesWithChan invokes the eci.DescribeImageCaches API asynchronously
// api document: https://help.aliyun.com/api/eci/describeimagecaches.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeImageCachesWithChan(request *DescribeImageCachesRequest) (<-chan *DescribeImageCachesResponse, <-chan error) {
	responseChan := make(chan *DescribeImageCachesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageCaches(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageCachesWithCallback invokes the eci.DescribeImageCaches API asynchronously
// api document: https://help.aliyun.com/api/eci/describeimagecaches.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeImageCachesWithCallback(request *DescribeImageCachesRequest, callback func(response *DescribeImageCachesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageCachesResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageCaches(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageCachesRequest is the request struct for api DescribeImageCaches
type DescribeImageCachesRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	ImageCacheId         string           `position:"Query" name:"ImageCacheId"`
	ImageCacheName       string           `position:"Query" name:"ImageCacheName"`
	SnapshotId           string           `position:"Query" name:"SnapshotId"`
	Image                string           `position:"Query" name:"Image"`
}

// DescribeImageCachesResponse is the response struct for api DescribeImageCaches
type DescribeImageCachesResponse struct {
	*responses.BaseResponse
	RequestId   string                           `json:"RequestId" xml:"RequestId"`
	ImageCaches []DescribeImageCachesImageCache0 `json:"ImageCaches" xml:"ImageCaches"`
}

type DescribeImageCachesImageCache0 struct {
	ContainerGroupId string                      `json:"ContainerGroupId" xml:"ContainerGroupId"`
	ImageCacheId     string                      `json:"ImageCacheId" xml:"ImageCacheId"`
	ImageCacheName   string                      `json:"ImageCacheName" xml:"ImageCacheName"`
	SnapshotId       string                      `json:"SnapshotId" xml:"SnapshotId"`
	Progress         string                      `json:"Progress" xml:"Progress"`
	Status           string                      `json:"Status" xml:"Status"`
	ExpireDateTime   string                      `json:"ExpireDateTime" xml:"ExpireDateTime"`
	CreationTime     string                      `json:"CreationTime" xml:"CreationTime"`
	Events           []DescribeImageCachesEvent1 `json:"Events" xml:"Events"`
	Images           []string                    `json:"Images" xml:"Images"`
}

type DescribeImageCachesEvent1 struct {
	Count          int    `json:"Count" xml:"Count"`
	Type           string `json:"Type" xml:"Type"`
	Name           string `json:"Name" xml:"Name"`
	Message        string `json:"Message" xml:"Message"`
	FirstTimestamp string `json:"FirstTimestamp" xml:"FirstTimestamp"`
	LastTimestamp  string `json:"LastTimestamp" xml:"LastTimestamp"`
}

// CreateDescribeImageCachesRequest creates a request to invoke DescribeImageCaches API
func CreateDescribeImageCachesRequest() (request *DescribeImageCachesRequest) {
	request = &DescribeImageCachesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "DescribeImageCaches", "eci", "openAPI")
	return
}

// CreateDescribeImageCachesResponse creates a response to parse from DescribeImageCaches response
func CreateDescribeImageCachesResponse() (response *DescribeImageCachesResponse) {
	response = &DescribeImageCachesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
