# TUF testdata

TUF testdata generated by the Python implementation which is used to test that
the Go client is compatible with files generated by the Python repository tool.

## Generate

The `generate` directory contains scripts and a Dockerfile for generating the
test data files.

Run `make` to regenerate the test files:

```
$ make clean
rm -rf keystore repository

$ make
docker build -t tuf-gen ./generate
...
Successfully built ac1fba1d0b3b
docker run tuf-gen | tar x
Files generated:
.
|-- keystore
|   |-- root_key
|   |-- root_key.pub
|   |-- snapshot_key
|   |-- snapshot_key.pub
|   |-- targets_key
|   |-- targets_key.pub
|   |-- timestamp_key
|   `-- timestamp_key.pub
|-- repository
|   |-- metadata
|   |   |-- root.json
|   |   |-- snapshot.json
|   |   |-- targets.json
|   |   |-- targets.json.gz
|   |   `-- timestamp.json
|   `-- targets
|       |-- dir
|       |   `-- file2.txt
|       `-- file1.txt
`-- tuf.log

5 directories, 16 files
```
