/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class OpticalCorner
extends PrimitiveNode {
    private static final double BASESIZE = 10.0;
    private int angle;
    private PrimitivePort pp1;
    private PrimitivePort pp2;

    public OpticalCorner(String protoName, Photonics tech, Technology.NodeLayer[] layers, int angle) {
        super(protoName, tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 10.0, 10.0, ERectangle.fromLambda(-5.0, -5.0, 10.0, 10.0), ERectangle.fromLambda(-5.0, -5.0, 10.0, 10.0), layers);
        this.angle = angle;
        if (angle == 90) {
            this.pp1 = PrimitivePort.newInstance(this, new ArcProto[]{Photonics.opticalArc}, "c1", 270, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.r(5.0), EdgeV.b(-5.0), EdgeH.r(5.0), EdgeV.b(-5.0));
            this.pp2 = PrimitivePort.newInstance(this, new ArcProto[]{Photonics.opticalArc}, "c2", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.l(-5.0), EdgeV.t(5.0), EdgeH.l(-5.0), EdgeV.t(5.0));
        } else {
            this.pp1 = PrimitivePort.newInstance(this, new ArcProto[]{Photonics.opticalArc}, "c1", 270, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.r(5.0), EdgeV.b(-5.0), EdgeH.r(5.0), EdgeV.b(-5.0));
            this.pp2 = PrimitivePort.newInstance(this, new ArcProto[]{Photonics.opticalArc}, "c2", 135, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.r(2.07), EdgeV.t(2.07), EdgeH.r(2.07), EdgeV.t(2.07));
        }
        this.addPrimitivePorts(this.pp1, this.pp2);
        this.setCurvedPin();
    }

    @Override
    public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
        int halfWay;
        int numPasses;
        assert (n.protoId == this.getId());
        long width = n.size.getFixpX() + Photonics.lambdaToFixp(10.0);
        long height = n.size.getFixpY() + Photonics.lambdaToFixp(10.0);
        PLayer trench = Photonics.photonicsWaveguide;
        Layer otrenchLay = trench.findLayer();
        long one = Photonics.lambdaToFixp(1.0);
        if (width == 0L || height == 0L) {
            b.setCurNode(n);
            double extraWidth = trench.getWidth() - 10.0;
            double halfWidth = ((double)width + extraWidth * (double)one) / 2.0;
            double halfHeight = ((double)height + extraWidth * (double)one) / 2.0;
            b.pushPoint(-halfWidth, -halfHeight);
            b.pushPoint(-halfWidth, halfHeight);
            b.pushPoint(halfWidth, halfHeight);
            b.pushPoint(halfWidth, -halfHeight);
            b.pushPoly(Poly.Type.CROSSED, otrenchLay, null, null);
            return;
        }
        long halfWidth = width >> 1;
        long halfHeight = height >> 1;
        double trenchHalfWidth = trench.getWidth() / 2.0;
        double outerWid = (double)width + trenchHalfWidth * (double)one;
        double outerHei = (double)height + trenchHalfWidth * (double)one;
        double innerWid = (double)width - trenchHalfWidth * (double)one;
        double innerHei = (double)height - trenchHalfWidth * (double)one;
        int numSteps = 128 * this.angle / 360;
        if (b.isElectrical()) {
            numPasses = 2;
            halfWay = numSteps / 2;
        } else {
            numPasses = 1;
            halfWay = numSteps;
        }
        for (int e = 0; e < numPasses; ++e) {
            long y;
            long x;
            double angle;
            int i;
            PrimitivePort pp;
            int endPt;
            int startPt;
            b.setCurNode(n);
            if (e == 0) {
                startPt = 0;
                endPt = halfWay;
                pp = this.pp1;
            } else {
                startPt = halfWay;
                endPt = numSteps;
                pp = this.pp2;
            }
            for (i = startPt; i <= endPt; ++i) {
                angle = 0.04908738521234052 * (double)i;
                x = (long)(Math.cos(angle) * outerWid) - halfWidth;
                y = (long)(Math.sin(angle) * outerHei) - halfHeight;
                b.pushPoint(x, y);
            }
            for (i = endPt; i >= startPt; --i) {
                angle = 0.04908738521234052 * (double)i;
                x = (long)(Math.cos(angle) * innerWid) - halfWidth;
                y = (long)(Math.sin(angle) * innerHei) - halfHeight;
                b.pushPoint(x, y);
            }
            b.pushPoly(Poly.Type.FILLED, otrenchLay, null, pp);
        }
        PLayer[] ol = Photonics.getOpticalLayers(false);
        for (int l = 0; l < ol.length; ++l) {
            long y;
            long x;
            double angle;
            int i;
            Layer layer = ol[l].findLayer();
            if (layer == null) continue;
            double surroundHalfWidth = ol[l].getWidth() / 2.0;
            outerWid = (double)width + surroundHalfWidth * (double)one;
            outerHei = (double)height + surroundHalfWidth * (double)one;
            innerWid = (double)width - surroundHalfWidth * (double)one;
            innerHei = (double)height - surroundHalfWidth * (double)one;
            b.setCurNode(n);
            for (i = 0; i <= numSteps; ++i) {
                angle = 0.04908738521234052 * (double)i;
                x = (long)(Math.cos(angle) * outerWid) - halfWidth;
                y = (long)(Math.sin(angle) * outerHei) - halfHeight;
                b.pushPoint(x, y);
            }
            for (i = numSteps; i >= 0; --i) {
                angle = 0.04908738521234052 * (double)i;
                x = (long)(Math.cos(angle) * innerWid) - halfWidth;
                y = (long)(Math.sin(angle) * innerHei) - halfHeight;
                b.pushPoint(x, y);
            }
            b.pushPoly(Poly.Type.FILLED, layer, null, null);
        }
    }
}

