/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.tool.user.ncc.ComparisonsPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class EquivClassSplitPane
extends JSplitPane
implements HyperlinkListener {
    protected final ComparisonsPane parent;
    private int numRows;
    private JLabel[] partitionTitles;
    private JLabel[][] cellLabels;
    private CellEditorPane[][] cells;
    private StringBuffer[][] cellPlainText;
    private JSplitPane[] vertSplPanes;
    private JSplitPane[] horizSplPanes;
    private CellMouseAdapter mouseAdapter = new CellMouseAdapter();
    private static final Dimension zeroDim = new Dimension(0, 10);
    private static Border border = BorderFactory.createEmptyBorder();
    private static Insets insets = new Insets(0, 0, 0, 0);

    protected EquivClassSplitPane(ComparisonsPane parent, int numRows) {
        this.parent = parent;
        this.numRows = numRows;
        if (numRows == 1) {
            this.createSingleRowSplitPane();
        } else {
            this.createMultiRowSplitPane();
        }
    }

    private void createSingleRowSplitPane() {
        this.setOrientation(1);
        this.setup();
        this.horizSplPanes[0] = this;
        for (int i = 0; i < 2; ++i) {
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.cellLabels[0][i], "North");
            JPanel textPanel = new JPanel();
            textPanel.setBorder(border);
            textPanel.setBackground(Color.WHITE);
            textPanel.add(this.cells[0][i]);
            JScrollPane scrPane = new JScrollPane(textPanel);
            mainPanel.add((Component)scrPane, "Center");
            if (i == 0) {
                this.setTopComponent(mainPanel);
                continue;
            }
            this.setBottomComponent(mainPanel);
        }
    }

    private void createMultiRowSplitPane() {
        this.setOrientation(0);
        this.setup();
        JSplitPane curVertSplit = this;
        this.vertSplPanes[0] = curVertSplit;
        for (int i = 0; i < this.numRows; ++i) {
            JSplitPane topHorizSplit;
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.partitionTitles[i], "North");
            this.horizSplPanes[i] = topHorizSplit = new JSplitPane(1);
            this.setupSplit(topHorizSplit);
            for (int j = 0; j < 2; ++j) {
                JPanel halfPanel = new JPanel(new BorderLayout());
                halfPanel.add((Component)this.cellLabels[i][j], "North");
                JPanel textPanel = new JPanel();
                textPanel.setBorder(border);
                textPanel.setBackground(Color.WHITE);
                textPanel.add(this.cells[i][j]);
                JScrollPane scrPane = new JScrollPane(textPanel);
                halfPanel.add((Component)scrPane, "Center");
                if (j == 0) {
                    topHorizSplit.setLeftComponent(halfPanel);
                    continue;
                }
                topHorizSplit.setRightComponent(halfPanel);
            }
            mainPanel.add((Component)topHorizSplit, "Center");
            if (i == this.numRows - 1) {
                curVertSplit.setBottomComponent(mainPanel);
            } else {
                curVertSplit.setTopComponent(mainPanel);
            }
            if (i >= this.numRows - 2) continue;
            JSplitPane newVertSplit = new JSplitPane(0);
            this.setupSplit(newVertSplit);
            curVertSplit.setBottomComponent(newVertSplit);
            curVertSplit = newVertSplit;
            this.vertSplPanes[i + 1] = curVertSplit;
        }
    }

    private void setup() {
        this.setupSplit(this);
        this.partitionTitles = new JLabel[this.numRows];
        this.cellLabels = new JLabel[this.numRows][2];
        this.cells = new CellEditorPane[this.numRows][2];
        this.cellPlainText = new StringBuffer[this.numRows][2];
        this.vertSplPanes = new JSplitPane[this.numRows];
        this.horizSplPanes = new JSplitPane[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.cellPlainText[i][j] = new StringBuffer();
                this.partitionTitles[i] = new JLabel("");
                this.partitionTitles[i].setHorizontalAlignment(0);
                this.partitionTitles[i].setMinimumSize(zeroDim);
                this.partitionTitles[i].setBorder(BorderFactory.createEtchedBorder(0));
                this.cellLabels[i][j] = new JLabel("");
                this.cellLabels[i][j].setMinimumSize(zeroDim);
                this.cells[i][j] = new CellEditorPane(this.cellPlainText[i][j]);
                this.cells[i][j].setText("");
                this.cells[i][j].setEditable(false);
                this.cells[i][j].addHyperlinkListener(this);
                this.cells[i][j].setContentType("text/html");
                this.cells[i][j].setMargin(insets);
                this.cells[i][j].addMouseListener(this.mouseAdapter);
            }
        }
    }

    private void setupSplit(JSplitPane split2) {
        split2.setMinimumSize(zeroDim);
        split2.setOneTouchExpandable(true);
        split2.setResizeWeight(0.5);
        split2.setBorder(border);
    }

    protected StringBuffer getCellPlainTextBuffer(int row, int col) {
        if (col < 0 || col > 1 || row < 0 || row > this.numRows - 1) {
            return null;
        }
        return this.cellPlainText[row][col];
    }

    protected void setPartitionTitle(int row, String text) {
        if (row < 0 || row > this.numRows - 1) {
            return;
        }
        this.partitionTitles[row].setText(text);
    }

    protected void setLabelText(int row, int col, String text) {
        if (col < 0 || col > 1 || row < 0 || row > this.numRows - 1) {
            return;
        }
        this.cellLabels[row][col].setText(text);
    }

    protected void setCellText(int row, int col, String text) {
        if (col < 0 || col > 1 || row < 0 || row > this.numRows - 1) {
            return;
        }
        this.cells[row][col].setText(text);
        SwingUtilities.invokeLater(new CaretUpdate(this.cells[row][col]));
    }

    protected void updateLayout() {
        int i;
        for (i = this.numRows - 1; i >= 0; --i) {
            if (this.horizSplPanes[i] == null) continue;
            this.horizSplPanes[i].resetToPreferredSizes();
        }
        for (i = this.numRows - 1; i >= 0; --i) {
            if (this.vertSplPanes[i] == null) continue;
            this.vertSplPanes[i].resetToPreferredSizes();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.mouseAdapter.lastClick == 1) {
            this.parent.highlight(Integer.parseInt(event.getDescription()));
        }
    }

    private static class CaretUpdate
    implements Runnable {
        private CellEditorPane cell;

        public CaretUpdate(CellEditorPane c) {
            this.cell = c;
        }

        @Override
        public void run() {
            this.cell.moveCaretPosition(0);
            this.cell.setSelectionStart(0);
            this.cell.setSelectionEnd(0);
        }
    }

    private class CellMouseAdapter
    extends MouseAdapter {
        public int lastClick = -1;

        private CellMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastClick = e.getButton();
            if (e.getButton() != 2 && e.getButton() != 3) {
                return;
            }
            CellEditorPane epane = (CellEditorPane)e.getSource();
            EquivClassSplitPane.this.parent.showCellPopup(epane.getPlainTextBuffer().toString(), e.getComponent(), e.getX(), e.getY());
        }
    }

    private class CellEditorPane
    extends JEditorPane {
        private StringBuffer plainText;

        public CellEditorPane(StringBuffer textbuf) {
            this.plainText = textbuf;
        }

        public StringBuffer getPlainTextBuffer() {
            return this.plainText;
        }
    }
}

