/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ComparableVersion
implements Comparable<ComparableVersion> {
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private final String original;
    private final ArrayList<Integer> items = new ArrayList();
    private final boolean isSnapshot;

    public ArrayList<Integer> getItems() {
        return this.items;
    }

    public ComparableVersion(String version) {
        String[] splitVersion;
        if (version.isEmpty()) {
            throw new IllegalArgumentException("version may not be empty");
        }
        this.original = version;
        this.isSnapshot = version.toUpperCase().endsWith(SNAPSHOT_SUFFIX);
        if (this.isSnapshot) {
            version = version.substring(0, version.length() - SNAPSHOT_SUFFIX.length());
        }
        version = version.replace('-', '.').replace('_', '.');
        for (String versionStr : splitVersion = version.split("\\.")) {
            int parsedInt;
            try {
                parsedInt = Integer.parseInt(versionStr);
            }
            catch (NumberFormatException e) {
                parsedInt = -1;
            }
            this.items.add(parsedInt);
        }
    }

    public static Optional<ComparableVersion> buildComparableVersion(String version) {
        if (version == null || version.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new ComparableVersion(version));
        }
        catch (IllegalArgumentException nfe) {
            return Optional.empty();
        }
    }

    @Override
    public int compareTo(ComparableVersion otherVersion) {
        int i;
        for (i = 0; i < otherVersion.getItems().size() && i < this.getItems().size(); ++i) {
            int result = this.getItems().get(i) - otherVersion.getItems().get(i);
            if (result == 0) continue;
            return result;
        }
        if (i < this.getItems().size()) {
            while (i < this.getItems().size()) {
                if (this.getItems().get(i) != 0) {
                    return 1;
                }
                ++i;
            }
        } else if (i < otherVersion.getItems().size()) {
            while (i < otherVersion.getItems().size()) {
                if (otherVersion.getItems().get(i) != 0) {
                    return -1;
                }
                ++i;
            }
        }
        if (this.isSnapshot && !otherVersion.isSnapshot) {
            return -1;
        }
        if (!this.isSnapshot && otherVersion.isSnapshot) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableVersion that = (ComparableVersion)o;
        return this.isSnapshot == that.isSnapshot && this.items.equals(that.items);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.isSnapshot);
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public String toString() {
        String snapshotSuffix = this.isSnapshot ? SNAPSHOT_SUFFIX : "";
        String dotted = this.items.stream().map(i -> String.valueOf(i)).collect(Collectors.joining("."));
        String parsedVersion = dotted + snapshotSuffix;
        if (!this.original.equals(parsedVersion)) {
            return this.original + " (parsed as " + dotted + snapshotSuffix + ")";
        }
        return this.original;
    }
}

