#ifndef SOXT_BASIC_H
#define SOXT_BASIC_H

// NB: this is not a pure configure-input file, it's also a config header...

/**************************************************************************\
 * Copyright (c) Kongsberg Oil & Gas Technologies AS
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\**************************************************************************/

// *************************************************************************

/* Some useful inline template functions:
 *   SoXtMin(Val1, Val2)       - returns minimum value
 *   SoXtMax(Val1, Val2)       - returns maximum value
 *   SoXtClamp(Val, Min, Max)  - returns clamped value
 *   SoXtSwap(Val1, Val2)      - swaps the two values (no return value)
 */

template <class Type>
inline Type SoXtAbs(Type Val) {
  return (Val < 0) ? -Val : Val;
}

template <class Type>
inline Type SoXtMin(Type a, Type b) {
  return (b < a) ? b : a;
}

template <class Type>
inline Type SoXtMax(Type a, Type b) {
  return (b > a) ? b : a;
}

template <class Type>
inline Type SoXtClamp(Type val, Type min, Type max) {
  return SoXtMax(min, SoXtMin(max, val));
}

template <class Type>
inline void SoXtSwap(Type & a, Type & b) {
  Type t = a; a = b; b = t;
}

// *************************************************************************

#define __COIN_SOXT__

#if ! defined(SOXT_MAJOR_VERSION)
#define SOXT_MAJOR_VERSION 1
#endif /* ! SOXT_MAJOR_VERSION */
#if ! defined(SOXT_MINOR_VERSION)
#define SOXT_MINOR_VERSION 4
#endif /* ! SOXT_MINOR_VERSION */
#if ! defined(SOXT_MICRO_VERSION)
#define SOXT_MICRO_VERSION 1
#endif /* ! SOXT_MICRO_VERSION */
#if ! defined(SOXT_BETA_VERSION)
#define SOXT_BETA_VERSION 
#endif /* ! SOXT_BETA_VERSION */
#if ! defined(SOXT_VERSION)
#define SOXT_VERSION "1.4.1"
#endif /* ! SOXT_VERSION */

// *************************************************************************

/* Precaution to avoid an error easily made by the application programmer. */
#ifdef SOXT_DLL_API
# error Leave the internal SOXT_DLL_API define alone.
#endif /* SOXT_DLL_API */

/*
  On Microsoft Windows platforms, one of these defines must always be set when
  building application programs:

   - "SOXT_DLL", when the application programmer is using the
     library in the form of a dynamic link library (DLL)

   - "SOXT_NOT_DLL", when the application programmer is using the
     library in the form of a static object library (LIB)

  Note that either SOXT_DLL or SOXT_NOT_DLL _must_ be defined by
  the application programmer on Microsoft Windows platforms, otherwise the
  #error statement will be hit. Set up one or the other of these two
  defines in your compiler environment according to how the library
  was built -- as a DLL (use "SOXT_DLL") or as a LIB (use
  "SOXT_NOT_DLL").

  (Setting up defines for the compiler is typically done by either
  adding something like "/DSOXT_DLL" to the compiler's argument
  line (for command-line build processes), or by adding the define to
  the list of preprocessor symbols in your IDE GUI (in the MSVC IDE,
  this is done from the "Project"->"Settings" menu, choose the "C/C++"
  tab, then "Preprocessor" from the drop down list and add the
  appropriate define)).

  It is extremely important that the application programmer uses the
  correct define, as using "SOXT_NOT_DLL" when "SOXT_DLL" is
  correct is likely to cause mysterious crashes.
 */
#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
# ifdef SOXT_INTERNAL
#  ifdef SOXT_MAKE_DLL
#   define SOXT_DLL_API __declspec(dllexport)
#  endif /* SOXT_MAKE_DLL */
# else /* !SOXT_INTERNAL */
#  ifdef SOXT_DLL
#   define SOXT_DLL_API __declspec(dllimport)
#  else /* !SOXT_DLL */
#   ifndef SOXT_NOT_DLL
#    error Define either SOXT_DLL or SOXT_NOT_DLL as appropriate for your linkage! See Inventor/Xt/SoXtBasic.h for further instructions.
#   endif /* SOXT_NOT_DLL */
#  endif /* !SOXT_DLL */
# endif /* !SOXT_MAKE_DLL */
#endif /* Microsoft Windows */

/* Empty define to avoid errors when _not_ compiling an Microsoft Windows DLL. */
#ifndef SOXT_DLL_API
# define SOXT_DLL_API
#endif /* !SOXT_DLL_API */

#ifndef GUI_TOOLKIT_VERSION
#define GUI_TOOLKIT_VERSION "238"
#endif /* GUI_TOOLKIT_VERSION */

#endif // ! SOXT_BASIC_H
