/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlrmlog.h,v 1.1.22.1 2004/07/09 01:58:02 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef SMLRMLOG_H
#define SMLRMLOG_H

// Include files
// Usually we don't include header files from
// other header files. However, the idea here is
// to produce a single header file on a per-module
// basis that can be used to include all the logging
// definitions necessary for that module.
#include "multilog.h"

//
// For debugging leaks in the SMIL renderer
//
#define MLOG_LEAKCHECK_COMPILED_OUT
#if defined(_DEBUG)
#define LEAKCHECK_TARGET_FILE      0
#define LEAKCHECK_TARGET_DEBUGGER  0
#else
#define LEAKCHECK_TARGET_FILE      1
#define LEAKCHECK_TARGET_DEBUGGER  0
#endif

// Create an inline MLOG_LEAKCHECK() function
#ifndef MLOG_LEAKCHECK_COMPILED_OUT
INIT_MULTILOG_GROUP_NO_COREDEBUG(LEAKCHECK,
                                 LEAKCHECK_TARGET_FILE,
                                 LEAKCHECK_TARGET_DEBUGGER,
                                 "smlrendr_leakcheck.log");
#else
#define MLOG_LEAKCHECK if(0)
#endif

//
// For debugging layout issues in the SMIL renderer
//
#define MLOG_LAYOUT_COMPILED_OUT
#if defined(_DEBUG)
#define LAYOUT_TARGET_FILE      0
#define LAYOUT_TARGET_DEBUGGER  1
#define LAYOUT_TARGET_COREDEBUG 0
#else
#define LAYOUT_TARGET_FILE      0
#define LAYOUT_TARGET_DEBUGGER  0
#define LAYOUT_TARGET_COREDEBUG 1
#endif

// Create an inline MLOG_LAYOUT() function
#ifndef MLOG_LAYOUT_COMPILED_OUT
INIT_MULTILOG_GROUP(LAYOUT,
                    LAYOUT_TARGET_FILE,
                    LAYOUT_TARGET_DEBUGGER,
                    LAYOUT_TARGET_COREDEBUG,
                    "smlrendr_layout.log",
                    DOL_SMIL_EXTENDED,
                    "DebugSMIL2Layout");
#else
#define MLOG_LAYOUT if(0)
#endif

//
// For debugging event issues in the SMIL renderer
//
#define MLOG_EVENT_COMPILED_OUT
#if defined(_DEBUG)
#define EVENT_TARGET_FILE      0
#define EVENT_TARGET_DEBUGGER  1
#define EVENT_TARGET_COREDEBUG 0
#else
#define EVENT_TARGET_FILE      0
#define EVENT_TARGET_DEBUGGER  0
#define EVENT_TARGET_COREDEBUG 0
#endif

// Create an inline MLOG_EVENT() function
#ifndef MLOG_EVENT_COMPILED_OUT
INIT_MULTILOG_GROUP(EVENT,
                    EVENT_TARGET_FILE,
                    EVENT_TARGET_DEBUGGER,
                    EVENT_TARGET_COREDEBUG,
                    "smlrendr_events.log",
                    DOL_SMIL_EXTENDED,
                    "DebugSMIL2Events");
#else
#define MLOG_EVENT if(0)
#endif

//
// For debugging animation issues in the SMIL renderer
//
#define MLOG_ANIM_COMPILED_OUT
#if defined(_DEBUG)
#define ANIM_TARGET_FILE      0
#define ANIM_TARGET_DEBUGGER  1
#define ANIM_TARGET_COREDEBUG 0
#else
#define ANIM_TARGET_FILE      0
#define ANIM_TARGET_DEBUGGER  0
#define ANIM_TARGET_COREDEBUG 1
#endif

// Create an inline MLOG_ANIM() function
#ifndef MLOG_ANIM_COMPILED_OUT
INIT_MULTILOG_GROUP(ANIM,
                    ANIM_TARGET_FILE,
                    ANIM_TARGET_DEBUGGER,
                    ANIM_TARGET_COREDEBUG,
                    "smlrendr_animate.log",
                    DOL_SMIL_EXTENDED,
                    "DebugSMIL2Animation");
#else
#define MLOG_ANIM if(0)
#endif

//
// For debugging issues related to media sources in the SMIL renderer
//
#define MLOG_SRC_COMPILED_OUT
#if defined(_DEBUG)
#define SRC_TARGET_FILE      0
#define SRC_TARGET_DEBUGGER  1
#define SRC_TARGET_COREDEBUG 0
#else
#define SRC_TARGET_FILE      0
#define SRC_TARGET_DEBUGGER  0
#define SRC_TARGET_COREDEBUG 0
#endif

// Create an inline MLOG_SRC() function
#ifndef MLOG_SRC_COMPILED_OUT
INIT_MULTILOG_GROUP(SRC,
                    SRC_TARGET_FILE,
                    SRC_TARGET_DEBUGGER,
                    SRC_TARGET_COREDEBUG,
                    "smlrendr_sources.log",
                    DOL_SMIL_EXTENDED,
                    "DebugSMIL2Sources");
#else
#define MLOG_SRC if(0)
#endif

//
// For debugging issues related to transitions in the SMIL renderer
//
#define MLOG_TRANS_COMPILED_OUT
#if defined(_DEBUG)
#define TRANS_TARGET_FILE      0
#define TRANS_TARGET_DEBUGGER  0
#define TRANS_TARGET_COREDEBUG 0
#else
#define TRANS_TARGET_FILE      0
#define TRANS_TARGET_DEBUGGER  0
#define TRANS_TARGET_COREDEBUG 1
#endif

// Create an inline MLOG_TRANS() function
#ifndef MLOG_TRANS_COMPILED_OUT
INIT_MULTILOG_GROUP(TRANS,
                    TRANS_TARGET_FILE,
                    TRANS_TARGET_DEBUGGER,
                    TRANS_TARGET_COREDEBUG,
                    "smlrendr_transitions.log",
                    DOL_SMIL_EXTENDED,
                    "DebugSMIL2Transitions");
#else
#define MLOG_TRANS if(0)
#endif

//
// For dumping OnTimeSync() and OnPosLength() in the SMIL renderer
//
#define MLOG_TIMESYNC_COMPILED_OUT
#if defined(_DEBUG)
#define TIMESYNC_TARGET_FILE      0
#define TIMESYNC_TARGET_DEBUGGER  0
#define TIMESYNC_TARGET_COREDEBUG 0
#else
#define TIMESYNC_TARGET_FILE      0
#define TIMESYNC_TARGET_DEBUGGER  0
#define TIMESYNC_TARGET_COREDEBUG 1
#endif

// Create an inline MLOG_TIMESYNC() function
#ifndef MLOG_TIMESYNC_COMPILED_OUT
INIT_MULTILOG_GROUP(TIMESYNC,
                    TIMESYNC_TARGET_FILE,
                    TIMESYNC_TARGET_DEBUGGER,
                    TIMESYNC_TARGET_COREDEBUG,
                    "smlrendr_timesync.log",
                    DOL_SMIL_EXTENDED,
                    "DebugSMIL2Timesync");
#else
#define MLOG_TIMESYNC if(0)
#endif

//
// For dumping general flow calls in the in the SMIL renderer
//
#define MLOG_FLOW_COMPILED_OUT
#if defined(_DEBUG)
#define FLOW_TARGET_FILE      0
#define FLOW_TARGET_DEBUGGER  1
#define FLOW_TARGET_COREDEBUG 0
#else
#define FLOW_TARGET_FILE      0
#define FLOW_TARGET_DEBUGGER  0
#define FLOW_TARGET_COREDEBUG 1
#endif

// Create an inline MLOG_FLOW() function
#ifndef MLOG_FLOW_COMPILED_OUT
INIT_MULTILOG_GROUP(FLOW,
                    FLOW_TARGET_FILE,
                    FLOW_TARGET_DEBUGGER,
                    FLOW_TARGET_COREDEBUG,
                    "smlrendr_flow.log",
                    DOL_SMIL_EXTENDED,
                    "DebugSMIL2Flow");
#else
#define MLOG_FLOW if(0)
#endif

#endif // #ifndef SMLRMLOG_H
