/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: ihxmimeinfo.h,v 1.3.4.3 2004/07/09 01:48:38 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __ihxmimeinfo_h
#define __ihxmimeinfo_h


// {98928FF0-9CA1-4542-AD25-B1F2ED93504D}
DEFINE_GUID(IID_IHXMimeInfo,
	    0x98928ff0, 0x9ca1, 0x4542,
	    0xad, 0x25, 0xb1, 0xf2, 0xed, 0x93, 0x50, 0x4d);


DECLARE_INTERFACE_(IHXMimeInfo, IUnknown)
{
    STDMETHOD_(const char*, GetName)     (THIS) CONSTMETHOD PURE;
    STDMETHOD(SetName)                   (THIS_ const char* pName) PURE;
    STDMETHOD_(const char*, GetIcon)     (THIS) CONSTMETHOD PURE;
    STDMETHOD(SetIcon)                   (THIS_ const char* pIcon) PURE;
    STDMETHOD_(const char*, GetType)     (THIS) CONSTMETHOD PURE;
    STDMETHOD(SetType)                   (THIS_ const char* pType) PURE;
    STDMETHOD_(const char*, GetProtocol) (THIS) CONSTMETHOD PURE;
    STDMETHOD(SetProtocol)               (THIS_ const char* pProtocol) PURE;
    STDMETHOD(GetExts)                   (THIS_ REF(const char**) ppExts,
					  REF(UINT32) uCount) PURE;
    STDMETHOD(AddExt)                    (THIS_ const char* pExt) PURE;
    STDMETHOD(RemoveExt)                 (THIS_ const char* pExt) PURE;
};


#endif /* #ifndef __ihxmimeinfo_h */
