/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: region.h,v 1.1.1.1.42.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/************************************************************************

Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

************************************************************************/

#ifndef _HXREGION_H
#define _HXREGION_H
 
#include "hxwintyp.h"

/*
 * XXXgfw
 * 
 * Moved the below definitions to hxwintyp.h so we can pass this
 * stuff back and forth from renderers.
 *
 */
/* #ifndef _REGION_DEFINED */
/* #define _REGION_DEFINED */
/* typedef struct { */
/*     short x1, x2, y1, y2; */
/* } HXBOX, *HXBoxPtr; */

/* typedef struct _HXxRegion */
/* { */
/*     HXBOX* rects; */
/*     long    numRects; */
/* } HXxBoxRegion, *HXxRegionPtr; */

/* #endif */


typedef struct _stHXRegion
{
    long    size;
    long    numRects;
    HXBOX* rects;
    HXBOX  extents;
} HXREGION, *HXREGIONPtr;

typedef HXREGION* _HXRegion;

typedef struct {
    short x, y, width, height;
}HXRECTANGLE, *HXRECTANGLEPtr;

typedef enum _HXRegionArithmetic
{
   HX_RGN_DIFF = 0,
   HX_RGN_AND,
   HX_RGN_OR,
   HX_RGN_XOR
} HXRegionArithmetic;


#define TRUE 1
#define FALSE 0
#ifndef MAXSHORT 
#define MAXSHORT 32767
#endif
#ifndef MINSHORT
#define MINSHORT -MAXSHORT
#endif
#ifndef MAX
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#endif

/*  1 if two HXBOXs overlap.
 *  0 if two HXBOXs do not overlap.
 *  Remember, x2 and y2 are not in the region 
 */
#define EXTENTCHECK(r1, r2) \
	((r1)->x2 > (r2)->x1 && \
	 (r1)->x1 < (r2)->x2 && \
	 (r1)->y2 > (r2)->y1 && \
	 (r1)->y1 < (r2)->y2)

/*
 *  update region extents
 */
#define EXTENTS(r,idRect){\
            if((r)->x1 < (idRect)->extents.x1)\
              (idRect)->extents.x1 = (r)->x1;\
            if((r)->y1 < (idRect)->extents.y1)\
              (idRect)->extents.y1 = (r)->y1;\
            if((r)->x2 > (idRect)->extents.x2)\
              (idRect)->extents.x2 = (r)->x2;\
            if((r)->y2 > (idRect)->extents.y2)\
              (idRect)->extents.y2 = (r)->y2;\
        }

/*
 *   Check to see if there is enough memory in the present region.
 */
#define MEMCHECK(reg, rect, firstrect){\
        if ((reg)->numRects >= ((reg)->size - 1)){\
          (firstrect) = (HXBOX *) realloc \
          ((char *)(firstrect), (unsigned) (2 * (sizeof(HXBOX)) * ((reg)->size)));\
          if ((firstrect) == 0)\
            return(0);\
          (reg)->size *= 2;\
          (rect) = &(firstrect)[(reg)->numRects];\
         }\
       }

/*  this routine checks to see if the previous rectangle is the same
 *  or subsumes the new rectangle to add.
 */

#define CHECK_PREVIOUS(Reg, R, Rx1, Ry1, Rx2, Ry2)\
               (!(((Reg)->numRects > 0)&&\
                  ((R-1)->y1 == (Ry1)) &&\
                  ((R-1)->y2 == (Ry2)) &&\
                  ((R-1)->x1 <= (Rx1)) &&\
                  ((R-1)->x2 >= (Rx2))))

/*  add a rectangle to the given _HXRegion */
#define ADDRECT(reg, r, rx1, ry1, rx2, ry2){\
    if (((rx1) < (rx2)) && ((ry1) < (ry2)) &&\
        CHECK_PREVIOUS((reg), (r), (rx1), (ry1), (rx2), (ry2))){\
              (r)->x1 = (rx1);\
              (r)->y1 = (ry1);\
              (r)->x2 = (rx2);\
              (r)->y2 = (ry2);\
              EXTENTS((r), (reg));\
              (reg)->numRects++;\
              (r)++;\
            }\
        }



/*  add a rectangle to the given _HXRegion */
#define ADDRECTNOX(reg, r, rx1, ry1, rx2, ry2){\
            if ((rx1 < rx2) && (ry1 < ry2) &&\
                CHECK_PREVIOUS((reg), (r), (rx1), (ry1), (rx2), (ry2))){\
              (r)->x1 = (rx1);\
              (r)->y1 = (ry1);\
              (r)->x2 = (rx2);\
              (r)->y2 = (ry2);\
              (reg)->numRects++;\
              (r)++;\
            }\
        }

#define EMPTY_REGION(pReg) pReg->numRects = 0

#define REGION_NOT_EMPTY(pReg) pReg->numRects

#define INHXBOX(r, x, y) \
      ( ( ((r).x2 >  x)) && \
        ( ((r).x1 <= x)) && \
        ( ((r).y2 >  y)) && \
        ( ((r).y1 <= y)) )

/*
 * number of points to buffer before sending them off
 * to scanlines() :  Must be an even number
 */
#define NUMPTSTOBUFFER 200

/*
 * used to allocate buffers for points and link
 * the buffers together
 */
typedef struct _POINTBLOCK {
    HXxPoint pts[NUMPTSTOBUFFER];
    struct _POINTBLOCK *next;
} POINTBLOCK;

#define HXRectangleOut   -1
#define HXRectanglePart   1
#define HXRectangleIn	0

/* PROTOTYPES */

/* Internal Functions */
static void miSetExtents (_HXRegion pReg);
static void Compress(_HXRegion r, _HXRegion s, _HXRegion t, unsigned dx, int xdir, int grow);
static HXBOX *IndexRects(HXBOX *rects, int numRects, int y);
static int miIntersectO (_HXRegion pReg, HXBoxPtr r1, HXBoxPtr r1End, HXBoxPtr r2, HXBoxPtr r2End, short y1, short y2);
static void miRegionCopy(_HXRegion dstrgn, _HXRegion rgn);
static void CombineRegs(_HXRegion newReg, _HXRegion reg1, _HXRegion reg2);
static int QuickCheck(_HXRegion newReg, _HXRegion reg1, _HXRegion reg2);
static int TopRects(_HXRegion newReg, HXBOX *rects, _HXRegion reg1, _HXRegion reg2, HXBOX *FirstRect);

/* Interfaces */

#ifdef __cplusplus
extern  "C"
{
#endif
    _HXRegion HXCreateRegion();
    _HXRegion HXCreateRectRegion(int, int, int, int);

    int	HXClipBox( _HXRegion r, HXRECTANGLE* rect);
    int	HXUnionRectWithRegion(HXRECTANGLE* rect, _HXRegion source, _HXRegion dest);
    int	HXDestroyRegion(_HXRegion r);
    int	HXOffsetRegion(_HXRegion pRegion, int x, int y);
    int	HXShrinkRegion(_HXRegion r, int dx, int dy);
    int	HXUnionRegion(_HXRegion reg1, _HXRegion reg2, _HXRegion newReg);
    int	HXXorRegion( _HXRegion sra, _HXRegion srb, _HXRegion dr );
    int	HXIntersectRegion(_HXRegion reg1, _HXRegion reg2, _HXRegion  newReg);
    int	HXRectInRegion(_HXRegion	region, int rx, int ry, unsigned int rwidth, unsigned int rheight);
    int	HXPointInRegion( _HXRegion pRegion, int x, int y );
    int	HXEqualRegion( _HXRegion r1, _HXRegion r2);
    int	HXSubtractRegion(_HXRegion regM, _HXRegion regS, _HXRegion regD);
    int HXEmptyRegion( _HXRegion r);
    int HXCombineRgn( _HXRegion destRgn,
                       _HXRegion srcRgn1,
                       _HXRegion srcRgn2,
                       HXRegionArithmetic rgnOperation
                       );
    int HXZeroOutRegion(_HXRegion r);


#ifdef _DEBUG
   void _DumpRegion(_HXRegion pRegion );
   void _DumpString(const char *);
#endif
         
#ifdef __cplusplus
}
#endif

#endif

