/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: mkstatic.cpp,v 1.1.26.1 2004/07/09 01:54:32 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// system
#include <stdio.h>

// include
#include "hxtypes.h"

// zlib
#include "zlib.h"

void main(int argc, char** argv)
{
    if (argc != 2)
    {
        printf("Usage: mkstatic file.bmp\n");
        return;
    }

    FILE* fp = fopen(argv[1], "rb");
    if (!fp)
    {
        printf("Cannot open %s.\n", argv[1]);
        return;
    }

    fseek(fp, 0, SEEK_END);
    UINT32 ulLen = (UINT32) ftell(fp);
    fseek(fp, 0, SEEK_SET);

    BYTE* pBuf = new BYTE [ulLen];
    if (!pBuf)
    {
        fclose(fp);
        printf("Could not allocate input memory.\n");
        return;
    }
    fread(pBuf, 1, ulLen, fp);
    fclose(fp);

    // Compute max size of output buffer
    // as described in zlib.h
    UINT32 ulMaxOutLen = ulLen                  +  // original size
                         ((ulLen + 500) / 1000) +  // 0.1% of original size
                         12;                       // extra 12 bytes
    BYTE* pOutBuf = new BYTE [ulMaxOutLen];
    if (!pOutBuf)
    {
        HX_VECTOR_DELETE(pBuf);
        printf("Could not allocate output memory.\n");
        return;
    }

    // zlib compress the image
    UINT32 ulCompLen = ulMaxOutLen;
    INT32 lRet       = compress(pOutBuf, &ulCompLen, pBuf, ulLen);
    if (lRet != Z_OK)
    {
        HX_VECTOR_DELETE(pBuf);
        HX_VECTOR_DELETE(pOutBuf);
        printf("zlib compression failed.\n");
        return;
    }

    printf("const UINT32 PXMakeBombImage::m_ulOriginalSize      = %lu;\n", ulLen);
    printf("const UINT32 PXMakeBombImage::m_ulImageBufferLength = %lu;\n", ulCompLen);
    printf("const BYTE   PXMakeBombImage::m_pImageBuffer[]      =\n{\n    ");

    for (UINT32 i = 0; i < ulCompLen; i++)
    {
        printf("0x%02X", pOutBuf[i]);
        if (i != ulCompLen - 1)
        {
            printf(", ");
        }
        if ((i%12) == 11 || i == ulCompLen - 1)
        {
            printf("\n");
            if (i != ulCompLen - 1)
            {
                printf("    ");
            }
        }
    }
    printf("};\n");

    HX_VECTOR_DELETE(pBuf);
    HX_VECTOR_DELETE(pOutBuf);
}
