/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pximgdec.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXIMGDEC_H
#define PXIMGDEC_H

#define IMAGE_DECODER_FREQUENCY_LOW     0
#define IMAGE_DECODER_FREQUENCY_MEDIUM  1
#define IMAGE_DECODER_FREQUENCY_HIGH    2

#define IMAGE_DECODER_COLOR_RGB24       0
#define IMAGE_DECODER_COLOR_BGR24       1
#define IMAGE_DECODER_COLOR_BGRx32      2
#define IMAGE_DECODER_COLOR_xRGB32      3
#define IMAGE_DECODER_COLOR_RGB555      4
#define IMAGE_DECODER_COLOR_RGB565      5

/****************************************************************************
 *
 *  Typical Usage of IHXImageDecoder
 *
 *  Assume: a) We have an image file in a single IHXBuffer.
 *          b) The image in the file has F frames, labelled frame 0 through
 *             frame F-1. Each of the frames could have different dimensions.
 *
 *  1. Call InitDecode() to pass the file IHXBuffer to the decoder.
 *     You get back a session handle which you will use to refer to
 *     this image in all subsequent calls.
 *  2. Call GetImageInfo() to find out the number of frames F.
 *  3. Call GetFrameInfo() F times (with ulFrameNum going from 0 to F-1)
 *  4. Allocate F output buffers, each of the appropriate size.
 *  4. Call SetDecodeParameters() F times, passing in each of the buffers
 *  5. Call Decompress() over and over until rulPercentDone == 100. If you
 *     want to only have to make one call to Decompress(), set ulReturnFrequency
 *     in SetDecodeParameters() to IMAGE_DECODE_FREQUENCY_LOW.
 *  6. Call FinishDecompress().
 *
 ****************************************************************************/
typedef _INTERFACE IHXImageDecoder IHXImageDecoder;

/****************************************************************************
 *
 *  Interface: IHXImageDecoder
 *
 *  Purpose:   General interface for decoding different image formats
 *
 *  IID_IHXImageDecoder: {27D18D40-1195-423e-B914-6FD216D57846}
 *
 ****************************************************************************/
DEFINE_GUID(IID_IHXImageDecoder, 0x27d18d40, 0x1195, 0x423e, 0xb9, 0x14,
            0x6f, 0xd2, 0x16, 0xd5, 0x78, 0x46);

#undef  INTERFACE
#define INTERFACE IHXImageDecoder

DECLARE_INTERFACE_(IHXImageDecoder, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)  (THIS) PURE;

    STDMETHOD_(UINT32,Release) (THIS) PURE;

    /*
     * IHXImageDecoder Methods
     */

    /************************************************************************
     *  Method:
     *      IHXImageDecoder::ValidInputData()
     *  Purpose:
     *      Determines whether the input buffer is an image format 
     *      this codec can decode.
     */
    STDMETHOD_(BOOL,ValidInputData) (THIS_ IHXBuffer* pBuffer) PURE;

    /************************************************************************
     *  Method:
     *      IHXImageDecoder::InitDecode()
     *  Purpose:
     *      This method intializes the decoder. The IHXBuffer containing
     *      the entire image file is passed in, and a session handle is
     *      returned. This session handle should be used for all successive
     *      calls regarding this image file.
     */
    STDMETHOD(InitDecode) (THIS_ IHXBuffer* pBuffer, REF(UINT32) rulSessionHandle) PURE;

    /************************************************************************
     *  Method:
     *      IHXImageDecoder::GetImageInfo()
     *  Purpose:
     *      This method returns information about the image file. Special
     *      image-level, format-specific information may be returned in
     *      the rpImageInfo IHXValues.
     */
    STDMETHOD(GetImageInfo) (THIS_ UINT32           ulSessionHandle,
                                   REF(UINT32)      rulImageWidth,
                                   REF(UINT32)      rulImageHeight,
                                   REF(UINT32)      rulNumFrames,
                                   REF(IHXValues*) rpImageInfo) PURE;

    /************************************************************************
     *  Method:
     *      IHXImageDecoder::GetFrameInfo()
     *  Purpose:
     *      This method returns information about each frame in a
     *      multi-frame image. Special frame-level, codee-specific information
     *      may be returned in the rpFrameInfo IHXValues.
     */
    STDMETHOD(GetFrameInfo) (THIS_ UINT32           ulSessionHandle,
                                   UINT32           ulFrameNum,
                                   REF(UINT32)      rulFrameWidth,
                                   REF(UINT32)      rulFrameHeight,
                                   REF(IHXValues*) rpFrameInfo) PURE;

    /************************************************************************
     *  Method:
     *      IHXImageDecoder::SetDecodeParameters()
     *  Purpose:
     *      This methods sets the decompression parameters, such as the
     *      output width and height. It also sets the output buffer and
     *      gives the color and pixel format to which the image should be
     *      decoded. Additional codec-specific decompression parameters
     *      can be set in pMoreParam.
     */
    STDMETHOD(SetDecodeParameters) (THIS_ UINT32      ulSessionHandle,
                                          UINT32      ulFrameNum,
                                          BYTE*       pOutputBuffer,
                                          UINT32      ulWidth,
                                          UINT32      ulHeight,
                                          UINT32      ulRowStride,
                                          UINT32      ulBitsPerPixel,
                                          UINT32      ulColorFormat,
                                          BOOL        bRowsInverted,
                                          UINT32      ulReturnFrequency,
                                          IHXValues* pMoreParam) PURE;

    /************************************************************************
     *  Method:
     *      IHXImageDecoder::Decompress()
     *  Purpose:
     *      This method actually decodes the compressed data in pBuffer into
     *      the appropriate output buffer. 
     */
    STDMETHOD(Decompress) (THIS_ UINT32      ulSessionHandle,
                                 REF(UINT32) rulPercentDone) PURE;

    /************************************************************************
     *  Method:
     *      IHXImageDecoder::FinishDecompress()
     *  Purpose:
     *      This method informs the codec that the caller is finished
     *      with this decompression session and the codec can release
     *      any resources allocated for this session. The codec should
     *      be prepared to accept FinishDecompress() at any time after
     *      GetHeaderInfo().
     */
    STDMETHOD(FinishDecompress) (THIS_ UINT32 ulSessionHandle) PURE;
};

typedef struct HXEXPORT_CLASS _OutputImageFrame
{
    IHXBuffer* m_pImageBuffer;
    UINT32      m_ulWidth;
    UINT32      m_ulHeight;
}
OutputImageFrame;

/****************************************************************************
 *
 *  Interface: IHXSimpleImageDecoder
 *
 *  Purpose:   Simplest possible interface for decoding different image formats
 *
 *  IID_IHXSimpleImageDecoder: {8915188F-76A4-487f-A1F6-F9D5B93A9EB6}
 *
 ****************************************************************************/
DEFINE_GUID(IID_IHXSimpleImageDecoder, 0x8915188f, 0x76a4, 0x487f, 0xa1, 0xf6,
            0xf9, 0xd5, 0xb9, 0x3a, 0x9e, 0xb6);

#undef  INTERFACE
#define INTERFACE IHXSimpleImageDecoder

DECLARE_INTERFACE_(IHXSimpleImageDecoder, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)  (THIS) PURE;

    STDMETHOD_(UINT32,Release) (THIS) PURE;

    /*
     * IHXSimpleImageDecoder Methods
     */

    /************************************************************************
     *  Method:
     *      IHXSimpleImageDecoder::ValidInputData()
     *  Purpose:
     *      Determines whether the input buffer is an image format 
     *      this codec can decode.
     */
    STDMETHOD_(BOOL,ValidInputData) (THIS_ IHXBuffer* pBuffer) PURE;

    /************************************************************************
     *  Method:
     *      IHXSimpleImageDecoder::SetOutputBufferFormat()
     *  Purpose:
     *      This methods sets the preferences for the depth, color format,
     *      and row inversion for the output buffer. These preferences
     *      can be set once and will remain set between calls to Decode().
     */
    STDMETHOD(SetOutputBufferFormat) (THIS_ UINT32      ulBitsPerPixel,
                                            UINT32      ulColorFormat,
                                            BOOL        bRowsInverted) PURE;

    /************************************************************************
     *  Method:
     *      IHXSimpleImageDecoder::Decode()
     *  Purpose:
     *      This method provides one-step decoding.
     */
    STDMETHOD(Decode) (THIS_ IHXBuffer*            pFileBuffer,
                             REF(UINT32)            rulNumFrames,
                             REF(OutputImageFrame*) rpFrame) PURE;
};

#endif

