/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxschedu.h,v 1.1.26.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXSCHEDU_H
#define PXSCHEDU_H

class PXScheduler : public CHXBaseCountingObject,
                    public CUnknownIMP
{
    DECLARE_UNKNOWN(PXScheduler)
public:
    HX_RESULT Init(PXRealPixFile*       pRealPixFile,
                   PXWireFormatManager* pWireFormatManager);
    BOOL      IsStreamDone() const;
    HX_RESULT GetNextPacketInfo(REF(UINT32) rulPacketType);
    HX_RESULT GetImageHeaderInfo(REF(UINT32)      rulHandle,
                                 REF(UINT32)      rulImageSize,
                                 REF(IHXBuffer*) rpFileMimeStr,
                                 REF(IHXBuffer*) rpFileNameStr,
                                 REF(IHXBuffer*) rpStreamMimeStr,
                                 REF(UINT32)      rulTimeStamp);
    HX_RESULT SetImageDataInfo(UINT32 ulNumPackets,
                               UINT32 ulSessionHandle);
    HX_RESULT GetImageDataInfo(REF(UINT32)      rulHandle,
                               REF(IHXBuffer*) rpStreamMimeStr,
                               REF(UINT32)      rulSessionHandle,
                               REF(UINT32)      rulPacketIndex,
                               REF(UINT32)      rulNumPackets,
                               REF(UINT32)      rulTimeStamp);
    HX_RESULT GetEffectInfo(REF(PXEffect*) rpEffect,
                            REF(UINT32) rulTimeStamp);
    HX_RESULT PacketSent(UINT32 ulPacketSize);
    HX_RESULT SeekSetup(UINT32 ulSeekTime);
    UINT32    GetMinimumPreroll() const;
    void      SetAuthoredPreroll(UINT32 ulPreroll);
    UINT32    GetSendTime(UINT32 ulNumBytes, UINT32 ulBitrate);
protected:
    PXScheduler();
    virtual ~PXScheduler();

    void      Reset();
    void      Deallocate();
    HX_RESULT Rewind();
    BOOL      IsImageCachedAtTime(UINT32 ulHandle, UINT32 ulTime);
#if 0
    HX_RESULT IncrementPacket(UINT32 ulPacketSize);
    HX_RESULT DoSeekCheck(UINT32 ulKeyScreenTime);
#endif

    PXRealPixFile*       m_pRealPixFile;
    PXWireFormatManager* m_pWireFormatManager;
    UINT32               m_ulMinimumPreroll;
    void*                m_pEffectItr;
    UINT32               m_ulPacketTypeState;
    INT32                m_lCurrentTimeStamp;
    UINT32               m_ulSessionHandle;
    UINT32               m_ulNumPackets;
    UINT32               m_ulPacketIndex;
    UINT32               m_ulKeyScreenTime;
    BOOL                 m_bSeeking;
};

inline UINT32 PXScheduler::GetMinimumPreroll() const
{
    return m_ulMinimumPreroll;
}

inline UINT32 PXScheduler::GetSendTime(UINT32 ulNumBytes, UINT32 ulBitrate)
{
    UINT32 ulRet = 0;
    if (ulBitrate)
    {
        ulRet = (ulNumBytes * 8000 + ulBitrate - 1) / ulBitrate;
    }
    return ulRet;
}

#endif
