/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: siteuser.cpp,v 1.4.12.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxwin.h"
#include "hxevent.h"
#include "hxvsurf.h"
#include "ihxpckts.h"
#include "hxcomm.h"
#include "hxerror.h"
#include "hlxclib/string.h"
// pnmisc
#include "hxtick.h"
// smlrendr
#include "siteuser.h"
// pndebug
#include "smlrmlog.h"
#include "hxassert.h"
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif

CSmilSiteUser::CSmilSiteUser(CSmilSiteUserResponse* pResponse,
                             UINT32                 ulBackgroundColor,
                             IUnknown*              pContext,
                             BOOL                   bIsARoot,
                             const char*            pszID)
{
    m_lRefCount                  = 0;
    m_pResponse                  = pResponse;
    m_ulBackgroundColor          = ulBackgroundColor;
    m_bIsARoot                   = bIsARoot;
    m_pSite                      = NULL;
    m_pValues                    = NULL;
    m_pszID                      = NULL;
    m_ulLastMediaEndOverrideTime = 0;
    m_pErrorMessages             = NULL;
    m_pBitmapInfoHeader          = NULL;
    m_pucBuffer                  = NULL;
    m_ulLastBackgroundColor      = 0;
    
    HX_ASSERT(m_pResponse);
    if (m_pResponse)
    {
        m_pResponse->AddRef();
    }
    if (pContext)
    {
        IHXCommonClassFactory* pFact = NULL;
        pContext->QueryInterface(IID_IHXCommonClassFactory, (void**) &pFact);
        if (pFact)
        {
            pFact->CreateInstance(CLSID_IHXValues, (void**) &m_pValues);
        }
        HX_RELEASE(pFact);
        // QI for IHXErrorMessages - ok if we don't get it
        pContext->QueryInterface(IID_IHXErrorMessages,
                                 (void**) &m_pErrorMessages);
    }
    if (pszID)
    {
        m_pszID = new char [strlen(pszID) + 1];
        if (m_pszID)
        {
            strcpy(m_pszID, pszID); /* Flawfinder: ignore */
        }
    }
    // Allocate an HXBitmapInfoHeader
    m_pBitmapInfoHeader = new HXBitmapInfoHeader;
    if (m_pBitmapInfoHeader)
    {
        // Set up all the values
        m_pBitmapInfoHeader->biSize          = 40;
        m_pBitmapInfoHeader->biWidth         = 0;
        m_pBitmapInfoHeader->biHeight        = 0;
        m_pBitmapInfoHeader->biPlanes        = 1;
        m_pBitmapInfoHeader->biBitCount      = 32;
        m_pBitmapInfoHeader->biCompression   = HX_RGB;
        m_pBitmapInfoHeader->biSizeImage     = 0;
        m_pBitmapInfoHeader->biXPelsPerMeter = 0;
        m_pBitmapInfoHeader->biYPelsPerMeter = 0;
        m_pBitmapInfoHeader->biClrUsed       = 0;
        m_pBitmapInfoHeader->biClrImportant  = 0;
        m_pBitmapInfoHeader->rcolor          = 0;
        m_pBitmapInfoHeader->gcolor          = 0;
        m_pBitmapInfoHeader->bcolor          = 0;
    }
}

CSmilSiteUser::~CSmilSiteUser()
{
    Close();
}


STDMETHODIMP CSmilSiteUser::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if(IsEqualIID(riid, IID_IUnknown))
    {
        AddRef();
        *ppvObj = (IUnknown*) (IHXSiteUser*) this;
    }
    else if(IsEqualIID(riid, IID_IHXSiteUser))
    {
        AddRef();
        *ppvObj = (IHXSiteUser*) this;
    }
    else if(IsEqualIID(riid, IID_IHXValues))
    {
        AddRef();
        *ppvObj = (IHXValues*) this;
    }
    else
    {
        *ppvObj = NULL;
        retVal  = HXR_NOINTERFACE;
    }

    return retVal;
}

STDMETHODIMP_(ULONG32) CSmilSiteUser::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG32) CSmilSiteUser::Release()
{
    if(InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;
    return 0;
}

STDMETHODIMP CSmilSiteUser::AttachSite(IHXSite* pSite)
{
    HX_RESULT retVal = HXR_OK;

    if (pSite && !m_pSite)
    {
        // Save the site
        m_pSite = pSite;
        m_pSite->AddRef();
        
        // See if we have a new site that supports sub rects.
        IHXSubRectSite* pSubRectSite = NULL;
        m_pSite->QueryInterface(IID_IHXSubRectSite, (void**) &pSubRectSite);
        if(pSubRectSite)
        {
            // If so, since IHXSubRectSite inheirits from IHXSite, lets just
            // swap the pointers and sign up for the service.
            HX_RELEASE(m_pSite);
            m_pSite = pSubRectSite;
            pSubRectSite->SendSubRectMessages(TRUE);
        }

        // Call back to the response interface
        if (m_pResponse)
        {
            retVal = m_pResponse->SiteUserAttachSite(this, m_pSite);
        }
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::DetachSite()
{
    HX_RESULT retVal = HXR_OK;

    // Calling SiteUserDetachSite() may result in
    // one of our own refs being released. Therefore,
    // we will call AddRef() on ourselves until
    // this method is finished.
    AddRef();
    // Call back to the response interface FIRST, since
    // one of the actions of the response interface may
    // be to delete children of this site.
    if (m_pResponse)
    {
        retVal = m_pResponse->SiteUserDetachSite(this);
    }
    // Release the site
    HX_RELEASE(m_pSite);
    // Now we can safely release
    Release();

    return retVal;
}

STDMETHODIMP_(BOOL) CSmilSiteUser::NeedsWindowedSites()
{
    return FALSE;
}

STDMETHODIMP CSmilSiteUser::HandleEvent(HXxEvent* pEvent)
{
    HX_RESULT retVal = HXR_OK;

    if (pEvent)
    {
        // Set defaults
        pEvent->handled = FALSE;
        pEvent->result  = HXR_OK;
        // Switch based on event type
        switch (pEvent->event)
        {
            case HX_SURFACE_UPDATE:
                {
                    pEvent->result = SetupBuffer();
                    if (SUCCEEDED(pEvent->result))
                    {
                        // Set up the src and dst rect
                        HXxRect cSrcRect = {0,
                                            0,
                                            m_pBitmapInfoHeader->biWidth,
                                            m_pBitmapInfoHeader->biHeight};
                        HXxRect cDstRect = cSrcRect;
                        // Do the blt
                        IHXVideoSurface* pSurf = (IHXVideoSurface*) pEvent->param1;
                        if(pSurf)
                        {
                            MLOG_LAYOUT(m_pErrorMessages,
                                        "CSmilSiteUser::HandleEvent() HX_SURFACE_UPDATE "
                                        "region=%s root=%lu tick=%lu color=0x%08x\n",
                                        m_pszID, m_bIsARoot, HX_GET_BETTERTICKCOUNT(), m_ulBackgroundColor);
                            pSurf->AddRef();
                            pEvent->result = pSurf->Blt(m_pucBuffer,
                                                        m_pBitmapInfoHeader,
                                                        cDstRect,
                                                        cSrcRect);
                            pSurf->Release();
                            if (SUCCEEDED(pEvent->result))
                            {
                                pEvent->handled = TRUE;
                            }
                        }
                    }
                }
                break;

            case HX_SURFACE_UPDATE2:
                {
                    pEvent->result = SetupBuffer();
                    if (SUCCEEDED(pEvent->result))
                    {
                        // Get the video surface and the expose info
                        IHXSubRectVideoSurface* pSurf   = (IHXSubRectVideoSurface*) pEvent->param1;
                        HXxExposeInfo*           pExpose = (HXxExposeInfo*) pEvent->param2;
                        // Since there is no scaling, our SRC and DEST rects
                        // are all the same. Since that is the case we can
                        // just pass the rect pointer from the Expose event
                        // into the BLT call.
                        if (pSurf && pExpose)
                        {
                            MLOG_LAYOUT(m_pErrorMessages,
                                        "CSmilSiteUser::HandleEvent() HX_SURFACE_UPDATE2 "
                                        "region=%s root=%lu tick=%lu color=0x%08x\n",
                                        m_pszID, m_bIsARoot, HX_GET_BETTERTICKCOUNT(), m_ulBackgroundColor);
                            pSurf->AddRef();
                            pEvent->result = pSurf->BltSubRects(m_pucBuffer,
                                                                m_pBitmapInfoHeader,
                                                                pExpose->pRegion,
                                                                pExpose->pRegion, 1.0, 1.0);
                            pSurf->Release();
                            if (SUCCEEDED(pEvent->result))
                            {
                                pEvent->handled = TRUE;
                            }
                        }
                    }
                }
                break;

            default:
                break;
        }

        // If we have not handled the event, then pass it
        // on to the response interface
        if (!pEvent->handled && m_pResponse)
        {
            m_pResponse->SiteUserHandleEvent(this, pEvent);
        }
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::SetPropertyULONG32(const char* pName, ULONG32 ulVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->SetPropertyULONG32(pName, ulVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetPropertyULONG32(const char* pName, REF(ULONG32) rulVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetPropertyULONG32(pName, rulVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetFirstPropertyULONG32(REF(const char*) rpName, REF(ULONG32) rulVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetFirstPropertyULONG32(rpName, rulVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetNextPropertyULONG32(REF(const char*) rpName, REF(ULONG32) rulVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetNextPropertyULONG32(rpName, rulVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::SetPropertyBuffer(const char* pName, IHXBuffer* pVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->SetPropertyBuffer(pName, pVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetPropertyBuffer(const char* pName, REF(IHXBuffer*) rpVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetPropertyBuffer(pName, rpVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetFirstPropertyBuffer(REF(const char*) rpName, REF(IHXBuffer*) rpVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetFirstPropertyBuffer(rpName, rpVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetNextPropertyBuffer(REF(const char*) rpName, REF(IHXBuffer*) rpVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetNextPropertyBuffer(rpName, rpVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::SetPropertyCString(const char* pName, IHXBuffer* pVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->SetPropertyCString(pName, pVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetPropertyCString(const char* pName, REF(IHXBuffer*) rpVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetPropertyCString(pName, rpVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetFirstPropertyCString(REF(const char*) rpName, REF(IHXBuffer*) rpVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetFirstPropertyCString(rpName, rpVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::GetNextPropertyCString(REF(const char*) rpName, REF(IHXBuffer*) rpVal)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pValues)
    {
        retVal = m_pValues->GetNextPropertyCString(rpName, rpVal);
    }

    return retVal;
}

STDMETHODIMP CSmilSiteUser::SetBackgroundColor(UINT32 ulBackgroundColor)
{
    HX_RESULT retVal = HXR_OK;

    m_ulBackgroundColor = ulBackgroundColor;

    return retVal;
}

STDMETHODIMP_(UINT32) CSmilSiteUser::GetBackgroundColor()
{
    return m_ulBackgroundColor;
}

STDMETHODIMP CSmilSiteUser::Close()
{
    HX_RESULT retVal = HXR_OK;

    if (m_pResponse)
    {
        m_pResponse->Release();
        m_pResponse = NULL;
    }
    HX_RELEASE(m_pSite);
    HX_RELEASE(m_pValues);
    HX_VECTOR_DELETE(m_pszID);
    HX_RELEASE(m_pErrorMessages);
    HX_VECTOR_DELETE(m_pBitmapInfoHeader);
    HX_VECTOR_DELETE(m_pucBuffer);

    return retVal;
}

STDMETHODIMP_(UINT32) CSmilSiteUser::GetLastMediaEndOverrideTime()
{
    return m_ulLastMediaEndOverrideTime;
}

STDMETHODIMP CSmilSiteUser::SetLastMediaEndOverrideTime(UINT32 ulTime)
{
    m_ulLastMediaEndOverrideTime = ulTime;
    return HXR_OK;
}

STDMETHODIMP CSmilSiteUser::Redraw()
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pSite)
    {
        // Get the current site size
        HXxSize cSize = {0, 0};
        m_pSite->GetSize(cSize);
        // Create a damage rect
        HXxRect cRect = {0, 0, cSize.cx, cSize.cy};
        m_pSite->DamageRect(cRect);
        m_pSite->ForceRedraw();
        // Clear the return value
        retVal = HXR_OK;
    }

    return retVal;
}

HX_RESULT CSmilSiteUser::SetupBuffer()
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pSite && m_pBitmapInfoHeader)
    {
        // Set the color we are going to blt
        UINT32 ulColor = m_ulBackgroundColor;
        // If we are a root, then force the 
        // background color to be non-transparent
        if (m_bIsARoot)
        {
            ulColor &= 0x00FFFFFF;
        }
        // Get the site's current size
        HXxSize cSize = {0, 0};
        m_pSite->GetSize(cSize);
        // Make sure the site has non-zero dimensions
        if (cSize.cx > 0 && cSize.cy > 0)
        {
            // Do we need to allocate a buffer?
            BOOL bAllocated = FALSE;
            if (!m_pucBuffer                              ||
                m_pBitmapInfoHeader->biWidth  != cSize.cx ||
                m_pBitmapInfoHeader->biHeight != cSize.cy)
            {
                UINT32 ulNumBytes = (UINT32) cSize.cx * cSize.cy * 4;
                HX_VECTOR_DELETE(m_pucBuffer);
                m_pucBuffer = new BYTE [ulNumBytes];
                if (m_pucBuffer)
                {
                    m_pBitmapInfoHeader->biWidth     = cSize.cx;
                    m_pBitmapInfoHeader->biHeight    = cSize.cy;
                    m_pBitmapInfoHeader->biSizeImage = ulNumBytes;
                    bAllocated                       = TRUE;
                }
            }
            if (m_pucBuffer)
            {
                // Do we need to fill in the color?
                if (bAllocated ||
                    m_ulLastBackgroundColor != ulColor)
                {
                    // Fill in the buffer
                    UINT32  ulNumPix = (UINT32) cSize.cx * cSize.cy;
                    UINT32* pPix     = (UINT32*) m_pucBuffer;
                    while (ulNumPix--)
                    {
                        *pPix++ = ulColor;
                    }
                    // Save this color
                    m_ulLastBackgroundColor = ulColor;
                    // Set the bitmap info header compression
                    m_pBitmapInfoHeader->biCompression = (ulColor & 0xFF000000 ? HX_ARGB : HX_RGB);
                }
                // Clear the return value
                retVal = HXR_OK;
            }
        }
    }

    return retVal;
}

