/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: embeddedapp.h,v 1.3.2.6 2004/11/23 00:24:25 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _EMBEDDED_APP_H_
#define _EMBEDDED_APP_H_

#ifdef G_OS_UNIX
#include <X11/Xlib.h>
#endif

#include "commonapp.h"
#include "playeripc.h"
#include "mainapp.h"

#ifdef __cplusplus
extern "C" {
#endif
    
typedef struct {
    /* See http://service.real.com/help/library/guides/realone/ScriptingGuide/HTML/realscript.htm */ 
    /* We ignore name, nojava, classid, id, param  */

    /* When set to true, AUTOGOTOURL passes all URLs
       embedded in your presentation to the browser.
       When set to false, RealOne Player sends the URLs
       to a Java applet or other application through the
       OnGotoURL callback. If you do not include this parameter
       in your tag definition, and your presentation contains
       embedded URLs, the URLs are not passed to the browser. */
    gboolean    autogotourl;     

    /* Specifies whether to automatically play a presentation */
    gboolean    autostart;

    /* Sets the background color for the image window */
    gchar*      backgroundcolor;

    /* Specifies whether the presentation should be centered
       in the image window and displayed in its original, encoded size. */
    gboolean    center;

    /* Specifies whether multiple controls should be linked
       together to manage playback of a single embedded presentation. */
    gchar*      console;
    
    /* Embeds the specified RealPlayer control on your Web page. */
    HXControlFlags controls;

    /* Specifies whether console events should be enabled. */
    /* If enabled, it will propagate events to all embedded windows, instead of
       just the window in which the event originated. */
    gboolean consoleevents;
    
    /* The controls string we were passed, for use with the GetControls callback */
    gchar* controls_string;

    /* It seems the name attribute can also be used to indicate
       controls layout. This is deprecated behavior. */
    HXNameFlags name_flags;

    /* The name attribute is passed to the mozilla plugin during a callback
       call */
    gchar*      name;
    
    /* Sets the height of the image window or a specified embedded
       control. */
    guint       height;
    
    /* Specifies whether playback of the clip should continue,
       or loop, indefinitely. */
    gboolean    loop;

    /* Specifies whether the height-to-width (aspect) ratio of
       the clip should stay constant when the clip scales to fit
       the image window. */
    gboolean    maintainaspect;

    /* Specifies the number of the times the presentation should
       loop during playback. */
    guint       numloop;

    /* Controls the display of the helix logo */
    gboolean    nologo;
    
    /* Enables or disables PREFETCH playback mode, which causes
       RealPlayer to get the stream description information from
       a presentation before playback begins. */
    gboolean    prefetch;

    /* Defines the ImageWindow control in which a specific clip
       from a SMIL presentation plays. */
    GdkPixmap*  region;

    /* Specifies the callback events to handle in a comma-separated
       list. */
    HXCallbackFlags scriptcallbacks;

    /* Specifies whether all unplayed clips in a presentation,
       should be played back in a random order */
    gboolean    shuffle;

    /* Specifies the URL of the .rpm file or presentation to be
       played. */
    gchar*      src;

    /* Identifies the MIME type of the presentation specifed
       in the SRC parameter. */
    gchar*      type;

    /* Sets the width of the image window or a specified embedded
       control. */
    guint       width;

} HXEmbeddedWindowAttributes;    
    
gboolean hxembedded_init   (HXCommandLineOptions* cmd);
void     hxembedded_destroy(void);

gint     hxembedded_window_attach    (HXEmbeddedWindowAttributes* attr);
void     hxembedded_window_play      (HXEmbeddedWindow* window);
void     hxembedded_window_pause     (HXEmbeddedWindow* window);
void     hxembedded_window_stop      (HXEmbeddedWindow* window);
void     hxembedded_window_play_pause(HXEmbeddedWindow* window);

void     hxembedded_window_previous (HXEmbeddedWindow* window);
void     hxembedded_window_next     (HXEmbeddedWindow* window);

/* The pre and post seek methods here are important for JavaScript callback
   purposes */
void     hxembedded_window_start_seeking(HXEmbeddedWindow* window);
void     hxembedded_window_stop_seeking (HXEmbeddedWindow* window, guint pos);

void     hxembedded_window_mute         (HXEmbeddedWindow* window,
                                         gboolean          mute);
HXContentStateType hxembedded_window_get_content_state(HXEmbeddedWindow* hxwindow);

gboolean  hxembedded_window_set_window (HXEmbeddedWindow* window,
                                        XID               xid,
                                        guint             socket);
gboolean  hxembedded_window_unset_window (HXEmbeddedWindow* window);

void      hxembedded_window_set_src_url(HXEmbeddedWindow* window,
                                        const gchar*      url);
void      hxembedded_window_new_stream (HXEmbeddedWindow* window,
                                        guint             stream_id,
                                        const gchar*      url,
                                        const gchar*      mime_type,
                                        guint             stream_length);
void      hxembedded_window_stream_data(HXEmbeddedWindow* window,
                                        guint             stream_id,
                                        const gpointer    data,
                                        guint             len);
void      hxembedded_window_stream_done(HXEmbeddedWindow* window,
                                        guint             stream_id);

void      hxembedded_window_set_browser_info(HXEmbeddedWindow* window,
                                             const gchar*      user_agent,
                                             gboolean          has_callbacks,
                                             gboolean          has_xembed);
    
HXEmbeddedWindow*  hxembedded_window_get_from_id(guint             window_id);
guint              hxembedded_window_get_id     (HXEmbeddedWindow* window);

G_CONST_RETURN gchar* hxembedded_window_get_name(HXEmbeddedWindow* window);
    

void hxembedded_window_add_ipc_callbacks        (HXEmbeddedWindow* window,
                                                 HXCallbackFlags   flags);
void hxembedded_window_remove_ipc_callbacks     (HXEmbeddedWindow* window,
                                                 HXCallbackFlags   flags);

/* Property set/get functions */
gboolean hxembedded_window_set_string_property(HXEmbeddedWindow* window,
                                               const gchar* property,
                                               const gchar* console);
gboolean hxembedded_window_get_string_property(HXEmbeddedWindow*
                                               window,
                                               const gchar* property,
                                               gchar** val,
                                               guint len);

gboolean hxembedded_window_set_uint_property  (HXEmbeddedWindow* window,
                                               gchar* property,
                                               guint  val);
gboolean hxembedded_window_get_uint_property  (HXEmbeddedWindow*
                                               window,
                                               gchar* property,
                                               guint* val);

gboolean hxembedded_window_get_entry_string_property(HXEmbeddedWindow* window,
                                                     gchar* property,
                                                     guint index,
                                                     gchar** val,
                                                     guint len);
/* No set function for entry string properties */

#ifdef __cplusplus
}
#endif

#endif
