/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatusinfopanel.cpp,v 1.6.10.4 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <gtk/gtk.h>
#include <string.h>

#include "hxstatusinfopanel.h"
#include "commonapp.h"

#include "hxplayer.h"
#include "hxstatisticsobserver.h"

#include "hxplayer-i18n.h"

static const gchar* const g_clip_info_names[] =
{
    "title",
    "author",
    "copyright",
};


static void hxstatus_display_info_panel_class_init (HXStatusDisplayInfoPanelClass* klass);
static void hxstatus_display_info_panel_init       (HXStatusDisplayInfoPanel*      status,
                                                    HXStatusDisplayInfoPanelClass* klass);
static void hxstatus_display_info_panel_set_player (HXStatusDisplay* status,
                                                    HXPlayer* player);
static void hxstatus_display_info_panel_update     (HXStatusDisplayInfoPanel* status);

static HXStatusDisplayClass* g_parent_class = NULL;

GType
hxstatus_display_info_panel_get_type (void)
{
    static GType hxstatus_display_info_panel_type = 0;

    if (!hxstatus_display_info_panel_type)
    {
	static const GTypeInfo hxstatus_display_info_panel_info =
	    {
		sizeof (HXStatusDisplayInfoPanelClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) hxstatus_display_info_panel_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (HXStatusDisplayInfoPanel),
		0,		/* n_preallocs */
		(GInstanceInitFunc) hxstatus_display_info_panel_init,
		NULL,           /* value_table */
	    };

	hxstatus_display_info_panel_type = g_type_register_static (HX_TYPE_STATUS_DISPLAY, "HXStatusDisplayInfoPanel",
                                                                   &hxstatus_display_info_panel_info, (GTypeFlags)0);
    }

    return hxstatus_display_info_panel_type;
}


static void
hxstatus_display_info_panel_class_init (HXStatusDisplayInfoPanelClass* klass)
{    
    HXStatusDisplayClass* status_class = HX_STATUS_DISPLAY_CLASS(klass);
    
    g_parent_class = (HXStatusDisplayClass*)g_type_class_peek_parent (klass);

    status_class->set_player = hxstatus_display_info_panel_set_player;
}

GtkWidget*
hxstatus_display_info_panel_new(void)
{
    HXStatusDisplayInfoPanel* status = (HXStatusDisplayInfoPanel*)g_object_new(HX_TYPE_STATUS_DISPLAY_INFO_PANEL, NULL);

    status->info_label = gtk_label_new("");

    gtk_misc_set_alignment (GTK_MISC (status->info_label), 0, 0.5);
    
    hxstatus_display_info_panel_update(status);

    gtk_container_add(GTK_CONTAINER(status), status->info_label);
    
    return GTK_WIDGET(status);
}

static void
hxstatus_display_info_panel_init(HXStatusDisplayInfoPanel* status, HXStatusDisplayInfoPanelClass* /* klass */)
{
    status->info_label = NULL;
    status->statistics_observers_list = NULL;
    status->title = NULL;
    status->author = NULL;
    status->copyright = NULL;
}

static void
hxstatus_display_info_panel_update(HXStatusDisplayInfoPanel* status)
{
    gboolean have_clip_info = FALSE;
    GString* str = g_string_new("<span size=\"small\">");

    if(status->title && *status->title)
    {
        have_clip_info = TRUE;
        g_string_append_printf(str, _("Title: %s\n"), status->title);
    }

    if(status->author && *status->author)
    {
        have_clip_info = TRUE;
        g_string_append_printf(str, _("Author: %s\n"), status->author);
    }

    if(status->copyright && *status->copyright)
    {
        have_clip_info = TRUE;
        g_string_append_printf(str, _("Copyright: %s\n"), status->copyright);
    }
    
    if(!have_clip_info)
    {
        g_string_append(str, _("No Clip Info"));
    }

    g_string_append(str, "</span>");

    gtk_label_set_markup(GTK_LABEL(status->info_label), str->str);
    g_string_free(str, TRUE);
}

static void
sdip_statistic_deleted(GObject*, gchar* name, HXStatusDisplayInfoPanel* status_info)
{
    if(g_ascii_strcasecmp(name, "title") == 0)
    {
        if(status_info->title)
        {
            g_free(status_info->title);
            status_info->title = NULL;
        }
    }

    if(g_ascii_strcasecmp(name, "author") == 0)
    {
        if(status_info->author)
        {
            g_free(status_info->author);
            status_info->author = NULL;
        }
    }

    if(g_ascii_strcasecmp(name, "copyright") == 0)
    {
        if(status_info->copyright)
        {
            g_free(status_info->copyright);
            status_info->copyright = NULL;
        }
    }
    else
    {
        g_warning("info_panel: Unknown statistic %s", name);
    }

    hxstatus_display_info_panel_update(status_info);
}

static void
sdip_statistic_added_modified(GObject*, const gchar* key, GValue* value, HXStatusDisplayInfoPanel* status_info)
{
    const gchar* raw_value = g_value_get_string(value);
    gchar* str_value = hxcommon_strdup_trim(raw_value);
    
    if(g_ascii_strcasecmp(key, "title") == 0)
    {
        if(status_info->title)
        {
            g_free(status_info->title);
        }
        status_info->title = str_value;
    }
    else if(g_ascii_strcasecmp(key, "author") == 0)
    {
        if(status_info->author)
        {
            g_free(status_info->author);
        }
        status_info->author = str_value;
    }
    else if(g_ascii_strcasecmp(key, "copyright") == 0)
    {
        if(status_info->copyright)
        {
            g_free(status_info->copyright);
        }
        status_info->copyright = str_value;
    }
    else
    {
        g_warning("info_panel: Unknown statistic %s", key);
        g_free(str_value);
    }
    
    hxstatus_display_info_panel_update(status_info);
}

static void
hxstatus_display_info_panel_set_player(HXStatusDisplay* status, HXPlayer* player)
{ 
    HXStatisticsObserver* observer;
    GList* observer_iter;
    guint i;
    
    HXStatusDisplayInfoPanel* status_info = HX_STATUS_DISPLAY_INFO_PANEL(status);
    g_return_if_fail(status_info != NULL);

    /* Remove the old player observers, if any */
    observer_iter = status_info->statistics_observers_list;
    while(observer_iter)
    {
        observer = (HXStatisticsObserver*)observer_iter->data;
        g_object_unref(G_OBJECT(observer));
        
        observer_iter = g_list_next(observer_iter);
    }

    g_list_free(status_info->statistics_observers_list);
    status_info->statistics_observers_list = NULL;

    if(player)
    {
        /* Hook up to the player */
        for(i = 0; i < sizeof(g_clip_info_names) / sizeof(*g_clip_info_names); i++)
        {

            observer = hx_statistics_observer_new(HX_PLAYER(player),
                                                  g_clip_info_names[i]);
        
            status_info->statistics_observers_list = g_list_append(status_info->statistics_observers_list,
                                                                   observer);
        }    

        /* Add statistics observers */
        observer_iter = status_info->statistics_observers_list;
        while(observer_iter)
        {
            observer = (HXStatisticsObserver*)observer_iter->data;

            g_signal_connect(G_OBJECT(observer),
                             "statistic_added",
                             G_CALLBACK(sdip_statistic_added_modified),
                             status_info);

            g_signal_connect(G_OBJECT(observer),
                             "statistic_modified",
                             G_CALLBACK(sdip_statistic_added_modified),
                             status_info);

            g_signal_connect(G_OBJECT(observer),
                             "statistic_deleted",
                             G_CALLBACK(sdip_statistic_deleted),
                             status_info);
        
            observer_iter = g_list_next(observer_iter);
        }

        /* Get current values */
        GValue title;
        GValue author;
        GValue copyright;

        memset(&title, 0, sizeof(title));
        memset(&author, 0, sizeof(author));
        memset(&copyright, 0, sizeof(copyright));

        if(hx_player_get_statistic(player, "title", &title))
        {
            status_info->title = g_strdup(g_value_get_string(&title));
            g_value_unset(&title);
        }
       
        if(hx_player_get_statistic(player, "author", &author))
        {
            status_info->author = g_strdup(g_value_get_string(&author));
            g_value_unset(&author);
        }

        if(hx_player_get_statistic(player, "copyright", &copyright))
        {
            status_info->copyright = g_strdup(g_value_get_string(&copyright));
            g_value_unset(&copyright);
        }
    
        /* Update display */
        hxstatus_display_info_panel_update(status_info);
    }
    
    HX_STATUS_DISPLAY_CLASS(g_parent_class)->set_player(status, player);
}
