/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientPlayer.h,v 1.14.2.4 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CHXCLIENT_PLAYER_H_
#define _CHXCLIENT_PLAYER_H_

#include "CHXClientContext.h"

#include "enter_hx_headers.h"
#include "hxwintyp.h"
#include "exit_hx_headers.h"

#include "IHXClientPlayer.h"
#include "HXClientCallbacks.h"

_INTERFACE IHXClientEngine;
_INTERFACE IHXPlayer;
_INTERFACE IHXVolume;
_INTERFACE IHXBuffer;
_INTERFACE IHXRequest;
class CHXClientSink;
class CHXEQProcessor;
class CHXClientDataStream;
class CHXFlatArray;

#if defined(HELIX_FEATURE_REGISTRY) && defined(HELIX_FEATURE_STATS)
class CHXStatisticTracker;
#endif

#ifdef HELIX_FEATURE_VIDEO
class CHXClientSiteSupplier;
#endif

class CHXClientPlayer : public IHXClientPlayer
{
private:

	IHXClientEngine* m_pIHXClientEngine;
	IHXPlayer* m_pIHXCorePlayer;
	IHXVolume* m_pIClientVolume;
	CHXClientSink* m_pClipSink;
	CHXClientContext* m_pClientContext;
	CHXEQProcessor* m_pEQProcessor;

#if defined(HELIX_FEATURE_REGISTRY) && defined(HELIX_FEATURE_STATS)
	CHXStatisticTracker* m_pStatisticTracker;
#endif

#ifdef HELIX_FEATURE_VIDEO
	CHXClientSiteSupplier* m_SiteSupplier;
#endif

	UINT32 m_PendingSeekPosition;
	CHXFlatArray* m_pDataStreams;
	IHXRequest* m_pIOpenedRequest;
	bool m_IsActivelySeeking;
	bool m_ShouldPlayOnStopSeeking;
		
	bool IsUnsupportedMimeType( const char* pMimeType ) const;
	bool IsRequestOpenOrPending( IHXRequest* pIRequest ) const;
	bool FindDataStream( CHXClientDataStream* pFindDataStream, UINT32* pRecordNum ) const;
	void RemoveOpenedDataStream( void );

	HX_RESULT LoadRequest( IHXRequest* pIRequest );
	bool GetGroupURLBuffer( UINT16 groupIndex, IHXBuffer** ppIURL ) const;
	bool GetGroupTitleBuffer( UINT16 groupIndex, IHXBuffer** ppIDisplayName, bool& isURL ) const;
	
	virtual CHXClientContext* CreateClientContext( IHXClientPlayer* pIClientPlayer, IUnknown* pIUnkSiteSupplier, IUnknown* pIUnkErrorSink, void* userInfo, const HXClientCallbacks* pClientCallbacks );

protected:

	CHXClientPlayer( IHXClientEngine* pIHXClientEngine, IHXPlayer* pIHXPlayer );
	
	bool Init( HXxWindow* pHXxWindow, void* userInfo, const HXClientCallbacks* pClientCallbacks );
	
public:

    virtual ~CHXClientPlayer( void );
	static IHXClientPlayer* Create( IHXClientEngine* pIHXClientEngine, IHXPlayer* pIHXPlayer, HXxWindow* pHXxWindow, void* userInfo, const HXClientCallbacks* pClientCallbacks );

	HX_RESULT OpenRequest( IHXRequest* pIRequest );
	bool HasContentBegun( void ) const;

	// IHXClientPlayer
	virtual HX_RESULT GetHXClientEngine( IHXClientEngine** ppIClientEngine );
	virtual HX_RESULT GetHXPlayer( IHXPlayer** ppIPlayer );
	virtual HX_RESULT OpenURL( const char* pURL, const char* pMimeType );
	virtual HX_RESULT OpenData( const char* pURL, const char* pMimeType, UINT32 dataLength, bool autoPlay, void** ppOutData );
	virtual HX_RESULT WriteData( void* pData, UINT32 bufferLength, unsigned char* pBuffer );
	virtual void CloseData( void* pData );
	virtual bool GetOpenedURL( char* pURLBuffer, UINT32 bufferLength, UINT32* pUsedBufferLength ) const;
	virtual bool CanViewSource( void );
	virtual void ViewSource( void );
	virtual bool CanViewRights( void );
	virtual void ViewRights( void );
	virtual HX_RESULT Authenticate( bool shouldValidateUser, const char* pUsername, const char* pPassword );
	virtual int GetContentState( void ) const;
	virtual bool SetStatus( const char* pStatus );
	virtual void Play( void );
	virtual void Pause( void );
	virtual void Stop( void );
	virtual bool StartSeeking( void );
	virtual HX_RESULT SetPosition( UINT32 position );
	virtual void StopSeeking( void );
	virtual UINT32 GetPosition( void ) const;
	virtual UINT32 GetLength( void ) const;
	virtual bool IsLive( void ) const;
	virtual const char* GetTitle( void ) const;
	virtual const char* GetContextURL( void ) const;
	virtual bool HasVisualContent( void ) const;
	virtual void GetIdealSize( INT32* pSiteIdealWidth, INT32* pSiteIdealHeight ) const;
	virtual INT32 GetClipBandwidth( void ) const;
	virtual void SetSize( INT32 siteWidth, INT32 siteHeight );
	virtual UINT16 GetSourceCount( void ) const;
	virtual UINT16 GetGroupCount( void ) const;
	virtual UINT16 GetCurrentGroup( void ) const;
	virtual bool GetGroupURL( UINT16 groupIndex, char* pURLBuffer, UINT32 bufferLength, UINT32* pUsedBufferLength ) const;
	virtual bool GetGroupTitle( UINT16 groupIndex, char* pTitleBuffer, UINT32 bufferLength, UINT32* pUsedBufferLength ) const;
	virtual HX_RESULT SetCurrentGroup( UINT16 groupIndex );
	virtual void DrawSite( const HXxRect* pSiteRect );
	virtual void SetVolume( UINT16 volume );
	virtual UINT16 GetVolume( void ) const;
	virtual void Mute( bool shouldMute );
	virtual bool IsMuted( void ) const;
	virtual void EnableEQ( bool enable );
	virtual bool IsEQEnabled( void ) const;
	virtual void SetEQGain( int band, INT32 gain );
	virtual INT32 GetEQGain( int band ) const;
	virtual void SetEQPreGain( INT32 preGain );
	virtual INT32 GetEQPreGain( void ) const;
	virtual void EnableEQAutoPreGain( bool enable );
	virtual bool IsEQAutoPreGainEnabled( void ) const;
	virtual void SetEQReverb( INT32 roomSize, INT32 reverb );
	virtual void GetEQReverb( INT32* pRoomSize, INT32* pReverb ) const;
	virtual bool GetVideoAttribute( int attributeKey, float* pAttributeValue ) const;
	virtual bool SetVideoAttribute( int attributeKey, float attributeValue );
	virtual bool GetStatistic( const char* pStatisticKey, unsigned char* pValueBuffer, UINT32 bufferLength, int* pValueType, UINT32* pUsedBufferLength );
	virtual bool AddStatisticObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo );
	virtual void RemoveStatisticObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo );
};

#endif
