#
# ***** BEGIN LICENSE BLOCK *****
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s): See changelog
# 
# ***** END LICENSE BLOCK *****
# 

%define _translations de es fr hi it ja ko pl pt_BR zh_CN zh_TW 

Summary:        RealPlayer 10 for Linux
Name:           RealPlayer
Version:        10.0.6
Release:        1
Group:          Applications/Multimedia
License:        RPSL, EULA
URL:            http://www.real.com/linux
Source:         install.bz2
Obsoletes:      G2player, RealOne, RealPlayer8, rvplayer
ExcludeArch:    x86_64 ppc64 ppc s390 s390x ia64
BuildRoot:      %{_tmppath}/%{name}-%{version}-buildroot
Patch1:         RealPlayer-helixlibs.patch
Patch2:		RealPlayer-unclaim-audio.patch

%description
RealPlayer is a media player providing solid media playback locally 
and via streaming. It plays RealAudio, RealVideo, MP3, 3GPP Video, 
Flash, SMIL 2.0, JPEG, GIF, PNG, RealPix and RealText and 
more. The RealPlayer 10 for Linux builds on top of the popular 
GPL/RPSL Helix Player 1.0.

%prep
%setup -q -c -n realplay-10.0.6
%patch1 -p1 -b .helixlibs
%patch2 -p1 -b .unclaim-audio

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/{16x16,32x32,48x48,192x192}/{apps,mimetypes}
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applications
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/pixmaps
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mime/packages
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mime-info
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/application-registry
mkdir -p $RPM_BUILD_ROOT/%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6/share

cp -a ./codecs $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
cp -a ./common $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
cp -a ./plugins $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
cp -a ./share/default $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6/share
cp -a ./share/realplay $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6/share
cp ./README $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
cp ./LICENSE $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
cp ./mozilla/nphelix.so $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins
cp ./mozilla/nphelix.xpt $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins

install -p -m644 ./share/realplay.png $RPM_BUILD_ROOT/%{_datadir}/pixmaps
install -p -m644 ./share/realplay.desktop $RPM_BUILD_ROOT/%{_datadir}/applications
install -p -m644 ./share/realplay.xml $RPM_BUILD_ROOT/%{_datadir}/mime/packages/realplay.xml
install -p -m644 ./share/realplay.applications $RPM_BUILD_ROOT/%{_datadir}/application-registry
install -p -m644 ./share/realplay.keys $RPM_BUILD_ROOT/%{_datadir}/mime-info

cp ./realplay.bin $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
cp ./realplay $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6
ln -s %{_libdir}/realplay-10.0.6/realplay $RPM_BUILD_ROOT/%{_bindir}

for LANGUAGE in %{_translations}; do
    mkdir -p $RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES
    mkdir -p $RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6/share/locale/$LANGUAGE
    cp "./share/locale/$LANGUAGE/player.mo" "$RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES/realplay.mo"
    cp "./share/locale/$LANGUAGE/widget.mo" "$RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    cp "./share/locale/$LANGUAGE/README" "$RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6/share/locale/$LANGUAGE"
    cp "./share/locale/$LANGUAGE/LICENSE" "$RPM_BUILD_ROOT/%{_libdir}/realplay-10.0.6/share/locale/$LANGUAGE"
done


%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/realplay
%{_libdir}/realplay-10.0.6/*
%{_libdir}/mozilla/*
%{_datadir}/icons/hicolor/*
%{_datadir}/pixmaps/*
%{_datadir}/applications/*
%{_datadir}/mime/packages/*
%{_datadir}/application-registry/*
%{_datadir}/mime-info/*
%{_datadir}/locale/*/LC_MESSAGES/*

%changelog
* Fri Aug 19 2005 Ryan Gammon <rgammon@real.com> 10.0.6-1
- Updating to 10.0.6

* Fri May 13 2005 Ryan Gammon <rgammon@real.com> 10.0.5-1
- Updating to 10.0.5

* Wed Mar 23 2005 Ryan Gammon <rgammon@real.com> 10.0.4-1
- Updating to 10.0.4

* Mon Jan 24 2005 Ryan Gammon <rgammon@real.com> 10.0.3-1
- Updating to 10.0.3

* Mon Jan 24 2005 Ryan Gammon <rgammon@real.com> 10.0.2-1
- First RPM build for JDS 3
