/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: clip8.h,v 1.1.32.1 2004/07/09 02:00:07 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/*
 * This table is used to clip values during color conversion to prevent
 * overflow.
 *
 * Values are:
 *	CLIPNEG to 0:   0
 *      0 to 243:       n
 *      243 to CLIPPOS: 243
 *
 * 243 accounts for the maximum range allowed after conversion from
 * YUV space.  This prevents overflows during computation and has no
 * visible effect on resulting frame.
 */
static const unsigned char clip8 [CLIPNEG+CLIPRNG+CLIPPOS] =
{
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
     96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
    112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
    128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
    144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
    160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
    176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
    192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
    208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
    224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
    240,241,242,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
    243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243
};
    
