// QByteArray.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Generated File.  Do Not Modify.

namespace Qt {

	using Qt;
	using System;
	using System.Runtime.InteropServices;

	public class QByteArray : QMemArray, IDisposable {

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QByteArray ();
		public QByteArray () : this (QNull.Instance)
		{
			rawObject = qt_new_QByteArray ();
			RegisterObject (this);
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_new_QByteArray1 (int size);
		public QByteArray (int size) : this (QNull.Instance)
		{
			rawObject = qt_new_QByteArray1 (size);
			RegisterObject (this);
		}

		internal QByteArray (IntPtr ptr) : this (QNull.Instance)
		{
			rawObject = ptr;
			RegisterObject(this);
		}

		internal QByteArray (QNull dummy) : base (QNull.Instance) {}

		~QByteArray ()
		{
			Dispose (false);
		}

		internal override void Delete ()
		{
			if (deleted) return;

			// libqtc lacks a qt_del_QByteArray function
			deleted = true;
		}

		
		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern IntPtr qt_QByteArray_assign1
			(IntPtr rawObject, [MarshalAs(UnmanagedType.LPArray)] byte[] b,
			uint length );
		
		public static implicit operator QByteArray (byte[] bArray)
		{
			QByteArray qbArray = new QByteArray (bArray.Length);
			qbArray.rawObject =
				qt_QByteArray_assign1 (qbArray.rawObject, bArray, (uint) bArray.Length);
			GC.KeepAlive (bArray);
			return qbArray;
		}	
		
		// Begin interface methods.

	}
}
