/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "favoriteboardstest.h"
#include "../board.h"

void FavoriteBoardsTest::setUp()
{
    m_xml = "<?xml version=\"1.0\"?>\n"
            "<boardlist xmlns=\"http://kita.sourceforge.jp/ns/boardlist\">\n"
            "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
            "<url>http://pc.2ch.net/linux/</url>\n"
            "<name>Linux</name>\n"
            "</board>\n"
            "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
            "<url>http://pc.2ch.net/unix/</url>\n"
            "<name>Unix</name>\n"
            "</board>\n"
            "</boardlist>\n";

    Kita::FavoriteBoards::readFromXML( m_xml );
}

void FavoriteBoardsTest::testBoards()
{
    QValueList<KURL> boards = Kita::FavoriteBoards::boards();

    CPPUNIT_ASSERT_EQUAL( ( size_t ) 2, boards.count() );
    QString boardURL = boards[ 0 ].url();
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), boardURL );

    QString boardName = Kita::Board::getName( boardURL );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), boardName );

    QString boardURL2 = boards[ 1 ].url();
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/" ), boardURL2 );

    QString boardName2 = Kita::Board::getName( boardURL2 );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), boardName2 );
}

void FavoriteBoardsTest::testToXML()
{
    CPPUNIT_ASSERT_EQUAL( m_xml, Kita::FavoriteBoards::toXML() );
}

void FavoriteBoardsTest::tearDown()
{}
