/***************************************************************************
 *   Copyright (C) 2008 by Kitsune   *
 *   sutoka@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WEBVIEW_H
#define WEBVIEW_H

#include <QWebView>
#include <QMouseEvent>
#include "webpage.h"

/**
	@author Kitsune <sutoka@gmail.com>
*/
class webView : public QWebView
{
        Q_OBJECT
public:
        webView(QWidget* parent);
        ~webView();

public slots:
        int getProgress();
        QString getStatusText();

        void setAddressEditString(QString addressStrn);
        void setAddressEditString(QUrl url);
        QString* getAddressEditString();

protected:
        void mousePressEvent(QMouseEvent *event);
        void contextMenuEvent(QContextMenuEvent *event);

signals:
        void urlChanged(const QUrl&, void*);
        void titleChanged(const QString&, void*);
        void statusBarMessage( const QString&, void*);
        void linkHovered(const QString&, void*);
        void iconChanged(QIcon, void*);
        void loadProgress(int, void*);
        void newViewRequest(bool newWindow, QNetworkRequest request);

private:
        QString m_addressEditString;
        int m_progress;
        QString m_statusText;
        webPage *m_page;
        QUrl m_urlWanted;

private slots:
        void urlCatcher(const QUrl&);
        void titleCatcher(const QString&);
        void statusBarCatcher(const QString&);
        void linkHoverCatcher(const QString&, const QString&, const QString&);
        void iconChangeCatcher();
        void loadProgressCatcher(int progress);
        void newTabRequestCatcher();
        void newWinRequestCatcher();

};

#endif
