//
// C++ Implementation: k9mp4enc
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9mp4enc.h"
#include "k9mp4dlg.h"
#include "k9config.h"
#include <qapplication.h>
#include <klocale.h>
#include <qstringlist.h>
#include <qdir.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <qstringlist.h>
#include <KTemporaryFile>
#include <kstandarddirs.h>
#include "k9tools.h"
#include "k9audiocodecs.h"
#include "k9videocodecs.h"
#include <QByteArray>


#define SERVICE_NAME "k9copy.free.fr.player"

k9MP4Enc::k9MP4Enc(QObject *parent)
        : QObject(parent) {
    m_fourcc=m_height=m_width=m_audioBitrate=m_videoBitrate=m_filename="";
    m_codec=0; //lavc_mp4;
    m_audioCodec=0;
    m_cpt=-1;
    m_parts=1;
    m_mpeg2=false;

    QStringList laudio;
    QStringList llabels;
    QStringList lvideo;

    k9Config config;
    m_lstAudio=config.getCodecAudio();
    m_lstCodecs=config.getCodecLabels();
    m_lstVideo=config.getCodecVideo();
    m_mpegChapters=config.getMpegChapters();

    timer = new QTimer( this );
    connect( timer, SIGNAL(timeout()), this, SLOT(timerDone()) );
    m_progress=new k9MP4Dlg(QApplication::activeWindow());
    m_progress->setModal(true);

}

QString k9MP4Enc::round16(QString _wh) {
    if (_wh !="") {
        int value=_wh.toInt()/16;
        return QString::number(value*16);

    } else
        return _wh;


}

QString k9MP4Enc::getChapterList(k9DVDTitle *_title) {
    QString res="";
    QList <k9DVDChapter*> chapters=_title->getChapters();
    foreach (k9DVDChapter *chapter ,chapters) {
        if (chapter->getSelected()) {
            res+=res=="" ? QString::number( chapter->getnum()) : ","+QString::number( chapter->getnum());
        }
    }
    QList <k9DVDTitle*> titles=_title->getTitles();

    foreach (k9DVDTitle *title,titles) {
        chapters=title->getChapters();
        foreach (k9DVDChapter *chapter,chapters) {
            if (chapter->getSelected()) {
                res+=res=="" ? QString::number( chapter->getnum()) : ","+QString::number( chapter->getnum());
            }
        }
    }
    return res;

}


int k9MP4Enc::getselectedSubp(k9DVDTitle *_title) {
    for (int i=0;i< _title->getsubPictureCount();i++) {
        if (_title->getsubtitle( i)->getselected()) {
            return _title->getsubtitle(i)->getID().first()-1;
        }
    }
    //nos subtitle selected
    return -1;
}



void k9MP4Enc::execute(k9DVDTitle *_title) {
    m_error=false;
    if (m_mpeg2) {
        m_parts=1;
        m_2pass=false;
    }

    if ( ! k9Tools::checkProgram("mencoder") && ! m_mpeg2) {
        KMessageBox::error (NULL,i18n("Unable to run %1","mencoder") , i18n("Encoding error"));
        m_error = TRUE;
        return;
    }

    time = new QTime(0,0);
    m_percent=m_totalBytes=m_offset=0;
    m_remain="--:--:--";

    m_totalSize=_title->getChaptersSize(true);

    QString injectName;
    KTemporaryFile injectFile;
    injectFile.setPrefix(KStandardDirs::locateLocal("tmp", "k9copy/k9v"));
    injectFile.open();
    injectName=injectFile.fileName();

    injectFile.setAutoRemove(true);
    injectFile.close();


    int maxPass=0;
    int pass=0;
    
    //build the cell list for mpeg2 extraction
    QMultiMap <QString,int> chapterCells;
    QMultiMap<QString, int>::iterator ichapterCells;
    QStringList chapters;
    if (m_mpeg2 && m_mpegChapters) {
      m_parts=0;
      chapters=getChapterList(_title).split(",");
      foreach (QString chapter,chapters) {
	 int iCell=0;
	 k9DVDChapter *chap=_title->getChapter(chapter.toInt()-1); 
//	 foreach(k9ChapterCell *cell ,chap->cells) {
	    iCell++;
	    chapterCells.insert(chapter,iCell);
	    m_parts++;
//	 }
      }
      ichapterCells = chapterCells.begin();
    }


    for (int m_part =1 ; (m_part <=m_parts) && !m_error ;m_part++) {
        if (m_2pass) {
            maxPass=2;
            pass=1;
        }
        KTemporaryFile passLogFile;
        QString passLogFileName;
        passLogFile.setPrefix(KStandardDirs::locateLocal("tmp", "k9copy/k9v"));
        passLogFile.setAutoRemove(true);
        passLogFile.open();
        passLogFileName=passLogFile.fileName();
        passLogFile.close();

        do {
            uint32_t nbSectors= m_totalSize / m_parts   ;

            uint32_t startSector= nbSectors*(m_part-1);
            uint32_t endSector= startSector+nbSectors;

            //calculer le bitrate en faisant la somme des cells compris entre startSector et endSector
            //FIXME Mettre en place la sélection par chapitres
            m_stderr="";
            m_title=_title;
            if (m_height=="" || m_height=="0")
                m_height="-2";
            if (m_width=="")
                m_width="640";
            if (m_audioBitrate=="")
                m_audioBitrate="128";
            if (m_size=="")
                m_size="700";
            if (m_filename=="")
                m_filename=KFileDialog::getSaveFileName (QDir::homePath(),"*.avi", 0,i18n("Save file to disk"));
            if (m_filename =="")
                return;

            QDir d=QDir::root();
            if (d.exists(m_filename))
                d.remove(m_filename);

            m_progress->setbitrate(QString::number(getBitRate(_title)));
	    if (!m_mpeg2)
            	m_progress->setsize(m_size +i18n("MB") +" X " +QString::number(m_parts));
	    else
		m_progress->setsize(m_size +i18n("MB") +" X ");
            m_process=new k9Process(this,0 );
            QStringList cmd;
            cmd << "k9play" << "--play" << "--endsector" << QString::number(endSector) ;
            cmd << "--inject" << injectName; //"/tmp/kde-jmp/inject";
            cmd << "--input" << "'"+m_device+"'";
            cmd << "--dvdtitle" << QString::number(_title->getnumTitle());
	    if (m_mpegChapters && m_mpeg2) {
		cmd << "--chapter" << ichapterCells.key();//chapters.at(m_part-1);
	//	cmd << "--cell" << QString::number(ichapterCells.value());

	    }
	    else
                cmd << "--chapterlist" << getChapterList( _title);
            if (m_part==1 || m_mpeg2)
                cmd << "--initstatus";
            else
                cmd << "--continue";
            if (pass==1)
                cmd << "--firstpass";

            QStringList streams;
            for (int i=0;i<_title->getaudioStreamCount();i++) {
                if (_title->getaudioStream(i)->getselected()) {
                    streams <<QString::number(_title->getaudioStream(i)->getID());
                }
            }

            if (streams.count() >0)
                cmd << "--audiofilter" <<streams.join(",");

            if (getselectedSubp( _title) !=-1) {
                cmd << "--subpicturefilter" ;
                QString s="";
                for (int i=1; i<=_title->getsubPictureCount();i++)
                    s+= (i>1?",":"") + QString::number(i);
                cmd << s;
            }

            if (m_usecache)
                cmd << "--usecache";
            if (m_mpeg2) {
		m_offset+=m_totalBytes;
		m_progress->setbitrate("--");
		double size;

		if (_title->getforceFactor()) {
		   size = _title->getChaptersSize_mb(true)/_title->getfactor();
		   cmd << "--vampsfactor" << QString::number(_title->getfactor()) << "--ffactor";
		} else
		   size = _title->getChaptersSize_mb(true);
	        m_progress->setsize(QString::number(size) +i18n("MB"));
                
                QString path=m_filename;

                if (m_parts>1) {
                    QString ext=m_filename.section(".",-1);
                    if (ext!="")
                        ext="."+ext;
                    path=m_filename.left(m_filename.length()-ext.length());
                    //path=QString("%1-chapter%2-cell%3%4").arg(path).arg(ichapterCells.key()).arg(ichapterCells.value()).arg(ext);
                    path=QString("%1-chapter%2%3").arg(path).arg(ichapterCells.key()).arg(ext);
		    ++ichapterCells;
		}

		cmd << "> "+path;
	    }
            else {

                cmd << "| mencoder" << "/dev/stdin";
                cmd << "-passlogfile" << passLogFileName;

                bool audio=false;
                QString sPass="";
                QString sCodec="";

                k9AudioCodecs *audioCodecs=new k9AudioCodecs(0);
                k9VideoCodecs *videoCodecs=new k9VideoCodecs(0);

                QString sVOption;
                m_pass=pass;
                switch (pass) {
                case 1:
                    sVOption=replaceParams(videoCodecs->getOptions1(m_codec));
                    break;
                case 2:
                    sVOption=replaceParams(videoCodecs->getOptions2(m_codec));
                    break;
                default:
                    sVOption=replaceParams(videoCodecs->getOptions0(m_codec));
                    break;
                }
                sCodec=videoCodecs->getCodecName(m_codec);
                sVOption=sVOption.trimmed();
                int pos;

                cmd << sVOption;

                QString sAOption=replaceParams(audioCodecs->getOptions(m_audioCodec)).trimmed();



                if (pass >0)
                    m_progress->setTitleLabel(i18n("Encoding %1",sCodec)+" - "+i18n("pass %1",pass));
                else
                    m_progress->setTitleLabel(i18n("Encoding %1",sCodec));

                if (m_fourcc !="")
                    cmd << "-ffourcc" << m_fourcc;
                else if (videoCodecs->getFourcc(m_codec)!="")
                    cmd << "-ffourcc" << videoCodecs->getFourcc(m_codec);

                delete audioCodecs;
                delete videoCodecs;

                //looking for first audio selected
                for (int i=0;i<_title->getaudioStreamCount();i++) {
                    if (_title->getaudioStream(i)->getselected()) {
                        //cmd << "-oac" << sAOption;
                        pos=sAOption.indexOf("-af");
                        if (pos==-1)
                            cmd << QString("-af volume=%1").arg(m_audioGain);
                        else
                            sAOption=sAOption.insert(pos+4,QString("volume=%1,").arg(m_audioGain));
                        cmd << sAOption;

                        audio=true;
                        break;
                    }
                }

                if (getselectedSubp( _title) !=-1) {
                    cmd << "-sid" << QString::number(getselectedSubp( _title));
                    cmd << "-ffactor" << "1" << "-spualign" << "2" << "-sub-bg-alpha" << "1";
                }
                if (!audio)
                    cmd << "-nosound";

                QString path=m_filename;

                if (m_parts>1) {
                    QString ext=m_filename.section(".",-1);
                    if (ext!="")
                        ext="."+ext;
                    path=m_filename.left(m_filename.length()-ext.length());
                    path=path+QString::number(m_part)+ext;
                }
                if (pass==1)
                    cmd << "-o" << "/dev/null";
                else
                    cmd <<"-o" << "'"+path+"'";
                if (path.toUpper().endsWith("MPEG") || path.toUpper().endsWith("MPG"))
                    cmd << "-of" << "mpeg";
                else if (path.toUpper().endsWith("AVI"))
                    cmd << "-of" << "avi";
                else {
                    cmd << "-of" << "lavf";
                    cmd << "-lavfopts" << "i_certify_that_my_video_stream_does_not_use_b_frames";
                }
                //cmd << "-of" << "avi";
            }
            time->start();
            m_timer3.start();
            connect(m_process, SIGNAL(receivedStdout(KProcess *, char *, int)),this, SLOT(getStdout(KProcess *, char *, int) ));
            connect(m_process, SIGNAL(receivedStderr(KProcess *, char *, int)),this, SLOT(getStderr(KProcess *, char *, int) ));
            //connect(m_process, SIGNAL(processExited(KProcess*)),this,SLOT(exited(KProcess*)));
            connect(m_progress,SIGNAL(sigCancel()),this,SLOT(slotCancel()));
            m_canceled=false;
            m_progress->show();
            m_process->setShellCommand(cmd.join(" "));
            qDebug () << cmd.join(" ");

            //DBUS Connection with player
            connect(QDBusConnection::sessionBus().interface(),SIGNAL(serviceOwnerChanged(QString,QString,QString)),this,SLOT(ready(QString,QString,QString)));


            m_process->start();
            timer->start(500);
            m_process->sync();
            //if application is exiting, kill the encoding process
            if (m_process->isRunning()) {
                m_process->kill();
                return;
            }
            if (m_canceled) {
                //KMessageBox::information (NULL,i18n("MPEG-4 Encoding cancelled"), i18n("MPEG-4 Encoding"));
                m_error=true;
            } else if (!m_process->normalExit()) {
                KMessageBox::error (NULL,"<b>"+i18n("Error while running mencoder :") +"</b><br>"+m_stderr, i18n("Encoding error"));
                m_error=true;
            }
            if (maxPass >0)
                pass++;
        } while (pass<=maxPass && !m_error && m_2pass);

    }
}


void k9MP4Enc::ready(const QString &name, const QString &oldValue, const QString &newValue) {
    Q_UNUSED(oldValue);

    if (name != SERVICE_NAME || newValue.isEmpty())
        return;

    // find our remote
    m_iface = new QDBusInterface(SERVICE_NAME, "/", "k9copy.free.fr.player",
                                 QDBusConnection::sessionBus(), this);
    if (!m_iface->isValid()) {
        qDebug() << qPrintable(QDBusConnection::sessionBus().lastError().message());
    }
    //  m_ready=true;
}



void k9MP4Enc::slotCancel() {
    m_canceled=true;
    if (m_iface) {
        m_iface->call("abort");
        qApp->processEvents();
    } else
        m_process->kill();
}


QString k9MP4Enc::replaceParams(QString _value) {
    QString str=_value;
    str.replace("$PASS",QString::number(m_pass));
    str.replace("$WIDTH",m_width);
    str.replace("$HEIGHT",m_height);
    str.replace("$VIDBR",QString::number(getBitRate(m_title)));
    str.replace("$AUDBR",m_audioBitrate);
    return str;
}


int k9MP4Enc::getBitRate(k9DVDTitle *_title) {
    // bitrate video = (MB *8388.608) /SEC    - bitrate audio

    if (m_videoBitrate!="") {
        return  m_videoBitrate.toInt();
    } else {
        int size=m_size.toInt();
        float titleSize=_title->getChaptersSize_mb( true);
        if ( titleSize< (float)size)
            size=(int)(titleSize/m_parts) ;
        m_progress->setsize(QString::number(size) +i18n("MB") +" x " +QString::number(m_parts));
        QTime t1(0,0);
        int sec=t1.secsTo(_title->getSelectedLength());
        //int bitrate=(int)( ((size*m_parts) * 8388.608)/sec  - m_audioBitrate.toInt());
        int bitrate=8*(((size*m_parts*1024)-(m_audioBitrate.toInt()*sec/8))/sec);

        return bitrate;
    }
}


void k9MP4Enc::getStdout(KProcess *, char *buffer, int buflen) {
    QString tmp( QByteArray(buffer,buflen));
    m_cpt++;
    if (m_cpt==100)
        m_cpt=0;

    if (m_cpt!=0)
        return;

    int pos=tmp.indexOf("Pos:");
    if (pos!=-1) {
        QString tmp2=tmp.mid(pos);
        float t;
        int frame;
        int fps;
        sscanf(tmp2.toUtf8(),"Pos: %f%*s%d",&t,&frame);
        tmp2=tmp2.mid(tmp2.indexOf("(")+1);
        tmp2=tmp2.mid(tmp2.indexOf(")")+1);
        sscanf(tmp2.toUtf8(),"%d",&fps);

        m_progress->setfps(QString::number(fps));
    }


}

void k9MP4Enc::getStderr(KProcess *proc, char *buffer, int buflen) {
    //m_stderr=QString::fromLatin1(buffer,buflen);
    QString cstderr(QByteArray(buffer,buflen+1));

    if (cstderr.indexOf("FATAL:")!=-1) {
        proc->kill();
    }

    int pos=cstderr.indexOf("INFOPOS:");
    if (pos!=-1 ) {
        if (m_timer3.elapsed()>500) {
            m_timer3.restart();
            QString tmp=cstderr.mid(pos);
            uint32_t totalBytes,totalSize;
            sscanf(tmp.toUtf8(),"INFOPOS: %d %d",&totalBytes,&totalSize);
            if (totalSize !=0)
                m_percent=(float)(m_offset+totalBytes) / (float)m_totalSize;
	    m_totalBytes=totalBytes;

            QTime time2(0,0);
            time2=time2.addMSecs(time->elapsed());
            if (m_percent>0) {
                QTime time3(0,0);
                time3=time3.addMSecs((uint32_t)(time->elapsed()*(1/m_percent)));
                m_remain=time3.toString("hh:mm:ss");
            }

            m_percent*=100;
            m_progress->setProgress((int)m_percent);
            m_progress->setremain(time2.toString("hh:mm:ss") +" / " +m_remain);
        }
    } else {
        pos=cstderr.indexOf("INFOIMAGE:");
        if (pos!=-1) {
            m_progress->setImage(cstderr.mid(pos+10));
        } else
            qDebug("[%s]",buffer);
    }
    m_stderr=cstderr;
}

void k9MP4Enc::timerDone() {
    QTime time2(0,0);
    time2=time2.addMSecs(time->elapsed());
    m_progress->setremain(time2.toString("hh:mm:ss") +" / " +m_remain);

}

bool k9MP4Enc::isCanceled() {
    return (m_canceled || m_error);
}


k9MP4Enc::~k9MP4Enc() {
    m_progress->close();
}

