//
// C++ Implementation: k9menueditor
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9menueditor.h"
#include "k9menubutton.h"
#include "k9menuedit.h"
#include "k9canvasselection.h"
#include <qwmatrix.h>
#include <qcursor.h>
#include <kcursor.h>
#include <QMouseEvent>

k9MenuEditor::k9MenuEditor(
    Q3Canvas& c, QWidget* parent) :
        Q3CanvasView(&c,parent) {
    this->setMaximumSize(QSize(724,580));
    moving=NULL;
    m_canvasSelection=new k9CanvasSelection(this);
    viewport()->setMouseTracking(true);
}


void k9MenuEditor::contentsMouseReleaseEvent(QMouseEvent* e) {
   m_canvasSelection->release();
   emit itemSelected();
}


void k9MenuEditor::contentsMousePressEvent(QMouseEvent* e) {
    QPoint p = inverseWorldMatrix().map(e->pos());
    moving_start = p;
    Q3CanvasItemList l=canvas()->collisions(p);
    moving=0;
    foreach (Q3CanvasItem *item,l) {
       if (item->rtti()==Q3CanvasItem::Rtti_Rectangle)
        moving = item;
       if (item->rtti()>2000) {
            moving=item;
            return;
        }
    }
    if (moving)
        return;
    foreach (moving,l) {
//        if ((*it)->rtti()==Q3CanvasItem::Rtti_Rectangle)
//            continue;
        if (moving->rtti()==1000) {
            if (e->modifiers() & Qt::ControlModifier)
                addSelection(moving);
            else {
                if (!isSelected(moving)) {
                    clearSelection();
                    addSelection(moving);
                }
            }
            m_canvasSelection->setPosition(p);
            m_canvasSelection->drawSelection();
        } else if (moving->rtti() <1001 )
            clearSelection();
        emit itemSelected();
        return;
    }
    m_canvasSelection->setPosition(p);
    clearSelection();
    emit itemSelected();
}

void k9MenuEditor::clear() {
    Q3CanvasItemList list = canvas()->allItems();
//    qDeleteAll(list);
}

void k9MenuEditor::clearSelection() {
    foreach (k9MenuButton *b,m_selection) {
        b->select(false);
    }
    m_selection.clear();
}

bool k9MenuEditor::isSelected(Q3CanvasItem *_item) {
    k9CanvasSprite *s=(k9CanvasSprite *)_item;
    k9MenuButton *button=s->getButton();
    if (m_selection.indexOf(button) !=-1)
        return true;
    else
        return false;
}

void k9MenuEditor::addSelection(Q3CanvasItem *_item) {
    k9CanvasSprite *s=(k9CanvasSprite *)_item;
    k9MenuButton *button=s->getButton();
    if (m_selection.indexOf(button) !=-1) {
        button->select(false);
        m_selection.removeAll(button);
    } else {
        button->select(true);
        m_selection.append(button);
    }
}

void k9MenuEditor::updateCursor(QMouseEvent *e) {
   QPoint p = inverseWorldMatrix().map(e->pos());
   Q3CanvasItemList l=canvas()->collisions(p);
    foreach (Q3CanvasItem *item,l) {
       switch (item->rtti()) {
            case Q3CanvasItem::Rtti_Rectangle :
                setCursor(QCursor(Qt::SizeAllCursor));
                return;
            case 2002 :
            case 2008:
                setCursor(QCursor(Qt::SizeFDiagCursor));
                return;
            case 2003:
            case 2007:
                setCursor(QCursor(Qt::SizeVerCursor));
                return;
            case 2004:
            case 2006:
                setCursor(QCursor(Qt::SizeBDiagCursor));
                return;
            case 2005:
            case 2009:
                setCursor(QCursor(Qt::SizeHorCursor));
                return;
            default:
                setCursor(QCursor(Qt::ArrowCursor));
        }
    }
    setCursor(QCursor(Qt::ArrowCursor));
}

void k9MenuEditor::contentsMouseMoveEvent(QMouseEvent* e) {
    updateCursor(e);
    if ( moving && (e->buttons() & Qt::LeftButton ==Qt::LeftButton) ) {
        if (moving->rtti() !=Q3CanvasItem::Rtti_Text || moving==m_menu->getText()) {
            QPoint p = inverseWorldMatrix().map(e->pos());
            int offsetX=p.x() - moving_start.x();
            int offsetY=p.y() - moving_start.y();
            moving_start = p;
            if (moving->rtti()==1000 || moving->rtti() == Q3CanvasItem::Rtti_Rectangle) {
                foreach (k9MenuButton *b,m_selection) {
                    k9CanvasSprite*spr=b->getSprite();
                    spr->moveBy(offsetX,offsetY);
                    spr->update();
                }

            } else
                moving->moveBy(offsetX,offsetY);

            if (moving->rtti() >2001 && moving->rtti() <2010) {
                k9CanvasSelectionRedim *ssr=(k9CanvasSelectionRedim*)moving;
                ssr->updateSelection();
            } else if (moving->rtti() != Q3CanvasItem::Rtti_Text ){
                //if selection not resized, move the selection
                m_canvasSelection->moveBy(offsetX,offsetY);
                m_canvasSelection->update();
            }

            if (moving==m_menu->getText())
                emit m_menu->updateTextPos(QPoint(moving->x(),moving->y()));
            canvas()->update();
        }
    } else if ((e->buttons() & Qt::LeftButton) ==Qt::LeftButton ) {
        m_canvasSelection->hide();
        canvas()->update();
        QPoint p = inverseWorldMatrix().map(e->pos());
        int offsetX=p.x() - moving_start.x();
        int offsetY=p.y() - moving_start.y();
        m_canvasSelection->setSize(offsetX,offsetY);
        m_canvasSelection->show();
        canvas()->update();
        clearSelection();
        Q3CanvasItemList l=canvas()->collisions(m_canvasSelection->getRect());
        foreach (Q3CanvasItem *item,l) {
            if (item->rtti()==1000) {
                addSelection(item);
            }
        }
    }
}

void k9MenuEditor::resizeEvent ( QResizeEvent * e ) {
    QMatrix m;
    double scalex=(e->size().width()-4.0)/720.0;
    double scaley=(e->size().height()-4.0)/576.0;
    m.scale(qMin(scalex,scaley),qMin(scalex,scaley));
    this->setWorldMatrix(m);

}

k9MenuButton * k9MenuEditor::getSelected()  {
/*    if (moving) {
        if (moving->rtti()==1000) {
            k9CanvasSprite *s=(k9CanvasSprite *)moving;
            return s->getButton();
        }
    }
*/
    if (m_selection.count() >0)
        return m_selection.first();
    return NULL;
}

Q3CanvasItem* k9MenuEditor::getMoving() const {
    return moving;
}


void k9MenuEditor::setMoving(Q3CanvasItem* _value) {
    moving = _value;
}



QList < k9MenuButton *> *k9MenuEditor::getSelection()  {
    return &m_selection;
}

void k9MenuEditor::hideSelection() {
    m_canvasSelection->hide();
}

