//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "k9common.h"
#include "k9prefmpeg4.h"
#include "k9config.h"
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qstringlist.h>
#include <klocale.h>
#include <qradiobutton.h>

k9prefMPEG4::k9prefMPEG4(QWidget* parent)
: QWidget(parent)
{
    Ui_prefMPEG4.setupUi(this);
    load();
}

void k9prefMPEG4::load() {
    //KSimpleConfig settings("K9Copy");
    k9Config config;
    Ui_prefMPEG4.sbMp4Size->setValue(config.getPrefMp4Size());
    Ui_prefMPEG4.sbMp4Size->setSuffix(" "+ i18n("MB"));
    Ui_prefMPEG4.sbMp4NumberCD->setValue(config.getPrefMp4NumberCD());
    Ui_prefMPEG4.sbAudioGain->setValue(config.getPrefMp4AudioGain());
    
    Ui_prefMPEG4.leMp4Width->setText(config.getPrefMp4Width());
    Ui_prefMPEG4.leMp4Height->setText(config.getPrefMp4Height());

    Ui_prefMPEG4.ckMp4AspectRatio->setChecked(config.getPrefMp4AspectRatio());
    Ui_prefMPEG4.leMp4Height->setEnabled(!Ui_prefMPEG4.ckMp4AspectRatio->isChecked());

    Ui_prefMPEG4.ck2passes->setChecked(config.getPrefMp42Passes());

    Ui_prefMPEG4.leMp4AudioBitrate->setText(config.getPrefMp4AudioBitrate());
    Ui_prefMPEG4.leMp4VideoBitrate->setText(config.getPrefMp4VideoBitrate());

    QStringList m_codecLabels=config.getCodecLabels();
    QStringList m_codecLabelsAudio=config.getCodecLabelsAudio();

    Ui_prefMPEG4.cbMp4Codec->clear();
    Ui_prefMPEG4.cbMp4Codec->addItems(m_codecLabels);
    Ui_prefMPEG4.cbMp4Codec->setCurrentIndex(config.getPrefMp4Codec());

    Ui_prefMPEG4.cbMp4AudioCodec->clear();
    Ui_prefMPEG4.cbMp4AudioCodec->addItems(m_codecLabelsAudio);
    Ui_prefMPEG4.cbMp4AudioCodec->setCurrentIndex(config.getPrefMp4AudioCodec());

    Ui_prefMPEG4.ckUseCache->setChecked(config.getPrefUseCellCache());

    if(config.getPrefMp4VideoBitrate() =="") 
	Ui_prefMPEG4.rbSize->setChecked(true);
    else
	Ui_prefMPEG4.rbBitrate->setChecked(true);
   Ui_prefMPEG4.leMp4VideoBitrate->setEnabled(Ui_prefMPEG4.rbBitrate->isChecked());
   Ui_prefMPEG4.sbMp4Size->setEnabled(Ui_prefMPEG4.rbSize->isChecked());

}


k9prefMPEG4::~k9prefMPEG4()
{
}

void k9prefMPEG4::save() {
    k9Config config;
    config.setPrefMp4Codec(Ui_prefMPEG4.cbMp4Codec->currentIndex());
    config.setPrefMp4AudioCodec(Ui_prefMPEG4.cbMp4AudioCodec->currentIndex());
    config.setPrefMp4Size( (int)Ui_prefMPEG4.sbMp4Size->value());
    config.setPrefMp4NumberCD( (int)Ui_prefMPEG4.sbMp4NumberCD->value());
    config.setPrefMp4AudioGain( (int)Ui_prefMPEG4.sbAudioGain->value());
    config.setPrefMp4Width( Ui_prefMPEG4.leMp4Width->text());
    config.setPrefMp4Height(Ui_prefMPEG4.leMp4Height->text());
    config.setPrefMp4AspectRatio( Ui_prefMPEG4.ckMp4AspectRatio->isChecked());
    config.setPrefMp4AudioBitrate( Ui_prefMPEG4.leMp4AudioBitrate->text());
    config.setPrefMp4VideoBitrate( Ui_prefMPEG4.leMp4VideoBitrate->text());
    config.setPrefMp42Passes(Ui_prefMPEG4.ck2passes->isChecked());
    config.setPrefUseCellCache(Ui_prefMPEG4.ckUseCache->isChecked());
    config.save();
}

void k9prefMPEG4::ckMp4AspectRatioClick() {
    Ui_prefMPEG4.leMp4Height->setEnabled(!Ui_prefMPEG4.ckMp4AspectRatio->isChecked());
    if (Ui_prefMPEG4.ckMp4AspectRatio->isChecked()) Ui_prefMPEG4.leMp4Height->setText("");
}

void k9prefMPEG4::rgVideoSizeChanged(){
   if (Ui_prefMPEG4.rbSize->isChecked()) 
	Ui_prefMPEG4.leMp4VideoBitrate->setText("");
   Ui_prefMPEG4.leMp4VideoBitrate->setEnabled(Ui_prefMPEG4.rbBitrate->isChecked());
   Ui_prefMPEG4.sbMp4Size->setEnabled(Ui_prefMPEG4.rbSize->isChecked());

}

/*$SPECIALIZATION$*/

