/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  copyright (C) 2002-2008                                                *
 *  Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                   *
 ***************************************************************************/

#ifndef CMD_SETTXT_H
#define CMD_SETTXT_H

#include <QtGui/QUndoCommand>

#include "floatingtextwidget.h"
#include "umlwidget.h"

namespace Uml
{
    class CmdSetTxt : public QUndoCommand
    {
        public:
            /*Constructor */
            CmdSetTxt(FloatingTextWidget* _ftw, const QString& txt);
            /*Destructor */
            ~CmdSetTxt();
            /*Redo method */
            void redo();
            /*Undo method */
            void undo();

        private:

            FloatingTextWidget*     ftw;
            QString     newstring;
            QString     oldstring;
    };
}

#endif
