/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef PATH_H
#define PATH_H

//KGRUBEditor
#include "datatypes.h"

namespace Core
{
	namespace Devices
	{
		extern QVector<GRUB::Misc::Device> DeviceList;
	}
	namespace Path
	{
		/**
		* Converts a generic path to one using GRUB standard naming.
		* Eg. if /media/linux is recognised by GRUB as (hd0,0)
		*     then the path /media/linux/boot/vmlinuz would be
		*     converted to (hd0,0)/boot/vmlinuz.
		*
		* @param path The path to be converted.
		* @param devices The device list to use for conversion.
		*
		* @return The result of the conversion.
		*/
		QString convertToGRUBPath( const QString path, const QVector<GRUB::Misc::Device> &devices = Core::Devices::DeviceList );
		/**
		* Converts a GRUB path to one using generic naming.
		* Eg. if /media/linux is recognised by GRUB as (hd0,0)
		*     then the path (hd0,0)/boot/vmlinuz would be
		*     converted to /media/linux/boot/vmlinuz.
		*
		* @param path The path to be converted.
		* @param devices The device list to use for conversion.
		* @param root The root of the file path if already known.
		*
		* @return The result of the conversion.
		*/
		QString convertToGenericPath( const QString path, const QVector<GRUB::Misc::Device> &devices = Core::Devices::DeviceList );
	}
}

#endif
