/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef ENTRY_H
#define ENTRY_H

//KDE
#include <kassistantdialog.h>
class KMenu;

//Ui
#include "ui_entry_assistant_intro.h"
#include "ui_entry_assistant_step1.h"
#include "ui_entry_assistant_step2.h"
#include "ui_entry_assistant_step3.h"
#include "ui_entry_assistant_step4.h"
#include "ui_entry_assistant_step5.h"
#include "ui_entry_assistant_step6.h"
#include "ui_entry_assistant_step7.h"
#include "ui_entry_assistant_step8.h"
#include "ui_entry_assistant_step9.h"
#include "ui_entry_assistant_step10.h"
#include "ui_entry_assistant_summary.h"

//KGRUBEditor
#include "core/datatypes.h"

/**
 * @short Entry Assistant.
 *
 * Creates / edits GRUB entries step-to-step.
 */
class EntryAssistant : public KAssistantDialog
{
Q_OBJECT
public:
	/**
	* Sets up the GUI and shows the entry.
	*
	* @param entry The entry to create/edit.
	* @param parent QWidget parent. Self explanatory.
	*/
	EntryAssistant( GRUB::ConfigFile::Entry *entry, QWidget *parent = 0 );
	/**
	* Desctructor.
	*/
	~EntryAssistant();
private:
	/**
	* Connects all signals to their slots.
	*/
	void setupConnections();
	/**
	* Shows the GRUB maps of the entry that is edited.
	*/
	void showMaps();
	/**
	* Shows the password of the entry that is edited.
	*/
	void showPassword();
private slots:
	/**
	* Checks whether klineedit_title is empty
	* and if not, it allows the user to procede.
	*/
	void checkTitle( const QString &text );
	/**
	* Appends 'root=' to the kernel arguments, followed by the
	* device defined as root.
	*/
	void appendRootDeviceArgument();
	/**
	* Appends 'root=UUID=' to the kernel arguments, followed by the
	* UUID of the device defined as root.
	*/
	void appendRootUuidArgument();
	/**
	* Appends 'ro' to the kernel arguments.
	*/
	void appendReadOnlyArgument();
	/**
	* Appends 'quiet' to the kernel arguments.
	*/
	void appendQuietArgument();
	/**
	* Appends 'splash' to the kernel arguments.
	*/
	void appendSplashArgument();

	/**
	* It launches the Password Assistant in order to create
	* a new password.
	*/
	void createPassword();
	/**
	* It launches the Password Assistant in order to edit
	* the current password.
	*/
	void editPassword();
	/**
	* It deletes the current password (the user is prompted first).
	*/
	void deletePassword();
	/**
	* It launches the Map Assistant in order to add a new map.
	*/
	void addMap();
	/**
	* It launches the Map Assistant in order to edit the current map.
	*/
	void editMap();
	/**
	* It deletes the currently selected map (the user is prompted first).
	*/
	void removeMap();

	/**
	* Before accessing the last page, it collects all data
	* that where entered by the user and creates a summary.
	*/
	void nextClicked();
	/**
	* If the Finish button is pressed, update the config file's
	* content.
	*/
	void finishClicked();
private:
	Ui::entry_assistant_intro ui_intro;
	Ui::entry_assistant_step1 ui_step1;
	Ui::entry_assistant_step2 ui_step2;
	Ui::entry_assistant_step3 ui_step3;
	Ui::entry_assistant_step4 ui_step4;
	Ui::entry_assistant_step5 ui_step5;
	Ui::entry_assistant_step6 ui_step6;
	Ui::entry_assistant_step7 ui_step7;
	Ui::entry_assistant_step8 ui_step8;
	Ui::entry_assistant_step9 ui_step9;
	Ui::entry_assistant_step10 ui_step10;
	Ui::entry_assistant_summary ui_summary;

	KMenu *menu_kernelSuggestions;
	QAction *action_rootDevice;
	QAction *action_rootUuid;
	QAction *action_ro;
	QAction *action_quiet;
	QAction *action_splash;

	KPageWidgetItem *titlePage;
	KPageWidgetItem *summaryPage;

	GRUB::ConfigFile::Entry *tmp_entry;
	GRUB::ConfigFile::Entry *m_entry;
};

#endif
