'''OpenGL extension EXT.compiled_vertex_array

Overview (from the spec)
	
	This extension defines an interface which allows static vertex array
	data to be cached or pre-compiled for more efficient rendering.  This
	is useful for implementations which can cache the transformed results
	of array data for reuse by several DrawArrays, ArrayElement, or
	DrawElements commands.  It is also useful for implementations which
	can transfer array data to fast memory for more efficient processing.
	
	For example, rendering an M by N mesh of quadrilaterals can be
	accomplished by setting up vertex arrays containing all of the
	vertexes in the mesh and issuing M DrawElements commands each of
	which operate on 2 * N vertexes.  Each DrawElements command after
	the first will share N vertexes with the preceding DrawElements
	command.  If the vertex array data is locked while the DrawElements
	commands are executed, then OpenGL may be able to transform each
	of these shared vertexes just once.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/compiled_vertex_array.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = constant.Constant( 'GL_ARRAY_ELEMENT_LOCK_FIRST_EXT', 0x81A8 )
GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = constant.Constant( 'GL_ARRAY_ELEMENT_LOCK_COUNT_EXT', 0x81A9 )
glLockArraysEXT = platform.createExtensionFunction( 
	'glLockArraysEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLint, constants.GLsizei,),
	doc = 'glLockArraysEXT( GLint(first), GLsizei(count) ) -> None',
	argNames = ('first', 'count',),
)

glUnlockArraysEXT = platform.createExtensionFunction( 
	'glUnlockArraysEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(),
	doc = 'glUnlockArraysEXT(  ) -> None',
	argNames = (),
)


def glInitCompiledVertexArrayEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_compiled_vertex_array' )
