# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.33
#
# Don't modify this file, modify the SWIG interface instead.

package Amanda::Debug;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package Amanda::Debugc;
bootstrap Amanda::Debug;
package Amanda::Debug;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package Amanda::Debug;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Debug;

*dbopen = *Amanda::Debugc::dbopen;
*dbreopen = *Amanda::Debugc::dbreopen;
*dbrename = *Amanda::Debugc::dbrename;
*dbclose = *Amanda::Debugc::dbclose;
*error = *Amanda::Debugc::error;
*critical = *Amanda::Debugc::critical;
*warning = *Amanda::Debugc::warning;
*message = *Amanda::Debugc::message;
*info = *Amanda::Debugc::info;
*debug = *Amanda::Debugc::debug;
*dbfd = *Amanda::Debugc::dbfd;
*dbfn = *Amanda::Debugc::dbfn;
*debug_dup_stderr_to_debug = *Amanda::Debugc::debug_dup_stderr_to_debug;

# ------- VARIABLE STUBS --------

package Amanda::Debug;

*ERR_INTERACTIVE = *Amanda::Debugc::ERR_INTERACTIVE;
*ERR_SYSLOG = *Amanda::Debugc::ERR_SYSLOG;
*ERR_AMANDALOG = *Amanda::Debugc::ERR_AMANDALOG;
*erroutput_type = *Amanda::Debugc::erroutput_type;
*error_exit_status = *Amanda::Debugc::error_exit_status;

@EXPORT_OK = ();
%EXPORT_TAGS = ();

=head1 NAME

Amanda::Debug - support for debugging Amanda applications

=head1 SYNOPSIS

  use Amanda::Debug qw( :init :logging );

  # (note: dbopen and such are usually handled by 
  #  Amanda::Util::setup_applicaton)
  dbopen("server");

  debug("this is a debug message");

See C<debug.h> for a more in-depth description of the functionality of
this module.

=head1 API STATUS

Stable

=head1 DEBUG LOGGING

Several debug logging messages, each taking a single string, are
available:

=over

=item C<error> - also aborts the program to produce a core dump

=item C<critical> - exits the program with C<$error_exit_status>

=item C<warning>

=item C<message>

=item C<info>

=item C<debug>

=back

ALl of the debug logging functions are available via the export tag
C<:logging>.

=head1 ADVANCED USAGE

Most applications should use L<Amanda::Util>'s C<setup_application>
to initialize the debug libraries.  The initialization functions
available from this module are thus considered "advanced", and the
reader is advised to consult the C header, C<debug.h>, for details.

Briefly, the functions C<dbopen> and C<dbrename> are used to
open a debug file whose pathname includes all of the relevant
information. C<dbclose> and C<dbreopen> are used to close that debug
file before transferring control to another process.

The variable C<$erroutput_type> can take on any combination
of the flags C<$ERROUTPUT_INTERACTIVE>, C<$ERROUTPUT_SYSLOG>
and C<$ERROUTPUT_AMANDALOG>.  C<$ERROUTPUT_INTERACTIVE>
causes messages from C<error> and C<critical> to be sent
to stderr. C<$ERROUTPUT_SYSLOG> sends it to syslog, and
C<$ERROUTPUT_AMANDALOG> sends it to the current trace log (see
L<Amanda::Logfile>).

C<$error_exit_status> is the exit status with which C<critical>
will exit.

All of the initialization functions and variables are available via
the export tag C<:init>.

The current debug file's integer file descriptor (I<not> a Perl
filehandle) is available from C<dbfd()>.  Likewise, C<dbfn()> returns
the filename of the current debug file.

C<debug_dup_stderr_to_debug()> redirects, at the file-descriptor level,
C<STDERR> into the debug file.  This is useful when running external
applications which may produce error output.

=cut

push @EXPORT_OK, qw(dbopen dbreopen dbrename dbclose
    $erroutput_type $error_exit_status);
push @{$EXPORT_TAGS{"init"}}, qw(dbopen dbreopen dbrename dbclose
    $erroutput_type $error_exit_status);

push @EXPORT_OK, qw(erroutput_type_t_to_strings);
push @{$EXPORT_TAGS{"erroutput_type_t"}}, qw(erroutput_type_t_to_strings);

my %_erroutput_type_t_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub erroutput_type_t_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_erroutput_type_t_VALUES) {
	my $v = $_erroutput_type_t_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($ERR_INTERACTIVE);
push @{$EXPORT_TAGS{"erroutput_type_t"}}, qw($ERR_INTERACTIVE);

$_erroutput_type_t_VALUES{"INTERACTIVE"} = $ERR_INTERACTIVE;

push @EXPORT_OK, qw($ERR_SYSLOG);
push @{$EXPORT_TAGS{"erroutput_type_t"}}, qw($ERR_SYSLOG);

$_erroutput_type_t_VALUES{"SYSLOG"} = $ERR_SYSLOG;

push @EXPORT_OK, qw($ERR_AMANDALOG);
push @{$EXPORT_TAGS{"erroutput_type_t"}}, qw($ERR_AMANDALOG);

$_erroutput_type_t_VALUES{"AMANDALOG"} = $ERR_AMANDALOG;

push @EXPORT_OK, qw(error critical warning message info debug);
push @{$EXPORT_TAGS{"logging"}}, qw(error critical warning message info debug);
1;
