# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.33
#
# Don't modify this file, modify the SWIG interface instead.

package Amanda::Device;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
require Amanda::Types;
package Amanda::Devicec;
bootstrap Amanda::Device;
package Amanda::Device;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package Amanda::Device;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Device;

*IS_WRITABLE_ACCESS_MODE = *Amanda::Devicec::IS_WRITABLE_ACCESS_MODE;
*feature_support_flags_is_valid = *Amanda::Devicec::feature_support_flags_is_valid;

############# Class : Amanda::Device::Device ##############

package Amanda::Device::Device;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Amanda::Device );
%OWNER = ();
%ITERATORS = ();
*swig_file_get = *Amanda::Devicec::Device_file_get;
*swig_file_set = *Amanda::Devicec::Device_file_set;
*swig_block_get = *Amanda::Devicec::Device_block_get;
*swig_block_set = *Amanda::Devicec::Device_block_set;
*swig_in_file_get = *Amanda::Devicec::Device_in_file_get;
*swig_in_file_set = *Amanda::Devicec::Device_in_file_set;
*swig_device_name_get = *Amanda::Devicec::Device_device_name_get;
*swig_device_name_set = *Amanda::Devicec::Device_device_name_set;
*swig_access_mode_get = *Amanda::Devicec::Device_access_mode_get;
*swig_access_mode_set = *Amanda::Devicec::Device_access_mode_set;
*swig_is_eof_get = *Amanda::Devicec::Device_is_eof_get;
*swig_is_eof_set = *Amanda::Devicec::Device_is_eof_set;
*swig_volume_label_get = *Amanda::Devicec::Device_volume_label_get;
*swig_volume_label_set = *Amanda::Devicec::Device_volume_label_set;
*swig_volume_time_get = *Amanda::Devicec::Device_volume_time_get;
*swig_volume_time_set = *Amanda::Devicec::Device_volume_time_set;
sub new {
    my $pkg = shift;
    my $self = Amanda::Devicec::new_Device(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Amanda::Devicec::delete_Device($self);
        delete $OWNER{$self};
    }
}

*read_label = *Amanda::Devicec::Device_read_label;
*start = *Amanda::Devicec::Device_start;
*finish = *Amanda::Devicec::Device_finish;
*start_file = *Amanda::Devicec::Device_start_file;
*write_min_size = *Amanda::Devicec::Device_write_min_size;
*write_max_size = *Amanda::Devicec::Device_write_max_size;
*read_max_size = *Amanda::Devicec::Device_read_max_size;
*write_block = *Amanda::Devicec::Device_write_block;
*write_from_fd = *Amanda::Devicec::Device_write_from_fd;
*finish_file = *Amanda::Devicec::Device_finish_file;
*seek_file = *Amanda::Devicec::Device_seek_file;
*seek_block = *Amanda::Devicec::Device_seek_block;
*read_block = *Amanda::Devicec::Device_read_block;
*read_to_fd = *Amanda::Devicec::Device_read_to_fd;
*property_list = *Amanda::Devicec::Device_property_list;
*property_get = *Amanda::Devicec::Device_property_get;
*property_set = *Amanda::Devicec::Device_property_set;
*recycle_file = *Amanda::Devicec::Device_recycle_file;
*set_startup_properties_from_config = *Amanda::Devicec::Device_set_startup_properties_from_config;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Amanda::Device;

*ACCESS_NULL = *Amanda::Devicec::ACCESS_NULL;
*ACCESS_READ = *Amanda::Devicec::ACCESS_READ;
*ACCESS_WRITE = *Amanda::Devicec::ACCESS_WRITE;
*ACCESS_APPEND = *Amanda::Devicec::ACCESS_APPEND;
*READ_LABEL_STATUS_SUCCESS = *Amanda::Devicec::READ_LABEL_STATUS_SUCCESS;
*READ_LABEL_STATUS_DEVICE_MISSING = *Amanda::Devicec::READ_LABEL_STATUS_DEVICE_MISSING;
*READ_LABEL_STATUS_DEVICE_ERROR = *Amanda::Devicec::READ_LABEL_STATUS_DEVICE_ERROR;
*READ_LABEL_STATUS_VOLUME_MISSING = *Amanda::Devicec::READ_LABEL_STATUS_VOLUME_MISSING;
*READ_LABEL_STATUS_VOLUME_UNLABELED = *Amanda::Devicec::READ_LABEL_STATUS_VOLUME_UNLABELED;
*READ_LABEL_STATUS_VOLUME_ERROR = *Amanda::Devicec::READ_LABEL_STATUS_VOLUME_ERROR;
*READ_LABEL_STATUS_FLAGS_MAX = *Amanda::Devicec::READ_LABEL_STATUS_FLAGS_MAX;
*PROPERTY_PHASE_BEFORE_START = *Amanda::Devicec::PROPERTY_PHASE_BEFORE_START;
*PROPERTY_PHASE_BETWEEN_FILE_WRITE = *Amanda::Devicec::PROPERTY_PHASE_BETWEEN_FILE_WRITE;
*PROPERTY_PHASE_INSIDE_FILE_WRITE = *Amanda::Devicec::PROPERTY_PHASE_INSIDE_FILE_WRITE;
*PROPERTY_PHASE_BETWEEN_FILE_READ = *Amanda::Devicec::PROPERTY_PHASE_BETWEEN_FILE_READ;
*PROPERTY_PHASE_INSIDE_FILE_READ = *Amanda::Devicec::PROPERTY_PHASE_INSIDE_FILE_READ;
*PROPERTY_PHASE_MAX = *Amanda::Devicec::PROPERTY_PHASE_MAX;
*PROPERTY_PHASE_MASK = *Amanda::Devicec::PROPERTY_PHASE_MASK;
*PROPERTY_PHASE_SHIFT = *Amanda::Devicec::PROPERTY_PHASE_SHIFT;
*PROPERTY_ACCESS_GET_BEFORE_START = *Amanda::Devicec::PROPERTY_ACCESS_GET_BEFORE_START;
*PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE;
*PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE;
*PROPERTY_ACCESS_GET_BETWEEN_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_GET_BETWEEN_FILE_READ;
*PROPERTY_ACCESS_GET_INSIDE_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_GET_INSIDE_FILE_READ;
*PROPERTY_ACCESS_SET_BEFORE_START = *Amanda::Devicec::PROPERTY_ACCESS_SET_BEFORE_START;
*PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE;
*PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE = *Amanda::Devicec::PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE;
*PROPERTY_ACCESS_SET_BETWEEN_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_SET_BETWEEN_FILE_READ;
*PROPERTY_ACCESS_SET_INSIDE_FILE_READ = *Amanda::Devicec::PROPERTY_ACCESS_SET_INSIDE_FILE_READ;
*PROPERTY_ACCESS_GET_MASK = *Amanda::Devicec::PROPERTY_ACCESS_GET_MASK;
*PROPERTY_ACCESS_SET_MASK = *Amanda::Devicec::PROPERTY_ACCESS_SET_MASK;
*CONCURRENCY_PARADIGM_EXCLUSIVE = *Amanda::Devicec::CONCURRENCY_PARADIGM_EXCLUSIVE;
*CONCURRENCY_PARADIGM_SHARED_READ = *Amanda::Devicec::CONCURRENCY_PARADIGM_SHARED_READ;
*CONCURRENCY_PARADIGM_RANDOM_ACCESS = *Amanda::Devicec::CONCURRENCY_PARADIGM_RANDOM_ACCESS;
*STREAMING_REQUIREMENT_NONE = *Amanda::Devicec::STREAMING_REQUIREMENT_NONE;
*STREAMING_REQUIREMENT_DESIRED = *Amanda::Devicec::STREAMING_REQUIREMENT_DESIRED;
*STREAMING_REQUIREMENT_REQUIRED = *Amanda::Devicec::STREAMING_REQUIREMENT_REQUIRED;
*MEDIA_ACCESS_MODE_READ_ONLY = *Amanda::Devicec::MEDIA_ACCESS_MODE_READ_ONLY;
*MEDIA_ACCESS_MODE_WORM = *Amanda::Devicec::MEDIA_ACCESS_MODE_WORM;
*MEDIA_ACCESS_MODE_READ_WRITE = *Amanda::Devicec::MEDIA_ACCESS_MODE_READ_WRITE;
*MEDIA_ACCESS_MODE_WRITE_ONLY = *Amanda::Devicec::MEDIA_ACCESS_MODE_WRITE_ONLY;
*SIZE_ACCURACY_UNKNOWN = *Amanda::Devicec::SIZE_ACCURACY_UNKNOWN;
*SIZE_ACCURACY_ESTIMATE = *Amanda::Devicec::SIZE_ACCURACY_ESTIMATE;
*SIZE_ACCURACY_REAL = *Amanda::Devicec::SIZE_ACCURACY_REAL;
*FEATURE_STATUS_ENABLED = *Amanda::Devicec::FEATURE_STATUS_ENABLED;
*FEATURE_STATUS_DISABLED = *Amanda::Devicec::FEATURE_STATUS_DISABLED;
*FEATURE_SURETY_BAD = *Amanda::Devicec::FEATURE_SURETY_BAD;
*FEATURE_SURETY_GOOD = *Amanda::Devicec::FEATURE_SURETY_GOOD;
*FEATURE_SOURCE_DEFAULT = *Amanda::Devicec::FEATURE_SOURCE_DEFAULT;
*FEATURE_SOURCE_DETECTED = *Amanda::Devicec::FEATURE_SOURCE_DETECTED;
*FEATURE_SOURCE_USER = *Amanda::Devicec::FEATURE_SOURCE_USER;
*FEATURE_SUPPORT_FLAGS_MAX = *Amanda::Devicec::FEATURE_SUPPORT_FLAGS_MAX;
*FEATURE_SUPPORT_FLAGS_MASK = *Amanda::Devicec::FEATURE_SUPPORT_FLAGS_MASK;
*FEATURE_SUPPORT_FLAGS_STATUS_MASK = *Amanda::Devicec::FEATURE_SUPPORT_FLAGS_STATUS_MASK;
*FEATURE_SUPPORT_FLAGS_SURETY_MASK = *Amanda::Devicec::FEATURE_SUPPORT_FLAGS_SURETY_MASK;
*FEATURE_SUPPORT_FLAGS_SOURCE_MASK = *Amanda::Devicec::FEATURE_SUPPORT_FLAGS_SOURCE_MASK;

@EXPORT_OK = ();
%EXPORT_TAGS = ();

=head1 NAME

Amanda::Device - interact with Amanda data-storage devices

=head1 SYNOPSIS

  use Amanda::Device qw( :constants );

  my $dev = Amanda::Device->new($device_name);
  $dev->set_startup_properties_from_config();
  if ($dev->read_label() == $READ_LABEL_STATUS_SUCCESS) {
      print "Label on $device_name is '$dev->volume_label'\n";
  }
  
See http://wiki.zmanda.com/index.php/Device_API for details on how Devices are used.

=head1 API STATUS

Stable

=head1 Amanda::Device Objects

=head2 Instance Variables

=over

=item C<$file>

=item C<$block>

=item C<$in_file>

=item C<$device_name>

=item C<$access_mode>

=item C<$is_eof>

=item C<$volume_label>

=item C<$volume_time>

=back

=head2 Methods

See the wiki for descriptions of these functions

=over

=item C<read_label()>

=item C<start($mode, $label, $timestamp)>

=item C<finish()>

=item C<start_file($jobinfo)>

where C<$jobinfo> is a C<dumpfile_t> (see L<Amanda::Datatypes>)

=item C<write_min_size()>

=item C<write_max_size()>

=item C<read_max_size()>

=item C<write_block($size, $data, $short_block)>

Note that Perl code is not expected to handle on-device data, so there
is currently no way to provide data to this function from Perl.  This may
change in future revisions.

=item C<write_from_fd($fd)>

where C<$fd> is an integer file descriptor, not a filehandle

=item C<finish_file()>

=item C<seek_file($file)>

=item C<seek_block($block)>

=item C<read_block($size)>

=item C<read_to_fd($fd)>

where C<$fd> is an integer file descriptor, not a filehandle

Note that Perl code is not expected to handle on-device data, so there
is currently no way to access the data this function returns.  This may
change in future revisions.

=item C<property_list()>

returns a list of property names.

=item C<property_get($property_name)>

returns the property as the appropriate Perl type.

=item C<property_set($property_name, $value)>

where $value is of an appropriate type for the given property

=item C<recycle_file($filenum)>

=item C<set_startup_properties_from_config()>

=back

=head1 CONSTANTS

This module defines a large number of constants.  Again, consult the
wiki or C<device.h> for the details on their meaning.  These constants
are available from the package namespace (e.g.,
C<Amanda::Device::ACCESS_WRITE>), of imported with the C<:constant>
import tag.

=cut

push @EXPORT_OK, qw(DeviceAccessMode_to_strings);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw(DeviceAccessMode_to_strings);

my %_DeviceAccessMode_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub DeviceAccessMode_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_DeviceAccessMode_VALUES) {
	my $v = $_DeviceAccessMode_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($ACCESS_NULL);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_NULL);

$_DeviceAccessMode_VALUES{"NULL"} = $ACCESS_NULL;

push @EXPORT_OK, qw($ACCESS_READ);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_READ);

$_DeviceAccessMode_VALUES{"READ"} = $ACCESS_READ;

push @EXPORT_OK, qw($ACCESS_WRITE);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_WRITE);

$_DeviceAccessMode_VALUES{"WRITE"} = $ACCESS_WRITE;

push @EXPORT_OK, qw($ACCESS_APPEND);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw($ACCESS_APPEND);

$_DeviceAccessMode_VALUES{"APPEND"} = $ACCESS_APPEND;

push @EXPORT_OK, qw(IS_WRITABLE_ACCESS_MODE);
push @{$EXPORT_TAGS{"DeviceAccessMode"}}, qw(IS_WRITABLE_ACCESS_MODE);

#copy symbols in DeviceAccessMode to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"DeviceAccessMode"}};

push @EXPORT_OK, qw(ReadLabelStatusFlags_to_strings);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw(ReadLabelStatusFlags_to_strings);

my %_ReadLabelStatusFlags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub ReadLabelStatusFlags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_ReadLabelStatusFlags_VALUES) {
	my $v = $_ReadLabelStatusFlags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($READ_LABEL_STATUS_SUCCESS);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw($READ_LABEL_STATUS_SUCCESS);

$_ReadLabelStatusFlags_VALUES{"SUCCESS"} = $READ_LABEL_STATUS_SUCCESS;

push @EXPORT_OK, qw($READ_LABEL_STATUS_DEVICE_MISSING);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw($READ_LABEL_STATUS_DEVICE_MISSING);

$_ReadLabelStatusFlags_VALUES{"DEVICE_MISSING"} = $READ_LABEL_STATUS_DEVICE_MISSING;

push @EXPORT_OK, qw($READ_LABEL_STATUS_DEVICE_ERROR);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw($READ_LABEL_STATUS_DEVICE_ERROR);

$_ReadLabelStatusFlags_VALUES{"DEVICE_ERROR"} = $READ_LABEL_STATUS_DEVICE_ERROR;

push @EXPORT_OK, qw($READ_LABEL_STATUS_VOLUME_MISSING);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw($READ_LABEL_STATUS_VOLUME_MISSING);

$_ReadLabelStatusFlags_VALUES{"VOLUME_MISSING"} = $READ_LABEL_STATUS_VOLUME_MISSING;

push @EXPORT_OK, qw($READ_LABEL_STATUS_VOLUME_UNLABELED);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw($READ_LABEL_STATUS_VOLUME_UNLABELED);

$_ReadLabelStatusFlags_VALUES{"VOLUME_UNLABELED"} = $READ_LABEL_STATUS_VOLUME_UNLABELED;

push @EXPORT_OK, qw($READ_LABEL_STATUS_VOLUME_ERROR);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw($READ_LABEL_STATUS_VOLUME_ERROR);

$_ReadLabelStatusFlags_VALUES{"VOLUME_ERROR"} = $READ_LABEL_STATUS_VOLUME_ERROR;

push @EXPORT_OK, qw($READ_LABEL_STATUS_FLAGS_MAX);
push @{$EXPORT_TAGS{"ReadLabelStatusFlags"}}, qw($READ_LABEL_STATUS_FLAGS_MAX);

#copy symbols in ReadLabelStatusFlags to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"ReadLabelStatusFlags"}};

push @EXPORT_OK, qw(PropertyPhaseFlags_to_strings);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw(PropertyPhaseFlags_to_strings);

my %_PropertyPhaseFlags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub PropertyPhaseFlags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_PropertyPhaseFlags_VALUES) {
	my $v = $_PropertyPhaseFlags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($PROPERTY_PHASE_BEFORE_START);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_BEFORE_START);

$_PropertyPhaseFlags_VALUES{"BEFORE_START"} = $PROPERTY_PHASE_BEFORE_START;

push @EXPORT_OK, qw($PROPERTY_PHASE_BETWEEN_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_BETWEEN_FILE_WRITE);

$_PropertyPhaseFlags_VALUES{"BETWEEN_FILE_WRITE"} = $PROPERTY_PHASE_BETWEEN_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_PHASE_INSIDE_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_INSIDE_FILE_WRITE);

$_PropertyPhaseFlags_VALUES{"INSIDE_FILE_WRITE"} = $PROPERTY_PHASE_INSIDE_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_PHASE_BETWEEN_FILE_READ);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_BETWEEN_FILE_READ);

$_PropertyPhaseFlags_VALUES{"BETWEEN_FILE_READ"} = $PROPERTY_PHASE_BETWEEN_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_PHASE_INSIDE_FILE_READ);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_INSIDE_FILE_READ);

$_PropertyPhaseFlags_VALUES{"INSIDE_FILE_READ"} = $PROPERTY_PHASE_INSIDE_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_PHASE_MAX);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_MAX);

push @EXPORT_OK, qw($PROPERTY_PHASE_MASK);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_MASK);

push @EXPORT_OK, qw($PROPERTY_PHASE_SHIFT);
push @{$EXPORT_TAGS{"PropertyPhaseFlags"}}, qw($PROPERTY_PHASE_SHIFT);

#copy symbols in PropertyPhaseFlags to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"PropertyPhaseFlags"}};

push @EXPORT_OK, qw(PropertyAccessFlags_to_strings);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw(PropertyAccessFlags_to_strings);

my %_PropertyAccessFlags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub PropertyAccessFlags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_PropertyAccessFlags_VALUES) {
	my $v = $_PropertyAccessFlags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_BEFORE_START);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_BEFORE_START);

$_PropertyAccessFlags_VALUES{"GET_BEFORE_START"} = $PROPERTY_ACCESS_GET_BEFORE_START;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"GET_BETWEEN_FILE_WRITE"} = $PROPERTY_ACCESS_GET_BETWEEN_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"GET_INSIDE_FILE_WRITE"} = $PROPERTY_ACCESS_GET_INSIDE_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_BETWEEN_FILE_READ);

$_PropertyAccessFlags_VALUES{"GET_BETWEEN_FILE_READ"} = $PROPERTY_ACCESS_GET_BETWEEN_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_INSIDE_FILE_READ);

$_PropertyAccessFlags_VALUES{"GET_INSIDE_FILE_READ"} = $PROPERTY_ACCESS_GET_INSIDE_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_BEFORE_START);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_BEFORE_START);

$_PropertyAccessFlags_VALUES{"SET_BEFORE_START"} = $PROPERTY_ACCESS_SET_BEFORE_START;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"SET_BETWEEN_FILE_WRITE"} = $PROPERTY_ACCESS_SET_BETWEEN_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE);

$_PropertyAccessFlags_VALUES{"SET_INSIDE_FILE_WRITE"} = $PROPERTY_ACCESS_SET_INSIDE_FILE_WRITE;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_BETWEEN_FILE_READ);

$_PropertyAccessFlags_VALUES{"SET_BETWEEN_FILE_READ"} = $PROPERTY_ACCESS_SET_BETWEEN_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_READ);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_INSIDE_FILE_READ);

$_PropertyAccessFlags_VALUES{"SET_INSIDE_FILE_READ"} = $PROPERTY_ACCESS_SET_INSIDE_FILE_READ;

push @EXPORT_OK, qw($PROPERTY_ACCESS_GET_MASK);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_GET_MASK);

push @EXPORT_OK, qw($PROPERTY_ACCESS_SET_MASK);
push @{$EXPORT_TAGS{"PropertyAccessFlags"}}, qw($PROPERTY_ACCESS_SET_MASK);

#copy symbols in PropertyAccessFlags to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"PropertyAccessFlags"}};

push @EXPORT_OK, qw(ConcurrencyParadigm_to_string);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw(ConcurrencyParadigm_to_string);

my %_ConcurrencyParadigm_VALUES;
#Convert an enum value to a single string
sub ConcurrencyParadigm_to_string {
    my ($enumval) = @_;

    for my $k (keys %_ConcurrencyParadigm_VALUES) {
	my $v = $_ConcurrencyParadigm_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($CONCURRENCY_PARADIGM_EXCLUSIVE);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw($CONCURRENCY_PARADIGM_EXCLUSIVE);

$_ConcurrencyParadigm_VALUES{"EXCLUSIVE"} = $CONCURRENCY_PARADIGM_EXCLUSIVE;

push @EXPORT_OK, qw($CONCURRENCY_PARADIGM_SHARED_READ);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw($CONCURRENCY_PARADIGM_SHARED_READ);

$_ConcurrencyParadigm_VALUES{"SHARED_READ"} = $CONCURRENCY_PARADIGM_SHARED_READ;

push @EXPORT_OK, qw($CONCURRENCY_PARADIGM_RANDOM_ACCESS);
push @{$EXPORT_TAGS{"ConcurrencyParadigm"}}, qw($CONCURRENCY_PARADIGM_RANDOM_ACCESS);

$_ConcurrencyParadigm_VALUES{"RANDOM_ACCESS"} = $CONCURRENCY_PARADIGM_RANDOM_ACCESS;

#copy symbols in ConcurrencyParadigm to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"ConcurrencyParadigm"}};

push @EXPORT_OK, qw(StreamingRequirement_to_string);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw(StreamingRequirement_to_string);

my %_StreamingRequirement_VALUES;
#Convert an enum value to a single string
sub StreamingRequirement_to_string {
    my ($enumval) = @_;

    for my $k (keys %_StreamingRequirement_VALUES) {
	my $v = $_StreamingRequirement_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($STREAMING_REQUIREMENT_NONE);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw($STREAMING_REQUIREMENT_NONE);

$_StreamingRequirement_VALUES{"NONE"} = $STREAMING_REQUIREMENT_NONE;

push @EXPORT_OK, qw($STREAMING_REQUIREMENT_DESIRED);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw($STREAMING_REQUIREMENT_DESIRED);

$_StreamingRequirement_VALUES{"DESIRED"} = $STREAMING_REQUIREMENT_DESIRED;

push @EXPORT_OK, qw($STREAMING_REQUIREMENT_REQUIRED);
push @{$EXPORT_TAGS{"StreamingRequirement"}}, qw($STREAMING_REQUIREMENT_REQUIRED);

$_StreamingRequirement_VALUES{"REQUIRED"} = $STREAMING_REQUIREMENT_REQUIRED;

#copy symbols in StreamingRequirement to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"StreamingRequirement"}};

push @EXPORT_OK, qw(MediaAccessMode_to_string);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw(MediaAccessMode_to_string);

my %_MediaAccessMode_VALUES;
#Convert an enum value to a single string
sub MediaAccessMode_to_string {
    my ($enumval) = @_;

    for my $k (keys %_MediaAccessMode_VALUES) {
	my $v = $_MediaAccessMode_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_READ_ONLY);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_READ_ONLY);

$_MediaAccessMode_VALUES{"READ_ONLY"} = $MEDIA_ACCESS_MODE_READ_ONLY;

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_WORM);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_WORM);

$_MediaAccessMode_VALUES{"WORM"} = $MEDIA_ACCESS_MODE_WORM;

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_READ_WRITE);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_READ_WRITE);

$_MediaAccessMode_VALUES{"READ_WRITE"} = $MEDIA_ACCESS_MODE_READ_WRITE;

push @EXPORT_OK, qw($MEDIA_ACCESS_MODE_WRITE_ONLY);
push @{$EXPORT_TAGS{"MediaAccessMode"}}, qw($MEDIA_ACCESS_MODE_WRITE_ONLY);

$_MediaAccessMode_VALUES{"WRITE_ONLY"} = $MEDIA_ACCESS_MODE_WRITE_ONLY;

#copy symbols in MediaAccessMode to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"MediaAccessMode"}};

push @EXPORT_OK, qw(SizeAccuracy_to_string);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw(SizeAccuracy_to_string);

my %_SizeAccuracy_VALUES;
#Convert an enum value to a single string
sub SizeAccuracy_to_string {
    my ($enumval) = @_;

    for my $k (keys %_SizeAccuracy_VALUES) {
	my $v = $_SizeAccuracy_VALUES{$k};

	#is this a matching flag?
	if ($enumval == $v) {
	    return $k;
	}
    }

#default, just return the number
    return $enumval;
}

push @EXPORT_OK, qw($SIZE_ACCURACY_UNKNOWN);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw($SIZE_ACCURACY_UNKNOWN);

$_SizeAccuracy_VALUES{"UNKNOWN"} = $SIZE_ACCURACY_UNKNOWN;

push @EXPORT_OK, qw($SIZE_ACCURACY_ESTIMATE);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw($SIZE_ACCURACY_ESTIMATE);

$_SizeAccuracy_VALUES{"ESTIMATE"} = $SIZE_ACCURACY_ESTIMATE;

push @EXPORT_OK, qw($SIZE_ACCURACY_REAL);
push @{$EXPORT_TAGS{"SizeAccuracy"}}, qw($SIZE_ACCURACY_REAL);

$_SizeAccuracy_VALUES{"REAL"} = $SIZE_ACCURACY_REAL;

#copy symbols in SizeAccuracy to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"SizeAccuracy"}};

push @EXPORT_OK, qw(FeatureSupportFlags_to_strings);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw(FeatureSupportFlags_to_strings);

my %_FeatureSupportFlags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub FeatureSupportFlags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_FeatureSupportFlags_VALUES) {
	my $v = $_FeatureSupportFlags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($FEATURE_STATUS_ENABLED);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_STATUS_ENABLED);

$_FeatureSupportFlags_VALUES{"STATUS_ENABLED"} = $FEATURE_STATUS_ENABLED;

push @EXPORT_OK, qw($FEATURE_STATUS_DISABLED);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_STATUS_DISABLED);

$_FeatureSupportFlags_VALUES{"STATUS_DISABLED"} = $FEATURE_STATUS_DISABLED;

push @EXPORT_OK, qw($FEATURE_SURETY_BAD);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SURETY_BAD);

$_FeatureSupportFlags_VALUES{"SURETY_BAD"} = $FEATURE_SURETY_BAD;

push @EXPORT_OK, qw($FEATURE_SURETY_GOOD);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SURETY_GOOD);

$_FeatureSupportFlags_VALUES{"SURETY_GOOD"} = $FEATURE_SURETY_GOOD;

push @EXPORT_OK, qw($FEATURE_SOURCE_DEFAULT);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SOURCE_DEFAULT);

$_FeatureSupportFlags_VALUES{"SOURCE_DEFAULT"} = $FEATURE_SOURCE_DEFAULT;

push @EXPORT_OK, qw($FEATURE_SOURCE_DETECTED);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SOURCE_DETECTED);

$_FeatureSupportFlags_VALUES{"SOURCE_DETECTED"} = $FEATURE_SOURCE_DETECTED;

push @EXPORT_OK, qw($FEATURE_SOURCE_USER);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SOURCE_USER);

$_FeatureSupportFlags_VALUES{"SOURCE_USER"} = $FEATURE_SOURCE_USER;

push @EXPORT_OK, qw($FEATURE_SUPPORT_FLAGS_MAX);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SUPPORT_FLAGS_MAX);

push @EXPORT_OK, qw($FEATURE_SUPPORT_FLAGS_MASK);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SUPPORT_FLAGS_MASK);

push @EXPORT_OK, qw($FEATURE_SUPPORT_FLAGS_STATUS_MASK);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SUPPORT_FLAGS_STATUS_MASK);

push @EXPORT_OK, qw($FEATURE_SUPPORT_FLAGS_SURETY_MASK);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SUPPORT_FLAGS_SURETY_MASK);

push @EXPORT_OK, qw($FEATURE_SUPPORT_FLAGS_SOURCE_MASK);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw($FEATURE_SUPPORT_FLAGS_SOURCE_MASK);

push @EXPORT_OK, qw(feature_support_flags_is_valid);
push @{$EXPORT_TAGS{"FeatureSupportFlags"}}, qw(feature_support_flags_is_valid);

#copy symbols in FeatureSupportFlags to constants
push @{$EXPORT_TAGS{"constants"}},  @{$EXPORT_TAGS{"FeatureSupportFlags"}};


# SWIG produces a sub-package for the Device "class", in this case named 
# Amanda::Device::Device.  For user convenience, we allow Amanda::Device->new(..) to
# do the same thing.  This is a wrapper function, and not just a typeglob assignment,
# because we want to get the right blessing.
sub new {
    my $pkg = shift;
    Amanda::Device::Device->new(@_);
}
1;
