# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.33
#
# Don't modify this file, modify the SWIG interface instead.

package Amanda::Util;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package Amanda::Utilc;
bootstrap Amanda::Util;
package Amanda::Util;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package Amanda::Util;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Util;

*set_pname = *Amanda::Utilc::set_pname;
*safe_cd = *Amanda::Utilc::safe_cd;
*check_running_as = *Amanda::Utilc::check_running_as;
*set_erroutput_type = *Amanda::Utilc::set_erroutput_type;

# ------- VARIABLE STUBS --------

package Amanda::Util;

*RUNNING_AS_ROOT = *Amanda::Utilc::RUNNING_AS_ROOT;
*RUNNING_AS_DUMPUSER = *Amanda::Utilc::RUNNING_AS_DUMPUSER;
*RUNNING_AS_DUMPUSER_PREFERRED = *Amanda::Utilc::RUNNING_AS_DUMPUSER_PREFERRED;
*RUNNING_AS_CLIENT_LOGIN = *Amanda::Utilc::RUNNING_AS_CLIENT_LOGIN;
*RUNNING_AS_UID_ONLY = *Amanda::Utilc::RUNNING_AS_UID_ONLY;

@EXPORT_OK = ();
%EXPORT_TAGS = ();

use Amanda::Debug qw(:init);
use Carp;
use POSIX qw(:fcntl_h);

=head1 NAME

Amanda::Util - Runtime support for Amanda applications

=head1 Application Initialization

Application initialization generally looks like this:

  use Amanda::Config qw( :init );
  use Amanda::Util qw( :check_running_as_flags );
  use Amanda::Debug;

  Amanda::Util::setup_application("myapp", "server", "cmdline");
  # .. command-line processing ..
  Amanda::Config::config_init(...);
  Amanda::Util::finish_setup($RUNNING_AS_DUMPUSER);

=over

=item C<setup_application($name, $type, $context)>

Set up the operating environment for an application, without requiring any
configuration.

C<$name> is the name of the application, used in log messages, etc.  C<$type>
is usualy one of "server" or "client".  It specifies the subdirectory in which
debug logfiles will be created.  C<$context> indicates the usual manner in
which this application is invoked; one of C<"cmdline"> for a user-invoked
command-line utility (e.g., C<amadmin>) which should send human-readable error
messages to stderr; C<"daemon"> for a program started by C<amandad>, e.g.,
C<sendbackup>; or C<"scriptutil"> for a small program used from shell scripts,
e.g., C<amgetconf>

Based on C<$type> and C<$context>, this function does the following:

=over

=item *

sets up debug logging;

=item *

configures internationalization

=item *

sets the umask;

=item *

sets the current working directory to the debug or temporary directory;

=item *

closes any unnecessary file descriptors as a security meaasure;

=item *

ignores C<SIGPIPE>; and

=item *

sets the appropriate target for error messages.

=back

=cut

# private package variables
my $_pname;
my $_ptype;
my $_pcontext;

sub setup_application {
    my ($name, $type, $context) = @_;

    # sanity check
    croak("no name given") unless ($name);
    croak("no type given") unless ($type);
    croak("no context given") unless ($context);

    # store these as perl values
    $_pname = $name;
    $_ptype = $type;
    $_pcontext = $context;

    # and let the C side know about the pname
    set_pname($name);

    safe_cd(); # (also sets umask)
    check_std_fds();

    # set up debugging for this application type
    dbopen($type);

    # ignore SIGPIPE
    $SIG{'PIPE'} = 'IGNORE';

    set_erroutput_type($type, $context);
}

=item C<finish_setup($running_as_flags)>

Perform final initialization tasks that require a loaded configuration.
Specifically, move the debug log into a configuration-specific
subdirectory, and check that the current userid is appropriate for
this applciation.

The user is specified by one of the following flags, which are
available in export tag C<:check_running_as_flags>:

  $RUNNING_AS_ROOT                # root
  $RUNNING_AS_DUMPUSER            # dumpuser, from configuration
  $RUNNING_AS_DUMPUSER_PREFERRED  # dumpuser, but client_login is OK too
  $RUNNING_AS_CLIENT_LOGIN        # client_login (--with-user at build time)

If the flag C<$RUNNING_AS_UID_ONLY> is bit-or'd into C<$running_as_flags>, then
the euid is ignored; this is used for programs that expect to be setuid-root.

=cut

sub finish_setup {
    my ($running_as) = @_;

    my $config_name = Amanda::Config::get_config_name();

    if ($config_name) {
	dbrename($config_name, $_ptype);
    }

    check_running_as($running_as);
}

=item C<safe_env()>

Return a "safe" environment hash.  For non-setuid programs, this means filtering out any
localization variables.

=cut

sub safe_env {
    my %rv = %ENV;

    delete @rv{qw(IFS CDPATH ENV BASH_ENV LANG)};

    # delete all LC_* variables
    for my $var (grep /^LC_/, keys %rv) {
        delete $rv{$var};
    }

    return %rv;
}


push @EXPORT_OK, qw(running_as_flags_to_strings);
push @{$EXPORT_TAGS{"running_as_flags"}}, qw(running_as_flags_to_strings);

my %_running_as_flags_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub running_as_flags_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_running_as_flags_VALUES) {
	my $v = $_running_as_flags_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($RUNNING_AS_ROOT);
push @{$EXPORT_TAGS{"running_as_flags"}}, qw($RUNNING_AS_ROOT);

$_running_as_flags_VALUES{"RUNNING_AS_ROOT"} = $RUNNING_AS_ROOT;

push @EXPORT_OK, qw($RUNNING_AS_DUMPUSER);
push @{$EXPORT_TAGS{"running_as_flags"}}, qw($RUNNING_AS_DUMPUSER);

$_running_as_flags_VALUES{"RUNNING_AS_DUMPUSER"} = $RUNNING_AS_DUMPUSER;

push @EXPORT_OK, qw($RUNNING_AS_DUMPUSER_PREFERRED);
push @{$EXPORT_TAGS{"running_as_flags"}}, qw($RUNNING_AS_DUMPUSER_PREFERRED);

$_running_as_flags_VALUES{"RUNNING_AS_DUMPUSER_PREFERRED"} = $RUNNING_AS_DUMPUSER_PREFERRED;

push @EXPORT_OK, qw($RUNNING_AS_CLIENT_LOGIN);
push @{$EXPORT_TAGS{"running_as_flags"}}, qw($RUNNING_AS_CLIENT_LOGIN);

$_running_as_flags_VALUES{"RUNNING_AS_CLIENT_LOGIN"} = $RUNNING_AS_CLIENT_LOGIN;

push @EXPORT_OK, qw($RUNNING_AS_UID_ONLY);
push @{$EXPORT_TAGS{"running_as_flags"}}, qw($RUNNING_AS_UID_ONLY);

$_running_as_flags_VALUES{"RUNNING_AS_UID_ONLY"} = $RUNNING_AS_UID_ONLY;

sub check_std_fds {
    fcntl(STDIN, F_GETFD, 0) or critical("Standard input is not open");
    fcntl(STDOUT, F_GETFD, 0) or critical("Standard output is not open");
    fcntl(STDERR, F_GETFD, 0) or critical("Standard error is not open");
}

=back

=cut
1;
