//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006,2007,2008,2009 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

#ifndef _BTIO_H
#define _BTIO_H

int  bt_open_port(char* port);
int  bt_close_port(int final);

int  bt_read(char* buf, int len);
int  bt_read_tmo(char* buf, int len, int timeout);
int  bt_readchar(char* c, int timeout);
int  bt_write(char* buf, int len);
int  bt_put_command(char* command,
		    char* answer,
		    int   max,
		    int   timeout,
		    char* expect);

int  bt_getfd(void);

char * getBtAddress(void);
void freeBtAddress (void);

int closeSocketPort(int type);
int openSocketPort(int type, int port,char *path);

// SDP 
void sdpDeregister();

void openStdin();
void closeStdin();
int readStdin(char* buf, int max);

int unix_open_port (char* port);
int unix_close_port();
//int unix_read_port(char* buf, int l);

int listenAndAcceptSocketConn(); 
int writeSocketConn(char* command, int count); 
int writeBytesSocketConn(char* command);
int readSocketConn(char* buffer, int len);
int sendKeepAlive(void);

#endif
