module Test_grub =

  let conf = "# grub.conf generated by anaconda
#
# Note that you do not have to rerun grub after making changes to this file
# NOTICE:  You have a /boot partition.  This means that
#          all kernel and initrd paths are relative to /boot/, eg.
#          root (hd0,0)
#          kernel /vmlinuz-version ro root=/dev/vg00/lv00
#          initrd /initrd-version.img
#boot=/dev/sda
password --md5 $1$M9NLj$p2gs87vwNv48BUu.wAfVw0
default=0
timeout=5
splashimage=(hd0,0)/grub/splash.xpm.gz
hiddenmenu
title Fedora (2.6.24.4-64.fc8)
        root (hd0,0)
        kernel /vmlinuz-2.6.24.4-64.fc8 ro root=/dev/vg00/lv00
        initrd /initrd-2.6.24.4-64.fc8.img
title Fedora (2.6.24.3-50.fc8)
        root (hd0,0)
        kernel /vmlinuz-2.6.24.3-50.fc8 ro root=/dev/vg00/lv00
        initrd /initrd-2.6.24.3-50.fc8.img
title Fedora (2.6.21.7-3.fc8xen)
        root (hd0,0)
        kernel /xen.gz-2.6.21.7-3.fc8
        module /vmlinuz-2.6.21.7-3.fc8xen ro root=/dev/vg00/lv00
        module /initrd-2.6.21.7-3.fc8xen.img
title Fedora (2.6.24.3-34.fc8)
        root (hd0,0)
        kernel /vmlinuz-2.6.24.3-34.fc8 ro root=/dev/vg00/lv00
        initrd /initrd-2.6.24.3-34.fc8.img
"

  test Grub.lns get conf =
    { "#comment" = "grub.conf generated by anaconda" }
    {}
    { "#comment" = "Note that you do not have to rerun grub after making changes to this file" }
    { "#comment" = "NOTICE:  You have a /boot partition.  This means that" }
    { "#comment" = "all kernel and initrd paths are relative to /boot/, eg." }
    { "#comment" = "root (hd0,0)" }
    { "#comment" = "kernel /vmlinuz-version ro root=/dev/vg00/lv00" }
    { "#comment" = "initrd /initrd-version.img" }
    { "#comment" = "boot=/dev/sda" }
    { "password" = "$1$M9NLj$p2gs87vwNv48BUu.wAfVw0"
        { "md5" } }
    { "default" = "0" }
    { "timeout" = "5" }
    { "splashimage" = "(hd0,0)/grub/splash.xpm.gz" }
    { "hiddenmenu" }
    { "title" = "Fedora (2.6.24.4-64.fc8)"
        { "root" = "(hd0,0)" }
        { "kernel" = "/vmlinuz-2.6.24.4-64.fc8 ro root=/dev/vg00/lv00" }
        { "initrd" = "/initrd-2.6.24.4-64.fc8.img" } }
    { "title" = "Fedora (2.6.24.3-50.fc8)"
        { "root" = "(hd0,0)" }
        { "kernel" = "/vmlinuz-2.6.24.3-50.fc8 ro root=/dev/vg00/lv00" }
        { "initrd" = "/initrd-2.6.24.3-50.fc8.img" } }
    { "title" = "Fedora (2.6.21.7-3.fc8xen)"
        { "root" = "(hd0,0)" }
        { "kernel" = "/xen.gz-2.6.21.7-3.fc8" }
        { "modules" = "/vmlinuz-2.6.21.7-3.fc8xen ro root=/dev/vg00/lv00" }
        { "modules" = "/initrd-2.6.21.7-3.fc8xen.img" } }
    { "title" = "Fedora (2.6.24.3-34.fc8)"
        { "root" = "(hd0,0)" }
        { "kernel" = "/vmlinuz-2.6.24.3-34.fc8 ro root=/dev/vg00/lv00" }
        { "initrd" = "/initrd-2.6.24.3-34.fc8.img" } }

  test Grub.lns put conf after set "default" "0" = conf

  test Grub.lns get "# menu.lst - See: grub(8), info grub, update-grub(8)

## default num\n" =
    { "#comment" = "menu.lst - See: grub(8), info grub, update-grub(8)" }
    {}
    { "#comment" = "# default num" }

  (* Color directive *)
  test Grub.lns get "color cyan/blue white/blue\n" =
    { "color"
      { "normal"    { "foreground" = "cyan" }
                    { "background" = "blue" } }
      { "highlight" { "foreground" = "white" }
                    { "background" = "blue" } } }

  test Grub.lns get "\tcolor cyan/light-blue\n" =
    { "color"
      { "normal" { "foreground" = "cyan" }
                 { "background" = "light-blue" } } }

  test Grub.lns put "color cyan/light-blue\n" after
    set "/color/highlight/foreground" "white";
    set "/color/highlight/background" "black"    =
    "color cyan/light-blue white/black\n"

  (* Boot stanza with savedefault *)
  let boot_savedefault =
"title\t\tDebian GNU/Linux, kernel 2.6.18-6-vserver-686
root\t\t(hd0,0)
  kernel\t\t/boot/vmlinuz-2.6.18-6-vserver-686 root=/dev/md0 ro
initrd\t\t/boot/initrd.img-2.6.18-6-vserver-686
\tsavedefault\n"

  test Grub.lns get boot_savedefault =
    { "title" = "Debian GNU/Linux, kernel 2.6.18-6-vserver-686"
      { "root" = "(hd0,0)" }
      { "kernel" = "/boot/vmlinuz-2.6.18-6-vserver-686 root=/dev/md0 ro" }
      { "initrd" = "/boot/initrd.img-2.6.18-6-vserver-686" }
      { "savedefault" } }


(* Local Variables: *)
(* mode: caml       *)
(* End:             *)
