/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

enum {
	COLUMN_UPA,
	COLUMN_LAYER,
	COLUMN_TYPE,
	COLUMN_SIZE,
	COLUMN_DATA,
	COLUMN_TIMESTAMP,
	COLUMN_HANDLE,
	COLUMN_PSM,
	COLUMN_PACKET,
};

enum {
	LAYER_DATA,
	LAYER_BASEBAND,
	LAYER_HCI,
	LAYER_LMP,
	LAYER_L2CAP,
};

GtkWidget *create_tracer_from_file(const gchar *filename, GCallback callback);
GtkWidget *create_live_import(const gchar *hostname, GCallback callback);

enum {
	FORMAT_UNKNOWN,
	FORMAT_HCIDUMP,
	FORMAT_BTSNOOP,
	FORMAT_PKTLOG,
};

struct hcidump_hdr {
	guint16 len;
	guint8  in;
	guint8  pad;
	guint32 ts_sec;
	guint32 ts_usec;
} __attribute__ ((packed));
#define HCIDUMP_HDR_SIZE (sizeof(struct hcidump_hdr))

struct btsnoop_hdr {
	guint8  id[8];
	guint32 version;
	guint32 type;
} __attribute__ ((packed));
#define BTSNOOP_HDR_SIZE (sizeof(struct btsnoop_hdr))

struct btsnoop_pkt {
	guint32 size;
	guint32 len;
	guint32 flags;
	guint32 drops;
	guint64 ts;
} __attribute__ ((packed));
#define BTSNOOP_PKT_SIZE (sizeof(struct btsnoop_pkt))

extern guint8 btsnoop_id[8];

struct pktlog_hdr {
	guint32 len;
	guint64 ts;
	guint8  type;
} __attribute__ ((packed));
#define PKTLOG_HDR_SIZE (sizeof(struct pktlog_hdr))
