/* 
 * Copyright (C) 2002-2004 Benoit Poulot-Cazajous
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cachecc1.h"

/*
 * Strong Hash
 * Derived from the RSA Data Security, Inc. MD4 Message-Digest Algorithm
 * Specifications (RFC 1320)
 * with "simplified" padding, endianness, etc...
 */

#define F(x,y,z) (((x) & (y)) | ((~x) & (z)))
#define G(x,y,z) (((x) & (y)) | ((x) & (z)) | ((y) & (z)))
#define H(x,y,z) ((x) ^ (y) ^ (z))
#define L(x,n) (((x) << (n)) | ((x & 0xffffffff) >> (32-(n))))

static unsigned int x[16];
static unsigned int state[4];
static unsigned int pos;
static unsigned int count;

/* Derived from MD4Transform */
static void crc_mix()
{
    unsigned int a = state[0];
    unsigned int b = state[1];
    unsigned int c = state[2];
    unsigned int d = state[3];
    
        /* Round 1 */
#define FF(a,b,c,d,x,s) a += F(b,c,d) + x; a = L(a,s);
    FF (a, b, c, d, x[ 0],  3);  FF (d, a, b, c, x[ 1],  7);
    FF (c, d, a, b, x[ 2], 11);  FF (b, c, d, a, x[ 3], 19);
    FF (a, b, c, d, x[ 4],  3);  FF (d, a, b, c, x[ 5],  7);
    FF (c, d, a, b, x[ 6], 11);  FF (b, c, d, a, x[ 7], 19);
    FF (a, b, c, d, x[ 8],  3);  FF (d, a, b, c, x[ 9],  7);
    FF (c, d, a, b, x[10], 11);  FF (b, c, d, a, x[11], 19);
    FF (a, b, c, d, x[12],  3);  FF (d, a, b, c, x[13],  7);
    FF (c, d, a, b, x[14], 11);  FF (b, c, d, a, x[15], 19);
#undef FF

        /* Round 2 */
#define FF(a,b,c,d,x,s) a += G(b,c,d) + x + 0x5a827999; a = L(a,s);
    FF (a, b, c, d, x[ 0],  3);  FF (d, a, b, c, x[ 4],  5);
    FF (c, d, a, b, x[ 8],  9);  FF (b, c, d, a, x[12], 13);
    FF (a, b, c, d, x[ 1],  3);  FF (d, a, b, c, x[ 5],  5);
    FF (c, d, a, b, x[ 9],  9);  FF (b, c, d, a, x[13], 13);
    FF (a, b, c, d, x[ 2],  3);  FF (d, a, b, c, x[ 6],  5);
    FF (c, d, a, b, x[10],  9);  FF (b, c, d, a, x[14], 13);
    FF (a, b, c, d, x[ 3],  3);  FF (d, a, b, c, x[ 7],  5);
    FF (c, d, a, b, x[11],  9);  FF (b, c, d, a, x[15], 13);
#undef FF

        /* Round 3 */
#define FF(a,b,c,d,x,s) a += H(b,c,d) + x + 0x6ed9eba1; a = L(a,s);
    FF (a, b, c, d, x[ 0],  3);  FF (d, a, b, c, x[ 8],  9);
    FF (c, d, a, b, x[ 4], 11);  FF (b, c, d, a, x[12], 15);
    FF (a, b, c, d, x[ 2],  3);  FF (d, a, b, c, x[10],  9);
    FF (c, d, a, b, x[ 6], 11);  FF (b, c, d, a, x[14], 15);
    FF (a, b, c, d, x[ 1],  3);  FF (d, a, b, c, x[ 9],  9);
    FF (c, d, a, b, x[ 5], 11);  FF (b, c, d, a, x[13], 15);
    FF (a, b, c, d, x[ 3],  3);  FF (d, a, b, c, x[11],  9);
    FF (c, d, a, b, x[ 7], 11);  FF (b, c, d, a, x[15], 15);
#undef FF

    state[0] += a;
    state[1] += b;
    state[2] += c;
    state[3] += d;
}

void crc_block(unsigned int *q, int n)
{
    while (n--) {
        x[pos++] = *q++;
        count++;
        if (pos == 16) {
            crc_mix();
            pos = 0;
        }
    }
}

void crc_put(unsigned int y)
{
    crc_block(&y, 1);
}

void crc_init(int a, int b, int c, int d, int e)
{
    pos = 0;
    count = 0;

        /* Load magic initialization constants. */
    state[0] = 0x67452301;
    state[1] = 0xefcdab89;
    state[2] = 0x98badcfe;
    state[3] = 0x10325476;
    crc_put(a);
    crc_put(b);
    crc_put(c);
    crc_put(d);
    crc_put(e);
}

char *crc_get()
{
    char alpha6[65] =
        "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_@";
    static char t[23];
    int i;
    unsigned int x1, x2, x3, x4, x5;

    x5 = count;
    crc_put(1);
    while (pos != 15) crc_put(0);
    crc_put(x5);
    x1 = state[0] & 0xffffffff;
    x2 = state[1] & 0xffffffff;
    x3 = state[2] & 0xffffffff;
    x4 = state[3] & 0xffffffff;
    for (i = 0; i < 22; ++i) {
        t[i] = alpha6[(unsigned char)x1 & 63];
        x1 = (x1 >> 6) + ((x2 & 63) << 26);
        x2 = (x2 >> 6) + ((x3 & 63) << 26);
        x3 = (x3 >> 6) + ((x4 & 63) << 26);
        x4 = (x4 >> 6) + ((x5 & 63) << 26);        
        x5 = (x5 >> 6);
    }
    t[i] = 0;
    return t;
}

/* arch-tag: 27069a0e-1262-4e21-a9c9-d0d124424b96 */
