/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xml;

import org.exolab.adaptx.xml.AttributeListWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class DOM2SAX {
    public static void process(Document document, DocumentHandler documentHandler) throws SAXException {
        if (document == null) {
            return;
        }
        if (documentHandler == null) {
            return;
        }
        documentHandler.startDocument();
        DOM2SAX.processChildren(document, documentHandler);
        documentHandler.endDocument();
    }

    private static void process(Element element, DocumentHandler documentHandler) throws SAXException {
        String string = element.getNodeName();
        AttributeListWrapper attributeListWrapper = new AttributeListWrapper(element.getAttributes());
        documentHandler.startElement(string, attributeListWrapper);
        DOM2SAX.processChildren(element, documentHandler);
        documentHandler.endElement(string);
    }

    public static void process(Node node, DocumentHandler documentHandler) throws SAXException {
        if (node == null || documentHandler == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                DOM2SAX.process((Document)node, documentHandler);
                break;
            }
            case 11: {
                DOM2SAX.processChildren(node, documentHandler);
                break;
            }
            case 1: {
                DOM2SAX.process((Element)node, documentHandler);
                break;
            }
            case 3: 
            case 4: {
                DOM2SAX.process((Text)node, documentHandler);
                break;
            }
            case 7: {
                DOM2SAX.process((ProcessingInstruction)node, documentHandler);
                break;
            }
        }
    }

    private static void process(ProcessingInstruction processingInstruction, DocumentHandler documentHandler) throws SAXException {
        documentHandler.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    private static void process(Text text, DocumentHandler documentHandler) throws SAXException {
        String string = text.getData();
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            documentHandler.characters(cArray, 0, cArray.length);
        }
    }

    private static void processChildren(Node node, DocumentHandler documentHandler) throws SAXException {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            DOM2SAX.process(node2, documentHandler);
            node2 = node2.getNextSibling();
        }
    }
}

