/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath;

import java.util.Hashtable;
import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.VariableSet;
import org.exolab.adaptx.xpath.XPathFunction;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;

public class XPathContext {
    private Hashtable _namespaces = null;
    private XPathContext _parent = null;
    private int _position;
    private final VariableSet _variables;
    private NodeSet _nodeSet = null;

    public XPathContext(VariableSet variableSet, NodeSet nodeSet, int n) {
        this._nodeSet = nodeSet;
        this.setPosition(n);
        this._variables = variableSet;
    }

    public XPathContext(XPathNode xPathNode) {
        this._position = 0;
        this._variables = null;
        this._nodeSet = new NodeSet(xPathNode);
    }

    public XPathContext(XPathNode xPathNode, VariableSet variableSet) {
        this._nodeSet = new NodeSet(xPathNode);
        this._position = 0;
        this._variables = variableSet;
    }

    public void addNamespaceBinding(String string, String string2) {
        if (this._namespaces == null) {
            this._namespaces = new Hashtable();
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            this._namespaces.remove(string);
        } else {
            this._namespaces.put(string, string2);
        }
    }

    public int[] getDocumentOrder(XPathNode xPathNode) {
        if (this._parent != null) {
            return this._parent.getDocumentOrder(xPathNode);
        }
        return new int[0];
    }

    public XPathNode getElementById(XPathNode xPathNode, String string) {
        if (this._parent != null) {
            return this.getElementById(xPathNode, string);
        }
        return null;
    }

    public XPathFunction getFunction(String string, String string2) {
        if (this._parent != null) {
            return this._parent.getFunction(string, string2);
        }
        return null;
    }

    public String getNamespaceURI(String string) {
        if (this._namespaces != null) {
            String string2;
            if (string == null) {
                string = "";
            }
            if ((string2 = (String)this._namespaces.get(string)) != null) {
                return string2;
            }
        }
        if (this._parent != null) {
            return this._parent.getNamespaceURI(string);
        }
        return null;
    }

    public XPathNode getNode() {
        if (this._nodeSet == null) {
            return null;
        }
        return this._nodeSet.item(this._position);
    }

    public NodeSet getNodeSet() {
        return this._nodeSet;
    }

    public int getPosition() {
        return this._position;
    }

    public int getSize() {
        if (this._nodeSet == null) {
            return 0;
        }
        return this._nodeSet.size();
    }

    public XPathResult getVariable(String string) {
        if (this._variables == null) {
            if (this._parent == null) {
                return null;
            }
            return this._parent.getVariable(string);
        }
        XPathResult xPathResult = this._variables.getVariable(string);
        if (xPathResult == null && this._parent != null) {
            xPathResult = this._parent.getVariable(string);
        }
        return xPathResult;
    }

    public XPathContext newContext(NodeSet nodeSet, int n) {
        XPathContext xPathContext = new XPathContext(null, nodeSet, n);
        xPathContext._parent = this;
        return xPathContext;
    }

    public XPathContext newContext(XPathNode xPathNode) {
        XPathContext xPathContext = new XPathContext(xPathNode);
        xPathContext._parent = this;
        return xPathContext;
    }

    public NodeSet newNodeSet() {
        return new NodeSet();
    }

    public NodeSet newNodeSet(int n) {
        return new NodeSet(n);
    }

    public NodeSet newNodeSet(XPathNode xPathNode) {
        return new NodeSet(xPathNode);
    }

    public void setNodeSet(NodeSet nodeSet, int n) {
        if (nodeSet == null) {
            throw new IllegalArgumentException("Argument nodeSet is null");
        }
        this._nodeSet = nodeSet;
        this.setPosition(n);
    }

    public void setPosition(int n) {
        if (this._nodeSet == null) {
            throw new IllegalStateException("Error no context node-set exists.");
        }
        if (n < 0 || n >= this._nodeSet.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n) + " is not within the bounds of the context node-set.");
        }
        this._position = n;
    }
}

