/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.MatchExpression;
import org.exolab.adaptx.xpath.engine.PredicateExpr;

abstract class FilterBase
extends XPathExpression
implements MatchExpression {
    public static final int NO_OP = 0;
    public static final int PARENT_OP = 1;
    private int ancestryOp;
    PredicateExpr _predicate = null;

    public FilterBase(int n) {
        this.ancestryOp = n;
    }

    public void addPredicate(XPathExpression xPathExpression) throws XPathException {
        this.addPredicate(new PredicateExpr(xPathExpression));
    }

    public void addPredicate(PredicateExpr predicateExpr) throws XPathException {
        if (this._predicate == null) {
            this._predicate = predicateExpr;
        } else {
            PredicateExpr predicateExpr2 = this._predicate;
            while (predicateExpr2.hasNext()) {
                predicateExpr2 = predicateExpr2.getNext();
            }
            predicateExpr2.setNext(predicateExpr);
        }
    }

    public abstract XPathResult evaluate(XPathContext var1) throws XPathException;

    public void evaluatePredicates(NodeSet nodeSet, XPathContext xPathContext) throws XPathException {
        if (this._predicate == null || nodeSet == null) {
            return;
        }
        if (nodeSet.size() == 0) {
            return;
        }
        PredicateExpr predicateExpr = this._predicate;
        NodeSet nodeSet2 = xPathContext.newNodeSet(nodeSet.size());
        while (predicateExpr != null) {
            XPathContext xPathContext2 = xPathContext.newContext(nodeSet, 0);
            int n = 0;
            while (n < nodeSet.size()) {
                if (n > 0) {
                    xPathContext2.setPosition(n);
                }
                XPathResult xPathResult = predicateExpr.evaluate(xPathContext2);
                switch (xPathResult.getResultType()) {
                    case 1: {
                        double d = xPathResult.numberValue();
                        if (d == (double)(n + 1)) break;
                        nodeSet2.add(xPathContext2.getNode());
                        break;
                    }
                    default: {
                        if (xPathResult.booleanValue()) break;
                        nodeSet2.add(xPathContext2.getNode());
                        break;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < nodeSet2.size()) {
                nodeSet.remove(nodeSet2.item(n));
                ++n;
            }
            nodeSet2.clear();
            predicateExpr = predicateExpr.getNext();
        }
    }

    public int getAncestryOp() {
        return this.ancestryOp;
    }

    public abstract double getDefaultPriority();

    public abstract short getExprType();

    public PredicateExpr getPredicate() {
        return this._predicate;
    }

    public boolean hasPredicates() {
        return this._predicate != null;
    }

    public abstract boolean matches(XPathNode var1, XPathContext var2) throws XPathException;

    private PredicateExpr removePredicate(PredicateExpr predicateExpr) throws XPathException {
        if (this._predicate == null) {
            return null;
        }
        if (this._predicate == predicateExpr) {
            this._predicate = this._predicate.getNext();
        } else {
            PredicateExpr predicateExpr2 = this._predicate.getNext();
            PredicateExpr predicateExpr3 = this._predicate;
            while (predicateExpr2 != null) {
                if (predicateExpr2 == predicateExpr) {
                    predicateExpr3.setNext(predicateExpr2.getNext());
                    return predicateExpr2;
                }
                predicateExpr3 = predicateExpr2;
                predicateExpr2 = predicateExpr2.getNext();
            }
        }
        return null;
    }

    private void setAncestryOp(int n) {
        this.ancestryOp = n;
    }

    public String toString() {
        if (this._predicate == null) {
            return "";
        }
        return this._predicate.toString();
    }
}

