/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.engine.FilterBase;
import org.exolab.adaptx.xpath.engine.PrimaryExpr;

final class FilterExpr
extends FilterBase {
    private final PrimaryExpr primaryExpr;
    private final ErrorExpr error;

    protected FilterExpr(ErrorExpr errorExpr) {
        super(0);
        this.error = errorExpr;
        this.primaryExpr = null;
    }

    protected FilterExpr(PrimaryExpr primaryExpr) {
        super(0);
        this.primaryExpr = primaryExpr;
        this.error = null;
    }

    protected FilterExpr(PrimaryExpr primaryExpr, int n) {
        super(n);
        this.primaryExpr = primaryExpr;
        this.error = null;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        if (this.primaryExpr == null) {
            return xPathContext.newNodeSet();
        }
        XPathResult xPathResult = this.primaryExpr.evaluate(xPathContext);
        NodeSet nodeSet = null;
        switch (xPathResult.getResultType()) {
            case 3: {
                nodeSet = (NodeSet)xPathResult;
                break;
            }
            default: {
                System.out.println("ExprResult: " + xPathResult.getResultType());
                throw new XPathException("expecting NodeSet or TreeFragment as the result of the expression: " + this.primaryExpr);
            }
        }
        if (this.hasPredicates()) {
            this.evaluatePredicates(nodeSet, xPathContext);
        }
        return nodeSet;
    }

    public double getDefaultPriority() {
        return 0.5;
    }

    public short getExprType() {
        return 1;
    }

    public PrimaryExpr getPrimaryExpr() {
        return this.primaryExpr;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = (NodeSet)this.evaluate(xPathContext);
        this.evaluatePredicates(nodeSet, xPathContext);
        return nodeSet.contains(xPathNode);
    }

    public String toString() {
        if (this.primaryExpr == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.primaryExpr.toString());
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

