/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import java.util.Stack;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.engine.AdditionExpr;
import org.exolab.adaptx.xpath.engine.AndExpr;
import org.exolab.adaptx.xpath.engine.AnyNodeExpr;
import org.exolab.adaptx.xpath.engine.AttributeExpr;
import org.exolab.adaptx.xpath.engine.CommentExpr;
import org.exolab.adaptx.xpath.engine.ElementExpr;
import org.exolab.adaptx.xpath.engine.EqualityExpr;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.engine.FilterBase;
import org.exolab.adaptx.xpath.engine.FilterExpr;
import org.exolab.adaptx.xpath.engine.FunctionCall;
import org.exolab.adaptx.xpath.engine.IdentityExpr;
import org.exolab.adaptx.xpath.engine.InnerExpr;
import org.exolab.adaptx.xpath.engine.Lexer;
import org.exolab.adaptx.xpath.engine.LiteralExpr;
import org.exolab.adaptx.xpath.engine.LocationStep;
import org.exolab.adaptx.xpath.engine.MatchExpression;
import org.exolab.adaptx.xpath.engine.MultiplicativeExpr;
import org.exolab.adaptx.xpath.engine.NamespaceExpr;
import org.exolab.adaptx.xpath.engine.NodeExpression;
import org.exolab.adaptx.xpath.engine.NumberExpr;
import org.exolab.adaptx.xpath.engine.OrExpr;
import org.exolab.adaptx.xpath.engine.PIExpr;
import org.exolab.adaptx.xpath.engine.ParentExpr;
import org.exolab.adaptx.xpath.engine.ParseException;
import org.exolab.adaptx.xpath.engine.PathExpr;
import org.exolab.adaptx.xpath.engine.PrimaryExpr;
import org.exolab.adaptx.xpath.engine.RootExpr;
import org.exolab.adaptx.xpath.engine.SelectExpr;
import org.exolab.adaptx.xpath.engine.SubtractionExpr;
import org.exolab.adaptx.xpath.engine.TextExpression;
import org.exolab.adaptx.xpath.engine.Token;
import org.exolab.adaptx.xpath.engine.UnionExpr;
import org.exolab.adaptx.xpath.engine.VariableReference;
import org.exolab.adaptx.xpath.engine.WildCardExpr;
import org.exolab.adaptx.xpath.functions.BooleanFunctionCall;
import org.exolab.adaptx.xpath.functions.Concat;
import org.exolab.adaptx.xpath.functions.Contains;
import org.exolab.adaptx.xpath.functions.CountFunctionCall;
import org.exolab.adaptx.xpath.functions.ExtensionFunctionCall;
import org.exolab.adaptx.xpath.functions.FalseFunctionCall;
import org.exolab.adaptx.xpath.functions.FormatNumber;
import org.exolab.adaptx.xpath.functions.IdFunctionCall;
import org.exolab.adaptx.xpath.functions.IdRefFunctionCall;
import org.exolab.adaptx.xpath.functions.LangFunctionCall;
import org.exolab.adaptx.xpath.functions.LastFunctionCall;
import org.exolab.adaptx.xpath.functions.Normalize;
import org.exolab.adaptx.xpath.functions.NotFunctionCall;
import org.exolab.adaptx.xpath.functions.NumberFunctionCall;
import org.exolab.adaptx.xpath.functions.PositionFunctionCall;
import org.exolab.adaptx.xpath.functions.StartsWith;
import org.exolab.adaptx.xpath.functions.StringFunctionCall;
import org.exolab.adaptx.xpath.functions.StringLength;
import org.exolab.adaptx.xpath.functions.Substring;
import org.exolab.adaptx.xpath.functions.SubstringAfter;
import org.exolab.adaptx.xpath.functions.SubstringBefore;
import org.exolab.adaptx.xpath.functions.SumFunctionCall;
import org.exolab.adaptx.xpath.functions.TextFunctionCall;
import org.exolab.adaptx.xpath.functions.Translate;
import org.exolab.adaptx.xpath.functions.TrueFunctionCall;
import org.exolab.adaptx.xpath.functions.XMLNamesFunctionCall;

public class Parser {
    private static final String PATTERN_SEP = "|";
    private static final WildCardExpr wildCardExpr = new WildCardExpr();
    private static final String INVALID_EXPR = "Invalid expression: ";

    private static XPathExpression createBinaryExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2, Token token) throws XPathException {
        if (xPathExpression == null) {
            throw new XPathException("Missing left side of expression: ");
        }
        if (xPathExpression2 == null) {
            throw new XPathException("Missing right side of expression: ");
        }
        switch (token.type) {
            case 302: {
                return new OrExpr(xPathExpression, xPathExpression2);
            }
            case 301: {
                return new AndExpr(xPathExpression, xPathExpression2);
            }
            case 313: {
                return new EqualityExpr(xPathExpression, xPathExpression2, 5);
            }
            case 312: {
                return new EqualityExpr(xPathExpression, xPathExpression2, 0);
            }
            case 314: {
                return new EqualityExpr(xPathExpression, xPathExpression2, 1);
            }
            case 315: {
                return new EqualityExpr(xPathExpression, xPathExpression2, 2);
            }
            case 316: {
                return new EqualityExpr(xPathExpression, xPathExpression2, 3);
            }
            case 317: {
                return new EqualityExpr(xPathExpression, xPathExpression2, 4);
            }
            case 309: {
                return new AdditionExpr(xPathExpression, xPathExpression2);
            }
            case 310: {
                return new SubtractionExpr(xPathExpression, xPathExpression2);
            }
            case 311: {
                return new MultiplicativeExpr(xPathExpression, xPathExpression2, 0);
            }
            case 303: {
                return new MultiplicativeExpr(xPathExpression, xPathExpression2, 2);
            }
            case 304: {
                return new MultiplicativeExpr(xPathExpression, xPathExpression2, 1);
            }
            case 305: {
                return new MultiplicativeExpr(xPathExpression, xPathExpression2, 3);
            }
        }
        throw new XPathException("Invalid binary expr: " + xPathExpression + token + xPathExpression2);
    }

    private static PathExpr createDescendantOrSelf() {
        LocationStep locationStep = new LocationStep(1);
        locationStep.setAxisIdentifier((short)5);
        locationStep.setNodeExpr(new AnyNodeExpr());
        PathExpr pathExpr = new PathExpr();
        pathExpr.setFilter(locationStep);
        return pathExpr;
    }

    public static XPathExpression createExpr(String string) throws XPathException {
        Lexer lexer = null;
        try {
            lexer = new Lexer(string);
        }
        catch (ParseException parseException) {
            return new ErrorExpr(parseException.getMessage());
        }
        return Parser.createExpr(lexer);
    }

    private static XPathExpression createExpr(Lexer lexer) throws XPathException {
        if (!lexer.hasMoreTokens()) {
            Parser.missingExpr(lexer.toString(), null);
        }
        Object object = null;
        Stack<XPathExpression> stack = new Stack<XPathExpression>();
        Stack<Token> stack2 = new Stack<Token>();
        boolean bl = true;
        while (lexer.hasMoreTokens() && bl) {
            Token token = lexer.nextToken();
            if (Lexer.isBinaryOp(token)) {
                if (!stack.empty() && !Parser.hasGreaterPrecedence(token, (Token)stack2.peek())) {
                    object = Parser.createBinaryExpr((XPathExpression)stack.pop(), (XPathExpression)object, (Token)stack2.pop());
                }
                stack.push((XPathExpression)object);
                stack2.push(token);
                object = null;
                continue;
            }
            block0 : switch (token.type) {
                case 2: 
                case 4: 
                case 6: {
                    lexer.pushBack();
                    bl = false;
                    break;
                }
                case 701: {
                    object = new LiteralExpr(token.value);
                    break;
                }
                case 308: {
                    Object object2;
                    if (object == null) {
                        object2 = "'|' cannot start an expr";
                        throw new XPathException((String)object2);
                    }
                    if (object instanceof PathExpr) {
                        object2 = new UnionExpr((PathExpr)object);
                        ((UnionExpr)object2).setUnionExpr(Parser.createUnionExpr(lexer));
                        object = object2;
                        break;
                    }
                    throw new XPathException("#parse error: " + lexer.toString());
                }
                case 306: 
                case 307: {
                    Object object3;
                    Object object4;
                    Object object2;
                    if (object == null) {
                        lexer.pushBack();
                        object = Parser.createPathExpr(lexer);
                        break;
                    }
                    if (((XPathExpression)object).getExprType() == 6) {
                        object2 = (PrimaryExpr)object;
                        switch (((PrimaryExpr)object2).getType()) {
                            case 0: 
                            case 4: {
                                object4 = new FilterExpr((PrimaryExpr)object2);
                                lexer.pushBack();
                                object = new PathExpr((FilterBase)object4, Parser.createPathExpr(lexer));
                                break block0;
                            }
                        }
                        object3 = "Primary expr used as part of a path expression.";
                        throw new XPathException((String)object3);
                    }
                    if (object instanceof PathExpr) {
                        lexer.pushBack();
                        ((PathExpr)object).setSubPath(Parser.createPathExpr(lexer));
                        break;
                    }
                    object2 = "Invalid path expression: ";
                    object2 = String.valueOf(object2) + lexer.toString();
                    throw new XPathException((String)object2);
                }
                default: {
                    Object object3;
                    lexer.pushBack();
                    if (Parser.isLocationStepToken(token)) {
                        if (object == null) {
                            object = Parser.createPathExpr(lexer);
                            break;
                        }
                        if (object instanceof PathExpr) {
                            ((PathExpr)object).setSubPath(Parser.createPathExpr(lexer));
                            break;
                        }
                        throw new XPathException("invalid expr: " + lexer.toString());
                    }
                    Object object2 = Parser.createPrimaryExpr(lexer);
                    Object object4 = lexer.lookAhead(0);
                    if (object4 != null && ((Token)object4).type == 3) {
                        object3 = null;
                        FilterExpr filterExpr = new FilterExpr((PrimaryExpr)object2);
                        Parser.parsePredicates(filterExpr, lexer);
                        object = object3 = new PathExpr(filterExpr);
                        break;
                    }
                    object = object2;
                    break;
                }
            }
        }
        while (!stack.empty()) {
            object = Parser.createBinaryExpr((XPathExpression)stack.pop(), object, (Token)stack2.pop());
        }
        return object;
    }

    private static FilterExpr createFilterExpr(Lexer lexer, int n) throws XPathException {
        PrimaryExpr primaryExpr = Parser.createPrimaryExpr(lexer);
        if (primaryExpr == null) {
            throw new XPathException(lexer.toString());
        }
        FilterExpr filterExpr = new FilterExpr(primaryExpr, n);
        Parser.parsePredicates(filterExpr, lexer);
        return filterExpr;
    }

    public static FunctionCall createFunctionCall(String string) throws XPathException {
        FunctionCall functionCall = null;
        if ((string = string.intern()) == "true") {
            return new TrueFunctionCall();
        }
        if (string == "false") {
            return new FalseFunctionCall();
        }
        if (string == "not") {
            functionCall = new NotFunctionCall();
        } else if (string == "boolean") {
            functionCall = new BooleanFunctionCall();
        } else if (string == "lang") {
            functionCall = new LangFunctionCall();
        } else {
            if (string == "position") {
                return new PositionFunctionCall();
            }
            if (string == "last") {
                return new LastFunctionCall();
            }
            if (string == "count") {
                functionCall = new CountFunctionCall();
            } else if (string == "local-name") {
                functionCall = new XMLNamesFunctionCall(1);
            } else if (string == "namespace-uri") {
                functionCall = new XMLNamesFunctionCall(3);
            } else if (string == "name") {
                functionCall = new XMLNamesFunctionCall();
            } else if (string == "id") {
                functionCall = new IdFunctionCall();
            } else if (string == "idref") {
                functionCall = new IdRefFunctionCall();
            } else {
                if (string == "text") {
                    return new TextFunctionCall();
                }
                if (string == "concat") {
                    functionCall = new Concat();
                } else if (string == "contains") {
                    functionCall = new Contains();
                } else if (string == "format-number") {
                    functionCall = new FormatNumber();
                } else if (string == "normalize-space") {
                    functionCall = new Normalize();
                } else if (string == "starts-with") {
                    functionCall = new StartsWith();
                } else if (string == "string") {
                    functionCall = new StringFunctionCall();
                } else if (string == "string-length") {
                    functionCall = new StringLength();
                } else if (string == "substring") {
                    functionCall = new Substring();
                } else if (string == "substring-before") {
                    functionCall = new SubstringBefore();
                } else if (string == "substring-after") {
                    functionCall = new SubstringAfter();
                } else if (string == "translate") {
                    functionCall = new Translate();
                } else if (string == "sum") {
                    functionCall = new SumFunctionCall();
                } else if (string == "number") {
                    functionCall = new NumberFunctionCall();
                } else if (string == "floor") {
                    functionCall = new NumberFunctionCall(2);
                } else if (string == "ceiling") {
                    functionCall = new NumberFunctionCall(3);
                } else if (string == "round") {
                    functionCall = new NumberFunctionCall(1);
                }
            }
        }
        if (functionCall == null) {
            functionCall = new ExtensionFunctionCall(string);
        }
        return functionCall;
    }

    public static XPathExpression createLiteralExpr(String string) {
        return new LiteralExpr(string);
    }

    private static LocationStep createLocationStep(Lexer lexer, int n) throws XPathException {
        LocationStep locationStep = new LocationStep(n);
        Token token = lexer.lookAhead(0);
        int n2 = 3;
        int n3 = 1;
        switch (token.type) {
            case 601: {
                n2 = 0;
                break;
            }
            case 602: {
                n2 = 1;
                break;
            }
            case 603: {
                n2 = 2;
                break;
            }
            case 604: {
                n2 = 3;
                break;
            }
            case 605: {
                n2 = 4;
                break;
            }
            case 606: {
                n2 = 5;
                break;
            }
            case 607: {
                n2 = 6;
                break;
            }
            case 608: {
                n2 = 7;
                break;
            }
            case 609: {
                n2 = 8;
                break;
            }
            case 610: {
                n2 = 9;
                break;
            }
            case 611: {
                n2 = 10;
                break;
            }
            case 612: {
                n2 = 11;
                break;
            }
            case 613: {
                n2 = 12;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        int n4 = 0;
        while (n4 < n3) {
            lexer.nextToken();
            ++n4;
        }
        NodeExpression nodeExpression = Parser.createNodeExpr(lexer, (short)n2);
        if (nodeExpression == null) {
            String string = "error creating node expression from: ";
            throw new XPathException(String.valueOf(string) + lexer.toString());
        }
        locationStep.setNodeExpr(nodeExpression);
        Parser.parsePredicates(locationStep, lexer);
        if (!n3) {
            switch (nodeExpression.getNodeExprType()) {
                case 4: {
                    n2 = 11;
                    break;
                }
                case 5: {
                    n2 = 8;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 10: {
                    n2 = 12;
                    break;
                }
            }
        }
        locationStep.setAxisIdentifier((short)n2);
        return locationStep;
    }

    public static MatchExpression createMatchExpr(String string) throws XPathException {
        UnionExpr unionExpr = Parser.createUnionExpr(string);
        return unionExpr;
    }

    private static NodeExpression createNodeExpr(Lexer lexer, short s) throws XPathException {
        NodeExpression nodeExpression;
        block30: {
            Token token;
            block29: {
                nodeExpression = null;
                token = lexer.nextToken();
                if (token == null) {
                    return null;
                }
                if (!lexer.hasMoreTokens() || lexer.lookAhead((int)0).type != 1) break block29;
                Object var4_4 = null;
                lexer.nextToken();
                Token token2 = lexer.nextToken();
                if (token2 == null) {
                    Parser.unexpectedToken(lexer.toString(), null);
                }
                String string = null;
                while (token2.type != 2) {
                    string = string == null ? token2.value : String.valueOf(string) + token2.value;
                    token2 = lexer.nextToken();
                    if (token2 != null) continue;
                    Parser.unexpectedToken(lexer.toString(), null);
                }
                switch (token.type) {
                    case 203: {
                        nodeExpression = new TextExpression();
                        break block30;
                    }
                    case 202: {
                        nodeExpression = new CommentExpr();
                        break block30;
                    }
                    case 204: {
                        nodeExpression = new PIExpr(string);
                        break block30;
                    }
                    case 201: {
                        nodeExpression = new AnyNodeExpr();
                        break block30;
                    }
                    default: {
                        throw new XPathException("Not a valid NodeExpr token: " + token.value);
                    }
                }
            }
            switch (token.type) {
                case 804: {
                    Token token3 = lexer.nextToken();
                    switch (token3.type) {
                        default: {
                            Parser.unexpectedToken(lexer.toString(), token3);
                        }
                        case 101: 
                        case 102: 
                    }
                    String string = token.value;
                    nodeExpression = new ElementExpr(token3.value);
                    break;
                }
                case 7: {
                    Token token4 = lexer.nextToken();
                    switch (token4.type) {
                        default: {
                            Parser.unexpectedToken(lexer.toString(), token4);
                        }
                        case 101: 
                        case 102: 
                    }
                    nodeExpression = new AttributeExpr(token4.value);
                    break;
                }
                case 603: {
                    nodeExpression = new AttributeExpr(token.value);
                    break;
                }
                case 613: {
                    nodeExpression = new NamespaceExpr(token.value);
                    break;
                }
                case 802: {
                    nodeExpression = new IdentityExpr();
                    break;
                }
                case 803: {
                    nodeExpression = new ParentExpr();
                    break;
                }
                case 101: {
                    if (s == 2) {
                        nodeExpression = new AttributeExpr(token.value);
                        break;
                    }
                    if (s == 12) {
                        nodeExpression = new NamespaceExpr(token.value);
                        break;
                    }
                    nodeExpression = wildCardExpr;
                    break;
                }
                case 401: {
                    throw new XPathException("Primary expr out of place");
                }
                default: {
                    if (s == 2) {
                        nodeExpression = new AttributeExpr(token.value);
                        break;
                    }
                    if (s == 12) {
                        nodeExpression = new NamespaceExpr(token.value);
                        break;
                    }
                    nodeExpression = new ElementExpr(token.value);
                    break;
                }
            }
        }
        return nodeExpression;
    }

    public static PathExpr createPathExpr(String string) throws XPathException {
        Lexer lexer = null;
        try {
            lexer = new Lexer(string);
        }
        catch (ParseException parseException) {
            return new PathExpr(new ErrorExpr(parseException.getMessage()));
        }
        return Parser.createPathExpr(lexer);
    }

    private static PathExpr createPathExpr(Lexer lexer) throws XPathException {
        PathExpr pathExpr = new PathExpr();
        PathExpr pathExpr2 = null;
        if (!lexer.hasMoreTokens()) {
            return pathExpr;
        }
        int n = 0;
        Token token = lexer.lookAhead(0);
        if (token.type == 306) {
            lexer.nextToken();
            if (!lexer.hasMoreTokens()) {
                return new RootExpr();
            }
            n = 1;
        } else if (token.type == 307) {
            n = 1;
            lexer.nextToken();
            pathExpr2 = Parser.createDescendantOrSelf();
        }
        if (!lexer.hasMoreTokens()) {
            if (pathExpr2 != null) {
                return pathExpr2;
            }
            return pathExpr;
        }
        token = lexer.lookAhead(0);
        FilterBase filterBase = null;
        filterBase = Parser.isLocationStepToken(token) ? Parser.createLocationStep(lexer, n) : Parser.createFilterExpr(lexer, n);
        pathExpr.setFilter(filterBase);
        if (lexer.hasMoreTokens() && !Lexer.isBinaryOp(token = lexer.lookAhead(0))) {
            switch (token.type) {
                default: {
                    pathExpr.setSubPath(Parser.createPathExpr(lexer));
                }
                case 2: 
                case 4: 
                case 6: 
                case 308: 
            }
        }
        if (pathExpr2 != null) {
            pathExpr2.setSubPath(pathExpr);
            pathExpr = pathExpr2;
        }
        return pathExpr;
    }

    private static PrimaryExpr createPrimaryExpr(Lexer lexer) throws XPathException {
        PrimaryExpr primaryExpr = null;
        if (!lexer.hasMoreTokens()) {
            Parser.missingExpr(lexer.toString(), null);
        }
        Token token = lexer.nextToken();
        switch (token.type) {
            case 1: {
                primaryExpr = new InnerExpr(Parser.createExpr(lexer));
                token = lexer.nextToken();
                if (token.type == 2) break;
                Parser.unexpectedToken(lexer.toStringPrevious(), token);
                break;
            }
            case 801: {
                primaryExpr = new VariableReference(token.value);
                break;
            }
            case 701: {
                primaryExpr = new LiteralExpr(token.value);
                break;
            }
            case 501: {
                String string = token.value;
                FunctionCall functionCall = Parser.createFunctionCall(string);
                Parser.parseParams(functionCall, lexer);
                primaryExpr = functionCall;
                break;
            }
            case 401: {
                try {
                    Double d = Double.valueOf(token.value);
                    primaryExpr = new NumberExpr(d);
                }
                catch (NumberFormatException numberFormatException) {
                    primaryExpr = new LiteralExpr(token.value);
                }
                break;
            }
        }
        if (primaryExpr == null) {
            throw new XPathException("Invalid PrimaryExpr: " + lexer.toStringPrevious() + " ->{" + token.toString() + "}");
        }
        return primaryExpr;
    }

    public static SelectExpr createSelectExpr(String string) throws XPathException {
        SelectExpr selectExpr = new SelectExpr();
        selectExpr.setUnionExpr(Parser.createUnionExpr(string));
        return selectExpr;
    }

    public static UnionExpr createUnionExpr(String string) throws XPathException {
        Lexer lexer = null;
        try {
            lexer = new Lexer(string);
        }
        catch (ParseException parseException) {
            return new UnionExpr(new ErrorExpr(parseException.getMessage()));
        }
        return Parser.createUnionExpr(lexer);
    }

    private static UnionExpr createUnionExpr(Lexer lexer) throws XPathException {
        UnionExpr unionExpr = new UnionExpr(Parser.createPathExpr(lexer));
        if (lexer.hasMoreTokens()) {
            Token token = lexer.nextToken();
            if (token.type == 308) {
                unionExpr.setUnionExpr(Parser.createUnionExpr(lexer));
            } else {
                lexer.pushBack();
            }
        }
        return unionExpr;
    }

    private static boolean hasGreaterPrecedence(Token token, Token token2) {
        if (Lexer.isMultiplicativeOp(token)) {
            return !Lexer.isMultiplicativeOp(token2);
        }
        if (Lexer.isAdditiveOp(token)) {
            if (Lexer.isAdditiveOp(token2)) {
                return false;
            }
            return Lexer.isMultiplicativeOp(token2) ^ true;
        }
        if (Lexer.isRelationalOp(token)) {
            if (Lexer.isRelationalOp(token2)) {
                return false;
            }
            if (Lexer.isAdditiveOp(token2)) {
                return false;
            }
            return Lexer.isMultiplicativeOp(token2) ^ true;
        }
        if (Lexer.isEqualityOp(token)) {
            if (Lexer.isEqualityOp(token2)) {
                return false;
            }
            if (Lexer.isRelationalOp(token2)) {
                return false;
            }
            if (Lexer.isAdditiveOp(token2)) {
                return false;
            }
            return Lexer.isMultiplicativeOp(token2) ^ true;
        }
        if (token.type == 301) {
            if (token2.type == 301) {
                return false;
            }
            return token2.type == 302;
        }
        return token2.type != 302;
    }

    private static boolean isLocationStepToken(Token token) {
        if (token == null) {
            return false;
        }
        if (Lexer.isAxisIdentifier(token)) {
            return true;
        }
        return Parser.isNodeTypeToken(token);
    }

    private static boolean isNodeTypeToken(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 7: 
            case 101: 
            case 102: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 802: 
            case 803: 
            case 804: {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] stringArray) throws XPathException {
        String[] stringArray2 = new String[]{"*", "foo:*", "//pi()", "cellphone.e-catalog", "//elementA/elementB", "../elementA[@name=$name][@type='foo']", "elementA", "elementA | elementB", "element-A | element-B | element-C", "element-A[@attr and (not(position() = 1))]", "$my-variable/child", "/*", "node()", "a/div/b/and/c", "foo//bar"};
        String[] stringArray3 = new String[]{"position() != last()", "position() mod 2 = 0", "(position() mod 2) = 0", "count((//@name)[1])", "4+5*3+(8-3)*6*2+3", "$my-variable/child", "@*[name(.)!='href']", "vin/text() = $process/order/orderRef/text()", "$booklist[author=$authorlist]/title", "$foo mod 4", "cname mod 4"};
        System.out.println("UnionExpr Tests\n");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("Test:   " + stringArray2[n]);
            System.out.print("Result: ");
            System.out.println(Parser.createUnionExpr(stringArray2[n]));
            ++n;
        }
        System.out.println();
        System.out.println("Expr Tests\n");
        int n2 = 0;
        while (n2 < stringArray3.length) {
            System.out.println("Test:   " + stringArray3[n2]);
            XPathExpression xPathExpression = Parser.createExpr(stringArray3[n2]);
            System.out.print("Result: ");
            System.out.println(xPathExpression);
            System.out.println("Expr Type: " + xPathExpression.getExprType());
            ++n2;
        }
    }

    private static void missingExpr(String string, Token token) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer(INVALID_EXPR);
        stringBuffer.append(string);
        stringBuffer.append("; '");
        if (token != null) {
            stringBuffer.append(token.value);
        }
        stringBuffer.append("' -> missing remainder of expression.");
        throw new XPathException(stringBuffer.toString());
    }

    private static void parseParams(FunctionCall functionCall, Lexer lexer) throws XPathException {
        Token token = lexer.nextToken();
        if (token.type != 1) {
            Parser.missingExpr(lexer.toString(), token);
        }
        while (true) {
            if (!lexer.hasMoreTokens()) {
                Parser.missingExpr(lexer.toString(), token);
            }
            token = lexer.lookAhead(0);
            if (token.type == 2) {
                lexer.nextToken();
                break;
            }
            functionCall.addParameter(Parser.createExpr(lexer));
            token = lexer.nextToken();
            if (token == null) continue;
            if (token.type == 2) break;
            if (token.type == 6) continue;
            Parser.unexpectedToken(lexer.toString(), token);
        }
    }

    private static void parsePredicates(FilterBase filterBase, Lexer lexer) throws XPathException {
        while (lexer.hasMoreTokens() && lexer.lookAhead((int)0).type == 3) {
            lexer.nextToken();
            XPathExpression xPathExpression = Parser.createExpr(lexer);
            filterBase.addPredicate(xPathExpression);
            Token token = lexer.nextToken();
            if (token != null && token.type == 4) continue;
            Parser.unexpectedToken(lexer.toString(), token);
        }
    }

    private static void unexpectedToken(String string, Token token) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer(INVALID_EXPR);
        stringBuffer.append(string);
        stringBuffer.append("; '");
        if (token != null) {
            stringBuffer.append(token.value);
        } else {
            stringBuffer.append("NULL");
        }
        stringBuffer.append("' is unexpected.");
        throw new XPathException(stringBuffer.toString());
    }
}

